/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.var.schemes;

import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.service.BranchService;
import org.kuali.rice.kew.engine.node.var.Property;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.xml.sax.InputSource;

public class XPathScheme
implements PropertyScheme {
    private static final Logger LOG = Logger.getLogger(XPathScheme.class);

    @Override
    public String getName() {
        return "xpath";
    }

    @Override
    public String getShortName() {
        return "xpath";
    }

    @Override
    public Object load(Property property, final RouteContext context) {
        XPath xpath = XPathHelper.newXPath();
        final BranchService branchService = KEWServiceLocator.getBranchService();
        xpath.setXPathVariableResolver(new XPathVariableResolver(){

            @Override
            public Object resolveVariable(QName name) {
                LOG.debug((Object)("Resolving XPath variable: " + name));
                String value = branchService.getScopedVariableValue(context.getNodeInstance().getBranch(), "var::" + name.getLocalPart());
                LOG.debug((Object)("Resolved XPath variable " + name + " to " + value));
                return value;
            }
        });
        try {
            String docContent = context.getDocument().getDocContent();
            LOG.debug((Object)("Executing xpath expression '" + property.locator + "' in doc '" + docContent + "'"));
            return xpath.evaluate(property.locator, new InputSource(new StringReader(docContent)), XPathConstants.STRING);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException("Error evaluating xpath expression '" + property.locator + "'", xpee);
        }
    }
}

