/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.action;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.reflect.DataDefinition;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionInvocation;
import org.kuali.rice.kew.api.action.ActionInvocationQueue;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class ActionInvocationQueueImpl
implements ActionInvocationQueue {
    private static final Logger LOG = Logger.getLogger(ActionInvocationQueueImpl.class);

    public void invokeAction(String principalId, String documentId, ActionInvocation invocation) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId is null or blank");
        }
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId is null");
        }
        if (invocation == null) {
            throw new RiceIllegalArgumentException("invocation is null");
        }
        KEWServiceLocator.getRouteHeaderService().lockRouteHeader(documentId, true);
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(principalId);
        ArrayList<DataDefinition> parameters = new ArrayList<DataDefinition>();
        parameters.add(new DataDefinition((Object)document));
        parameters.add(new DataDefinition((Object)principal));
        parameters.add(new DataDefinition((Object)""));
        try {
            ActionTakenEvent action = KEWServiceLocator.getActionRegistry().createAction(invocation.getAction().getCode(), parameters);
            if (!document.isValidActionToTake(invocation.getAction().getCode())) {
                LOG.warn((Object)("Action " + invocation.getAction() + " is not a valid action to take against document " + document.getDocumentId() + " by principal with name '" + principal.getPrincipalName() + "'"));
                return;
            }
            if (!KEWServiceLocator.getActionRegistry().getValidActions((PrincipalContract)principal, document).getValidActions().contains(ActionType.fromCode((String)action.getActionTakenCode()))) {
                LOG.warn((Object)("Action " + action.getActionTakenCode() + " is not valid for document " + document.getDocumentId() + " by principal with name '" + principal.getPrincipalName() + "'"));
                return;
            }
            action.performAction();
        }
        catch (ResourceUnavailableException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
        catch (InvalidActionTakenException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }
}

