/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.peopleflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.util.VersionHelper;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDefinition;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDelegate;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowMember;
import org.kuali.rice.kew.api.repository.type.KewTypeDefinition;
import org.kuali.rice.kew.api.repository.type.KewTypeRepositoryService;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.framework.peopleflow.PeopleFlowTypeService;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowRequestGenerator;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueContent;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;

public class PeopleFlowRequestGeneratorImpl
implements PeopleFlowRequestGenerator {
    private KewTypeRepositoryService typeRepositoryService;
    private RoleService roleService;

    @Override
    public List<ActionRequestValue> generateRequests(RouteContext routeContext, PeopleFlowDefinition peopleFlow, ActionRequestType actionRequested) {
        Context context = new Context(routeContext, peopleFlow, actionRequested);
        for (PeopleFlowMember member : peopleFlow.getMembers()) {
            this.generateRequestForMember(context, member);
        }
        return context.getActionRequestFactory().getRequestGraphs();
    }

    protected void generateRequestForMember(Context context, PeopleFlowMember member) {
        ArrayList<ActionRequestValue> memberRequests = new ArrayList<ActionRequestValue>();
        if (MemberType.ROLE == member.getMemberType()) {
            memberRequests.addAll(this.findNonRoleRequests(this.generateRequestsForRoleMember(context, member)));
        } else {
            ActionRequestValue actionRequest = context.getActionRequestFactory().addRootActionRequest(context.getActionRequested().getCode(), member.getPriority(), this.toRecipient(member), "", member.getResponsibilityId(), Boolean.TRUE, this.getActionRequestPolicyCode(member), null);
            if (actionRequest != null) {
                memberRequests.add(actionRequest);
            }
        }
        this.generateDelegationRequests(context, memberRequests, member);
    }

    protected List<ActionRequestValue> generateRequestsForRoleMember(Context context, PeopleFlowMember member) {
        boolean hasPeopleFlowDelegates;
        ArrayList<ActionRequestValue> roleMemberRequests = new ArrayList<ActionRequestValue>();
        List<Map<String, String>> roleQualifierMaps = this.loadRoleQualifiers(context, member.getMemberId());
        Role role = this.getRoleService().getRole(member.getMemberId());
        boolean bl = hasPeopleFlowDelegates = !CollectionUtils.isEmpty((Collection)member.getDelegates());
        if (role == null) {
            throw new IllegalStateException("Failed to locate a role with the given role id of '" + member.getMemberId() + "'");
        }
        if (CollectionUtils.isEmpty(roleQualifierMaps)) {
            ActionRequestValue request = this.addKimRoleRequest(context, member, role, Collections.emptyMap(), hasPeopleFlowDelegates);
            if (request != null) {
                roleMemberRequests.add(request);
            }
        } else {
            for (Map<String, String> roleQualifiers : roleQualifierMaps) {
                ActionRequestValue request = this.addKimRoleRequest(context, member, role, roleQualifiers, hasPeopleFlowDelegates);
                if (request == null) continue;
                roleMemberRequests.add(request);
            }
        }
        return roleMemberRequests;
    }

    private ActionRequestValue addKimRoleRequest(Context context, PeopleFlowMember member, Role role, Map<String, String> roleQualifiers, boolean ignoreKimDelegates) {
        ActionRequestValue roleMemberRequest = null;
        List memberships = this.getRoleService().getRoleMembers(Collections.singletonList(member.getMemberId()), roleQualifiers);
        String actionRequestPolicyCode = this.getActionRequestPolicyCode(member);
        if (!CollectionUtils.isEmpty((Collection)memberships)) {
            roleMemberRequest = context.getActionRequestFactory().addKimRoleRequest(context.getActionRequested().getCode(), member.getPriority(), role, memberships, null, member.getResponsibilityId(), true, actionRequestPolicyCode, null, ignoreKimDelegates);
        }
        return roleMemberRequest;
    }

    private void generateDelegationRequests(Context context, List<ActionRequestValue> memberRequests, PeopleFlowMember member) {
        if (CollectionUtils.isEmpty((Collection)member.getDelegates()) || CollectionUtils.isEmpty(memberRequests)) {
            return;
        }
        for (PeopleFlowDelegate delegate : member.getDelegates()) {
            for (ActionRequestValue memberRequest : memberRequests) {
                if (MemberType.ROLE == delegate.getMemberType()) {
                    this.generateDelegationToRoleRequests(context, memberRequest, member, delegate);
                    continue;
                }
                this.generateDelegationToNonRoleRequest(context, memberRequest, member, delegate);
            }
        }
    }

    private void generateDelegationToNonRoleRequest(Context context, ActionRequestValue memberRequest, PeopleFlowMember member, PeopleFlowDelegate delegate) {
        Recipient recipient;
        if (MemberType.PRINCIPAL == delegate.getMemberType()) {
            recipient = new KimPrincipalRecipient(delegate.getMemberId());
        } else if (MemberType.GROUP == delegate.getMemberType()) {
            recipient = new KimGroupRecipient(delegate.getMemberId());
        } else {
            throw new RiceIllegalStateException("MemberType unknown: " + delegate.getMemberType());
        }
        String actionRequestPolicyCode = this.getDelegateActionRequestPolicyCode(member, delegate);
        String delegationAnnotation = this.generateDelegationAnnotation(memberRequest, member, delegate);
        context.getActionRequestFactory().addDelegationRequest(memberRequest, recipient, delegate.getResponsibilityId(), memberRequest.getForceAction(), delegate.getDelegationType(), actionRequestPolicyCode, delegationAnnotation, null);
    }

    private String generateDelegationAnnotation(ActionRequestValue parentRequest, PeopleFlowMember member, PeopleFlowDelegate delegate) {
        StringBuffer annotation = new StringBuffer("Delegation of: ");
        annotation.append(parentRequest.getAnnotation());
        annotation.append(" to ");
        if (delegate.getMemberType() == MemberType.PRINCIPAL) {
            annotation.append("principal ");
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(delegate.getMemberId());
            if (principal != null) {
                annotation.append(principal.getPrincipalName());
            } else {
                annotation.append(member.getMemberId());
            }
        } else if (delegate.getMemberType() == MemberType.GROUP) {
            annotation.append("group ");
            Group group = KimApiServiceLocator.getGroupService().getGroup(delegate.getMemberId());
            if (group != null) {
                annotation.append(group.getNamespaceCode()).append('/').append(group.getName());
            } else {
                annotation.append(member.getMemberId());
            }
        } else {
            annotation.append("?????? '");
            annotation.append(member.getMemberId());
            annotation.append("'");
        }
        return annotation.toString();
    }

    protected void generateDelegationToRoleRequests(Context context, ActionRequestValue parentRequest, PeopleFlowMember member, PeopleFlowDelegate delegate) {
        List<Map<String, String>> roleQualifierList = this.loadRoleQualifiers(context, delegate.getMemberId());
        Role role = this.getRoleService().getRole(delegate.getMemberId());
        if (role == null) {
            throw new IllegalStateException("Failed to locate a role with the given role id of '" + delegate.getMemberId() + "'");
        }
        if (CollectionUtils.isEmpty(roleQualifierList)) {
            this.addKimRoleDelegateRequest(context, parentRequest, member, delegate, role, Collections.emptyMap());
        } else {
            for (Map<String, String> roleQualifiers : roleQualifierList) {
                this.addKimRoleDelegateRequest(context, parentRequest, member, delegate, role, roleQualifiers);
            }
        }
    }

    private void addKimRoleDelegateRequest(Context context, ActionRequestValue parentRequest, PeopleFlowMember member, PeopleFlowDelegate delegate, Role role, Map<String, String> roleQualifiers) {
        if (delegate.getMemberType() != MemberType.ROLE) {
            throw new RiceIllegalArgumentException("delegate's member type must be ROLE");
        }
        if (!delegate.getMemberId().equals(role.getId())) {
            throw new RiceIllegalArgumentException("delegate's member id must match the given role's id");
        }
        String actionRequestPolicyCode = this.getDelegateActionRequestPolicyCode(member, delegate);
        List memberships = this.getRoleService().getRoleMembers(Collections.singletonList(delegate.getMemberId()), roleQualifiers);
        if (!CollectionUtils.isEmpty((Collection)memberships)) {
            context.getActionRequestFactory().addDelegateKimRoleRequest(parentRequest, delegate.getDelegationType(), context.getActionRequested().getCode(), member.getPriority(), role, memberships, null, delegate.getResponsibilityId(), true, actionRequestPolicyCode, null);
        }
    }

    protected List<Map<String, String>> loadRoleQualifiers(Context context, String roleId) {
        PeopleFlowTypeService peopleFlowTypeService = context.getPeopleFlowTypeService();
        ArrayList<Map<String, String>> roleQualifierList = new ArrayList<Map<String, String>>();
        if (peopleFlowTypeService != null) {
            List multipleRoleQualifiers;
            boolean versionOk;
            Document document = DocumentRouteHeaderValue.to(context.getRouteContext().getDocument());
            DocumentRouteHeaderValueContent content = new DocumentRouteHeaderValueContent(document.getDocumentId());
            content.setDocumentContent(context.getRouteContext().getDocumentContent().getDocContent());
            DocumentContent documentContent = DocumentRouteHeaderValueContent.to(content);
            Map roleQualifiers = peopleFlowTypeService.resolveRoleQualifiers(context.getPeopleFlow().getTypeId(), roleId, document, documentContent);
            if (roleQualifiers != null) {
                roleQualifierList.add(roleQualifiers);
            }
            boolean bl = versionOk = VersionHelper.compareVersion((String)context.getPeopleFlowTypeServiceVersion(), (String)"2.3.0") != -1;
            if (versionOk && (multipleRoleQualifiers = peopleFlowTypeService.resolveMultipleRoleQualifiers(context.getPeopleFlow().getTypeId(), roleId, document, documentContent)) != null) {
                roleQualifierList.addAll(multipleRoleQualifiers);
            }
        }
        return roleQualifierList;
    }

    private String getDelegateActionRequestPolicyCode(PeopleFlowMember member, PeopleFlowDelegate delegate) {
        ActionRequestPolicy actionRequestPolicy = delegate.getActionRequestPolicy();
        return actionRequestPolicy != null ? actionRequestPolicy.getCode() : this.getActionRequestPolicyCode(member);
    }

    private String getActionRequestPolicyCode(PeopleFlowMember member) {
        ActionRequestPolicy actionRequestPolicy = member.getActionRequestPolicy();
        return actionRequestPolicy != null ? actionRequestPolicy.getCode() : null;
    }

    private Recipient toRecipient(PeopleFlowMember member) {
        Recipient recipient;
        if (MemberType.PRINCIPAL == member.getMemberType()) {
            recipient = new KimPrincipalRecipient(member.getMemberId());
        } else if (MemberType.GROUP == member.getMemberType()) {
            recipient = new KimGroupRecipient(member.getMemberId());
        } else {
            throw new IllegalStateException("encountered a member type which I did not understand: " + member.getMemberType());
        }
        return recipient;
    }

    private Recipient toRecipient(PeopleFlowDelegate delegate) {
        Recipient recipient;
        if (MemberType.PRINCIPAL == delegate.getMemberType()) {
            recipient = new KimPrincipalRecipient(delegate.getMemberId());
        } else if (MemberType.GROUP == delegate.getMemberType()) {
            recipient = new KimGroupRecipient(delegate.getMemberId());
        } else {
            throw new IllegalStateException("encountered a delegate member type which I did not understand: " + delegate.getMemberType());
        }
        return recipient;
    }

    public KewTypeRepositoryService getTypeRepositoryService() {
        return this.typeRepositoryService;
    }

    public void setTypeRepositoryService(KewTypeRepositoryService typeRepositoryService) {
        this.typeRepositoryService = typeRepositoryService;
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    private List<ActionRequestValue> findNonRoleRequests(List<ActionRequestValue> actionRequestValues) {
        ArrayList<ActionRequestValue> nonRoleRequests = new ArrayList<ActionRequestValue>();
        return this.findNonRoleRequests(actionRequestValues, nonRoleRequests);
    }

    private List<ActionRequestValue> findNonRoleRequests(List<ActionRequestValue> actionRequestValues, List<ActionRequestValue> nonRoleRequests) {
        if (!CollectionUtils.isEmpty(actionRequestValues)) {
            for (ActionRequestValue request : actionRequestValues) {
                if (request.getDelegationType() != null) continue;
                if (!CollectionUtils.isEmpty(request.getChildrenRequests())) {
                    this.findNonRoleRequests(request.getChildrenRequests(), nonRoleRequests);
                    continue;
                }
                if (RecipientType.ROLE.getCode() == request.getRecipientTypeCd()) continue;
                nonRoleRequests.add(request);
            }
        }
        return nonRoleRequests;
    }

    final class Context {
        private final RouteContext routeContext;
        private final PeopleFlowDefinition peopleFlow;
        private final ActionRequestType actionRequested;
        private final ActionRequestFactory actionRequestFactory;
        private PeopleFlowTypeService peopleFlowTypeService;
        private boolean peopleFlowTypeServiceLoaded = false;
        private String peopleFlowTypeServiceVersion;

        Context(RouteContext routeContext, PeopleFlowDefinition peopleFlow, ActionRequestType actionRequested) {
            if (routeContext == null) {
                throw new IllegalArgumentException("routeContext was null");
            }
            if (peopleFlow == null) {
                throw new IllegalArgumentException("peopleFlow was null");
            }
            if (!peopleFlow.isActive()) {
                throw new ConfigurationException("Attempted to route to a PeopleFlow that is not active! " + peopleFlow);
            }
            if (actionRequested == null) {
                actionRequested = ActionRequestType.APPROVE;
            }
            this.routeContext = routeContext;
            this.peopleFlow = peopleFlow;
            this.actionRequested = actionRequested;
            this.actionRequestFactory = new ActionRequestFactory(routeContext);
        }

        RouteContext getRouteContext() {
            return this.routeContext;
        }

        PeopleFlowDefinition getPeopleFlow() {
            return this.peopleFlow;
        }

        ActionRequestType getActionRequested() {
            return this.actionRequested;
        }

        ActionRequestFactory getActionRequestFactory() {
            return this.actionRequestFactory;
        }

        PeopleFlowTypeService getPeopleFlowTypeService() {
            if (this.peopleFlowTypeServiceLoaded) {
                return this.peopleFlowTypeService;
            }
            if (this.getPeopleFlow().getTypeId() != null) {
                KewTypeDefinition typeDefinition = PeopleFlowRequestGeneratorImpl.this.getTypeRepositoryService().getTypeById(this.getPeopleFlow().getTypeId());
                if (typeDefinition == null) {
                    throw new IllegalStateException("Failed to locate a PeopleFlow type for the given type id of '" + this.getPeopleFlow().getTypeId() + "'");
                }
                if (StringUtils.isNotBlank((String)typeDefinition.getServiceName())) {
                    Endpoint endpoint = KsbApiServiceLocator.getServiceBus().getEndpoint(QName.valueOf(typeDefinition.getServiceName()));
                    if (endpoint == null) {
                        throw new IllegalStateException("Failed to load the PeopleFlowTypeService with the name '" + typeDefinition.getServiceName() + "'");
                    }
                    this.peopleFlowTypeService = (PeopleFlowTypeService)endpoint.getService();
                    this.peopleFlowTypeServiceVersion = endpoint.getServiceConfiguration().getServiceVersion();
                }
            }
            this.peopleFlowTypeServiceLoaded = true;
            return this.peopleFlowTypeService;
        }

        String getPeopleFlowTypeServiceVersion() {
            if (!this.peopleFlowTypeServiceLoaded) {
                this.getPeopleFlowTypeService();
            }
            return this.peopleFlowTypeServiceVersion;
        }
    }
}

