/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kew.api.repository.type.KewTypeAttribute;
import org.kuali.rice.kew.api.repository.type.KewTypeAttributeContract;
import org.kuali.rice.kew.api.repository.type.KewTypeDefinition;
import org.kuali.rice.kew.api.repository.type.KewTypeDefinitionContract;
import org.kuali.rice.kew.api.repository.type.KewTypeRepositoryService;
import org.kuali.rice.kew.impl.type.KewTypeAttributeBo;
import org.kuali.rice.kew.impl.type.KewTypeBo;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public final class KewTypeBoServiceImpl
implements KewTypeRepositoryService {
    private BusinessObjectService businessObjectService;

    public KewTypeDefinition createKewType(KewTypeDefinition kewType) {
        String namespaceKey;
        if (kewType == null) {
            throw new RiceIllegalArgumentException("kewType is null");
        }
        String nameKey = kewType.getName();
        KewTypeDefinition existing = this.getTypeByNameAndNamespace(nameKey, namespaceKey = kewType.getNamespace());
        if (existing != null && existing.getName().equals(nameKey) && existing.getNamespace().equals(namespaceKey)) {
            throw new RiceIllegalStateException("The KEW Type to create already exists: " + kewType);
        }
        KewTypeBo bo = (KewTypeBo)this.businessObjectService.save((PersistableBusinessObject)KewTypeBo.from((KewTypeDefinition)kewType));
        return KewTypeBo.to((KewTypeBo)bo);
    }

    public void updateKewType(KewTypeDefinition kewType) {
        KewTypeDefinition toUpdate;
        if (kewType == null) {
            throw new RiceIllegalArgumentException("kewType is null");
        }
        String idKey = kewType.getId();
        KewTypeBo existing = (KewTypeBo)this.businessObjectService.findBySinglePrimaryKey(KewTypeBo.class, (Object)idKey);
        if (existing == null) {
            throw new RiceIllegalStateException("The KEW type does not exist: " + kewType);
        }
        if (!existing.getId().equals(kewType.getId())) {
            KewTypeDefinition.Builder builder = KewTypeDefinition.Builder.create((KewTypeDefinitionContract)kewType);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = kewType;
        }
        this.businessObjectService.save((PersistableBusinessObject)KewTypeBo.from((KewTypeDefinition)toUpdate));
    }

    public KewTypeDefinition getTypeById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id is blank");
        }
        KewTypeBo kewTypeBo = (KewTypeBo)this.businessObjectService.findBySinglePrimaryKey(KewTypeBo.class, (Object)id);
        return KewTypeBo.to((KewTypeBo)kewTypeBo);
    }

    public KewTypeDefinition getTypeByNameAndNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name is blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace is blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        KewTypeBo myType = (KewTypeBo)this.businessObjectService.findByPrimaryKey(KewTypeBo.class, Collections.unmodifiableMap(map));
        return KewTypeBo.to((KewTypeBo)myType);
    }

    public List<KewTypeDefinition> findAllTypesByNamespace(String namespace) {
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace is blank");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namespace", namespace);
        map.put("active", Boolean.TRUE);
        Collection kewTypeBos = this.businessObjectService.findMatching(KewTypeBo.class, Collections.unmodifiableMap(map));
        return this.convertListOfBosToImmutables(kewTypeBos);
    }

    public List<KewTypeDefinition> findAllTypes() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("active", Boolean.TRUE);
        Collection kewTypeBos = this.businessObjectService.findMatching(KewTypeBo.class, Collections.unmodifiableMap(map));
        return this.convertListOfBosToImmutables(kewTypeBos);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    List<KewTypeDefinition> convertListOfBosToImmutables(Collection<KewTypeBo> kewTypeBos) {
        ArrayList<KewTypeDefinition> kewTypes = new ArrayList<KewTypeDefinition>();
        for (KewTypeBo bo : kewTypeBos) {
            KewTypeDefinition kewType = KewTypeBo.to((KewTypeBo)bo);
            kewTypes.add(kewType);
        }
        return Collections.unmodifiableList(kewTypes);
    }

    public void createKewTypeAttribute(KewTypeAttribute kewTypeAttribute) {
        if (kewTypeAttribute == null) {
            throw new RiceIllegalArgumentException("kewTypeAttribute is null");
        }
        String typeIdKey = kewTypeAttribute.getTypeId();
        String attrDefIdKey = kewTypeAttribute.getAttributeDefinitionId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("typeId", typeIdKey);
        map.put("attributeDefinitionId", attrDefIdKey);
        KewTypeAttributeBo existing = (KewTypeAttributeBo)this.businessObjectService.findByPrimaryKey(KewTypeAttributeBo.class, Collections.unmodifiableMap(map));
        if (existing != null && existing.getTypeId().equals(typeIdKey) && existing.getAttributeDefinitionId().equals(attrDefIdKey)) {
            throw new RiceIllegalStateException("The KEW Type Attribute to create already exists: " + kewTypeAttribute);
        }
        KewTypeAttributeBo bo = (KewTypeAttributeBo)this.businessObjectService.save((PersistableBusinessObject)KewTypeAttributeBo.from((KewTypeAttribute)kewTypeAttribute));
    }

    public void updateKewTypeAttribute(KewTypeAttribute kewTypeAttribute) {
        KewTypeAttribute toUpdate;
        if (kewTypeAttribute == null) {
            throw new RiceIllegalArgumentException("kewTypeAttribute is null");
        }
        String idKey = kewTypeAttribute.getId();
        KewTypeAttributeBo existing = (KewTypeAttributeBo)this.businessObjectService.findBySinglePrimaryKey(KewTypeAttributeBo.class, (Object)idKey);
        if (existing == null) {
            throw new RiceIllegalStateException("The KEW type Attribute does not exist: " + kewTypeAttribute);
        }
        if (!existing.getId().equals(kewTypeAttribute.getId())) {
            KewTypeAttribute.Builder builder = KewTypeAttribute.Builder.create((KewTypeAttributeContract)kewTypeAttribute);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = kewTypeAttribute;
        }
        this.businessObjectService.save((PersistableBusinessObject)KewTypeAttributeBo.from((KewTypeAttribute)toUpdate));
    }
}

