/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes.service.impl;

import java.io.File;
import java.util.List;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.notes.dao.NoteDAO;
import org.kuali.rice.kew.notes.service.AttachmentService;
import org.kuali.rice.kew.notes.service.NoteService;

public class NoteServiceImpl
implements NoteService {
    private NoteDAO noteDAO;
    private AttachmentService attachmentService;

    @Override
    public Note getNoteByNoteId(String noteId) {
        return this.getNoteDAO().getNoteByNoteId(noteId);
    }

    @Override
    public List<Note> getNotesByDocumentId(String documentId) {
        return this.getNoteDAO().getNotesByDocumentId(documentId);
    }

    @Override
    public void saveNote(Note note) {
        try {
            if (!note.getAttachments().isEmpty()) {
                for (Attachment attachment : note.getAttachments()) {
                    if (attachment.getAttachedObject() == null) continue;
                    this.attachmentService.persistAttachedFileAndSetAttachmentBusinessObjectValue(attachment);
                }
            }
            this.getNoteDAO().saveNote(note);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteNote(Note note) {
        try {
            if (note != null && !note.getAttachments().isEmpty()) {
                for (Attachment attachment : note.getAttachments()) {
                    this.attachmentService.deleteAttachedFile(attachment);
                }
            }
            if (note != null) {
                this.getNoteDAO().deleteNote(note);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("caught exception deleting attachment", e);
        }
    }

    public NoteDAO getNoteDAO() {
        return this.noteDAO;
    }

    public void setNoteDAO(NoteDAO noteDAO) {
        this.noteDAO = noteDAO;
    }

    @Override
    public void deleteAttachment(Attachment attachment) {
        this.noteDAO.deleteAttachment(attachment);
        try {
            this.attachmentService.deleteAttachedFile(attachment);
        }
        catch (Exception e) {
            throw new RuntimeException("caught exception deleting attachment", e);
        }
    }

    @Override
    public File findAttachmentFile(Attachment attachment) {
        try {
            return this.attachmentService.findAttachedFile(attachment);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Attachment findAttachment(String attachmentId) {
        return this.noteDAO.findAttachment(attachmentId);
    }

    public AttachmentService getAttachmentService() {
        return this.attachmentService;
    }

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }
}

