/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.rule.RuleExtension;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.lookupable.MyColumns;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.GroupRuleResponsibility;
import org.kuali.rice.kew.rule.PersonRuleResponsibility;
import org.kuali.rice.kew.rule.RoleRuleResponsibility;
import org.kuali.rice.kew.rule.RuleExpressionDef;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.service.RuleServiceInternal;
import org.kuali.rice.kew.rule.xmlrouting.GenericXMLRuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREW_RULE_T")
public class RuleBaseValues
extends PersistableBusinessObjectBase
implements RuleContract {
    private static final long serialVersionUID = 6137765574728530156L;
    @Id
    @GeneratedValue(generator="KREW_RTE_TMPL_S")
    @GenericGenerator(name="KREW_RTE_TMPL_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_RTE_TMPL_S"), @Parameter(name="value_column", value="id")})
    @Column(name="RULE_ID")
    private String id;
    @Column(name="NM")
    private String name;
    @Column(name="RULE_TMPL_ID", insertable=false, updatable=false)
    private String ruleTemplateId;
    @Column(name="PREV_VER_RULE_ID")
    private String previousRuleId;
    @Column(name="ACTV_IND")
    private boolean active = true;
    @Column(name="RULE_BASE_VAL_DESC")
    private String description;
    @Column(name="DOC_TYP_NM")
    private String docTypeName;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="FRM_DT")
    private Timestamp fromDateValue;
    @Column(name="TO_DT")
    private Timestamp toDateValue;
    @Column(name="DACTVN_DT")
    private Timestamp deactivationDate;
    @Column(name="CUR_IND")
    private Boolean currentInd = Boolean.TRUE;
    @Column(name="RULE_VER_NBR")
    private Integer versionNbr = new Integer(0);
    @Column(name="FRC_ACTN")
    private boolean forceAction;
    @Fetch(value=FetchMode.SELECT)
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE}, mappedBy="ruleBaseValues")
    private List<RuleResponsibilityBo> ruleResponsibilities;
    @Fetch(value=FetchMode.SELECT)
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE}, mappedBy="ruleBaseValues")
    private List<RuleExtensionBo> ruleExtensions;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RULE_TMPL_ID")
    private RuleTemplateBo ruleTemplate;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE})
    @JoinColumn(name="RULE_EXPR_ID")
    private RuleExpressionDef ruleExpressionDef;
    @Transient
    private RuleBaseValues previousVersion;
    @Column(name="ACTVN_DT")
    private Timestamp activationDate;
    @Column(name="DLGN_IND")
    private Boolean delegateRule = Boolean.FALSE;
    @Column(name="TMPL_RULE_IND")
    private Boolean templateRuleInd = Boolean.FALSE;
    @Transient
    private String returnUrl;
    @Transient
    private String destinationUrl;
    @Transient
    private MyColumns myColumns;
    @Transient
    private List<PersonRuleResponsibility> personResponsibilities = new ArrayList<PersonRuleResponsibility>();
    @Transient
    private List<GroupRuleResponsibility> groupResponsibilities = new ArrayList<GroupRuleResponsibility>();
    @Transient
    private List<RoleRuleResponsibility> roleResponsibilities = new ArrayList<RoleRuleResponsibility>();
    @Transient
    private Map<String, String> fieldValues;
    @Transient
    private String groupReviewerName;
    @Transient
    private String groupReviewerNamespace;
    @Transient
    private String personReviewer;
    @Transient
    private String personReviewerType;

    public RuleBaseValues() {
        this.ruleResponsibilities = new ArrayList<RuleResponsibilityBo>();
        this.ruleExtensions = new ArrayList<RuleExtensionBo>();
        this.fieldValues = new HashMap<String, String>();
    }

    public RuleExpressionDef getRuleExpressionDef() {
        return this.ruleExpressionDef;
    }

    public void setRuleExpressionDef(RuleExpressionDef ruleExpressionDef) {
        this.ruleExpressionDef = ruleExpressionDef;
    }

    public String getRuleTemplateName() {
        if (this.ruleTemplate != null) {
            return this.ruleTemplate.getName();
        }
        return null;
    }

    public RuleBaseValues getPreviousVersion() {
        if (this.previousVersion == null && this.previousRuleId != null) {
            RuleServiceInternal ruleService = (RuleServiceInternal)KEWServiceLocator.getService("enRuleServiceInternal");
            return ruleService.findRuleBaseValuesById(this.previousRuleId);
        }
        return this.previousVersion;
    }

    public void setPreviousVersion(RuleBaseValues previousVersion) {
        this.previousVersion = previousVersion;
    }

    public RuleResponsibilityBo getResponsibility(int index) {
        while (this.getRuleResponsibilities().size() <= index) {
            RuleResponsibilityBo ruleResponsibility = new RuleResponsibilityBo();
            ruleResponsibility.setRuleBaseValues(this);
            this.getRuleResponsibilities().add(ruleResponsibility);
        }
        return this.getRuleResponsibilities().get(index);
    }

    public RuleExtensionBo getRuleExtension(int index) {
        while (this.getRuleExtensions().size() <= index) {
            this.getRuleExtensions().add(new RuleExtensionBo());
        }
        return this.getRuleExtensions().get(index);
    }

    public RuleExtensionValue getRuleExtensionValue(String key) {
        for (RuleExtensionBo ruleExtension : this.getRuleExtensions()) {
            for (RuleExtensionValue ruleExtensionValue : ruleExtension.getExtensionValues()) {
                if (!ruleExtensionValue.getKey().equals(key)) continue;
                return ruleExtensionValue;
            }
        }
        return null;
    }

    public RuleExtensionValue getRuleExtensionValue(String ruleTemplateAttributeId, String key) {
        for (RuleExtensionBo ruleExtension : this.getRuleExtensions()) {
            if (!ruleExtension.getRuleTemplateAttributeId().equals(ruleTemplateAttributeId)) continue;
            for (RuleExtensionValue ruleExtensionValue : ruleExtension.getExtensionValues()) {
                if (!ruleExtensionValue.getKey().equals(key)) continue;
                return ruleExtensionValue;
            }
        }
        return null;
    }

    public String getPreviousRuleId() {
        return this.previousRuleId;
    }

    public void setPreviousRuleId(String previousVersion) {
        this.previousRuleId = previousVersion;
    }

    public void addRuleResponsibility(RuleResponsibilityBo ruleResponsibility) {
        this.addRuleResponsibility(ruleResponsibility, new Integer(this.getRuleResponsibilities().size()));
    }

    public void addRuleResponsibility(RuleResponsibilityBo ruleResponsibility, Integer counter) {
        boolean alreadyAdded = false;
        int location = 0;
        if (counter != null) {
            for (RuleResponsibilityBo ruleResponsibilityRow : this.getRuleResponsibilities()) {
                if (counter == location) {
                    ruleResponsibilityRow.setPriority(ruleResponsibility.getPriority());
                    ruleResponsibilityRow.setActionRequestedCd(ruleResponsibility.getActionRequestedCd());
                    ruleResponsibilityRow.setVersionNumber(ruleResponsibility.getVersionNumber());
                    ruleResponsibilityRow.setRuleBaseValuesId(ruleResponsibility.getRuleBaseValuesId());
                    ruleResponsibilityRow.setRuleResponsibilityName(ruleResponsibility.getRuleResponsibilityName());
                    ruleResponsibilityRow.setRuleResponsibilityType(ruleResponsibility.getRuleResponsibilityType());
                    ruleResponsibilityRow.setApprovePolicy(ruleResponsibility.getApprovePolicy());
                    alreadyAdded = true;
                }
                ++location;
            }
        }
        if (!alreadyAdded) {
            this.getRuleResponsibilities().add(ruleResponsibility);
        }
    }

    public RuleTemplateBo getRuleTemplate() {
        return this.ruleTemplate;
    }

    public void setRuleTemplate(RuleTemplateBo ruleTemplate) {
        this.ruleTemplate = ruleTemplate;
    }

    public String getRuleTemplateId() {
        return this.ruleTemplateId;
    }

    public void setRuleTemplateId(String ruleTemplateId) {
        this.ruleTemplateId = ruleTemplateId;
    }

    public DocumentType getDocumentType() {
        return KEWServiceLocator.getDocumentTypeService().findByName(this.getDocTypeName());
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    public void setDocTypeName(String docTypeName) {
        this.docTypeName = docTypeName;
    }

    public List<RuleExtensionBo> getRuleExtensions() {
        return this.ruleExtensions;
    }

    public Map<String, String> getRuleExtensionMap() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        for (RuleExtensionBo ext : this.getRuleExtensions()) {
            for (RuleExtensionValue value : ext.getExtensionValues()) {
                extensions.put(value.getKey(), value.getValue());
            }
        }
        return extensions;
    }

    public void setRuleExtensions(List<RuleExtensionBo> ruleExtensions) {
        this.ruleExtensions = ruleExtensions;
    }

    public List<RuleResponsibilityBo> getRuleResponsibilities() {
        return this.ruleResponsibilities;
    }

    public void setRuleResponsibilities(List<RuleResponsibilityBo> ruleResponsibilities) {
        this.ruleResponsibilities = ruleResponsibilities;
    }

    public RuleResponsibilityBo getResponsibility(Long ruleResponsibilityKey) {
        for (RuleResponsibilityBo responsibility : this.getRuleResponsibilities()) {
            if (responsibility.getId() == null || !responsibility.getId().equals(ruleResponsibilityKey)) continue;
            return responsibility;
        }
        return null;
    }

    public void removeResponsibility(int index) {
        this.getRuleResponsibilities().remove(index);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getActiveIndDisplay() {
        return CodeTranslator.getActiveIndicatorLabel((Boolean)this.isActive());
    }

    public Boolean getCurrentInd() {
        return this.currentInd;
    }

    public void setCurrentInd(Boolean currentInd) {
        this.currentInd = currentInd;
    }

    public Timestamp getFromDateValue() {
        return this.fromDateValue;
    }

    public DateTime getFromDate() {
        if (this.fromDateValue == null) {
            return null;
        }
        return new DateTime(this.fromDateValue.getTime());
    }

    public void setFromDateValue(Timestamp fromDateValue) {
        this.fromDateValue = fromDateValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Timestamp getToDateValue() {
        return this.toDateValue;
    }

    public DateTime getToDate() {
        if (this.toDateValue == null) {
            return null;
        }
        return new DateTime(this.toDateValue.getTime());
    }

    public void setToDateValue(Timestamp toDateValue) {
        this.toDateValue = toDateValue;
    }

    public Integer getVersionNbr() {
        return this.versionNbr;
    }

    public void setVersionNbr(Integer versionNbr) {
        this.versionNbr = versionNbr;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getFromDateString() {
        if (this.fromDateValue != null) {
            return RiceConstants.getDefaultDateFormat().format(this.fromDateValue);
        }
        return null;
    }

    public String getToDateString() {
        if (this.toDateValue != null) {
            return RiceConstants.getDefaultDateFormat().format(this.toDateValue);
        }
        return null;
    }

    public boolean isForceAction() {
        return this.forceAction;
    }

    public void setForceAction(boolean forceAction) {
        this.forceAction = forceAction;
    }

    public boolean isActive(Date date) {
        boolean isAfterFromDate = this.getFromDateValue() == null || date.after(this.getFromDateValue());
        boolean isBeforeToDate = this.getToDateValue() == null || date.before(this.getToDateValue());
        return this.isActive() && isAfterFromDate && isBeforeToDate;
    }

    public boolean isMatch(DocumentContent docContent) {
        for (RuleTemplateAttributeBo ruleTemplateAttribute : this.getRuleTemplate().getActiveRuleTemplateAttributes()) {
            if (!ruleTemplateAttribute.isWorkflowAttribute()) continue;
            WorkflowRuleAttribute routingAttribute = ruleTemplateAttribute.getWorkflowAttribute();
            RuleAttribute ruleAttribute = ruleTemplateAttribute.getRuleAttribute();
            if (ruleAttribute.getType().equals("RuleXmlAttribute")) {
                ((GenericXMLRuleAttribute)routingAttribute).setExtensionDefinition(RuleAttribute.to(ruleAttribute));
            }
            String className = ruleAttribute.getResourceDescriptor();
            ArrayList<RuleExtension> editedRuleExtensions = new ArrayList<RuleExtension>();
            for (RuleExtensionBo extension : this.getRuleExtensions()) {
                if (!extension.getRuleTemplateAttribute().getRuleAttribute().getResourceDescriptor().equals(className)) continue;
                editedRuleExtensions.add(RuleExtensionBo.to(extension));
            }
            if (routingAttribute.isMatch(docContent, editedRuleExtensions)) continue;
            return false;
        }
        return true;
    }

    public RuleResponsibilityBo findResponsibility(String roleName) {
        for (RuleResponsibilityBo resp : this.getRuleResponsibilities()) {
            if (!"R".equals(resp.getRuleResponsibilityType()) || !roleName.equals(resp.getRuleResponsibilityName())) continue;
            return resp;
        }
        return null;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public Boolean getDelegateRule() {
        return this.delegateRule;
    }

    public void setDelegateRule(Boolean isDelegateRule) {
        this.delegateRule = isDelegateRule;
    }

    public Timestamp getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(Timestamp activationDate) {
        this.activationDate = activationDate;
    }

    public MyColumns getMyColumns() {
        return this.myColumns;
    }

    public void setMyColumns(MyColumns additionalColumns) {
        this.myColumns = additionalColumns;
    }

    public String getDestinationUrl() {
        return this.destinationUrl;
    }

    public void setDestinationUrl(String destinationUrl) {
        this.destinationUrl = destinationUrl;
    }

    public Timestamp getDeactivationDate() {
        return this.deactivationDate;
    }

    public void setDeactivationDate(Timestamp deactivationDate) {
        this.deactivationDate = deactivationDate;
    }

    public Boolean getTemplateRuleInd() {
        return this.templateRuleInd;
    }

    public void setTemplateRuleInd(Boolean templateRuleInd) {
        this.templateRuleInd = templateRuleInd;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<PersonRuleResponsibility> getPersonResponsibilities() {
        return this.personResponsibilities;
    }

    public void setPersonResponsibilities(List<PersonRuleResponsibility> personResponsibilities) {
        this.personResponsibilities = personResponsibilities;
    }

    public List<GroupRuleResponsibility> getGroupResponsibilities() {
        return this.groupResponsibilities;
    }

    public void setGroupResponsibilities(List<GroupRuleResponsibility> groupResponsibilities) {
        this.groupResponsibilities = groupResponsibilities;
    }

    public List<RoleRuleResponsibility> getRoleResponsibilities() {
        return this.roleResponsibilities;
    }

    public void setRoleResponsibilities(List<RoleRuleResponsibility> roleResponsibilities) {
        this.roleResponsibilities = roleResponsibilities;
    }

    public Map<String, String> getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(Map<String, String> fieldValues) {
        this.fieldValues = fieldValues;
    }

    public String getGroupReviewerName() {
        return this.groupReviewerName;
    }

    public String getGroupReviewerNamespace() {
        return this.groupReviewerNamespace;
    }

    public String getPersonReviewer() {
        return this.personReviewer;
    }

    public void setGroupReviewerName(String groupReviewerName) {
        this.groupReviewerName = groupReviewerName;
    }

    public void setGroupReviewerNamespace(String groupReviewerNamespace) {
        this.groupReviewerNamespace = groupReviewerNamespace;
    }

    public void setPersonReviewer(String personReviewer) {
        this.personReviewer = personReviewer;
    }

    public GroupBo getGroupBo() {
        GroupBo groupBo = null;
        if (StringUtils.isNotBlank((String)this.getGroupReviewerName()) && groupBo == null) {
            groupBo = GroupBo.from((Group)KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(this.getGroupReviewerNamespace(), this.getGroupReviewerName()));
        }
        return groupBo;
    }

    public PersonImpl getPersonImpl() {
        return new PersonImpl();
    }

    public String getPersonReviewerType() {
        return this.personReviewerType;
    }

    public void setPersonReviewerType(String personReviewerType) {
        this.personReviewerType = personReviewerType;
    }

    public static Rule to(RuleBaseValues bo) {
        if (bo == null) {
            return null;
        }
        return Rule.Builder.create((RuleContract)bo).build();
    }
}

