/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Version;
import org.apache.commons.lang.ObjectUtils;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.api.util.collect.CollectionUtils;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.api.rule.RuleExtension;
import org.kuali.rice.kew.api.rule.RuleExtensionContract;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.service.KEWServiceLocator;

@Entity
@Table(name="KREW_RULE_EXT_T")
public class RuleExtensionBo
implements RuleExtensionContract,
Serializable {
    private static final long serialVersionUID = 8178135296413950516L;
    @Id
    @GeneratedValue(generator="KREW_RTE_TMPL_S")
    @GenericGenerator(name="KREW_RTE_TMPL_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_RTE_TMPL_S"), @Parameter(name="value_column", value="id")})
    @Column(name="RULE_EXT_ID")
    private String ruleExtensionId;
    @Column(name="RULE_TMPL_ATTR_ID", insertable=false, updatable=false)
    private String ruleTemplateAttributeId;
    @Column(name="RULE_ID", insertable=false, updatable=false)
    private String ruleBaseValuesId;
    @Version
    @Column(name="VER_NBR")
    private Long versionNumber;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RULE_ID")
    private RuleBaseValues ruleBaseValues;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RULE_TMPL_ATTR_ID")
    private RuleTemplateAttributeBo ruleTemplateAttribute;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE}, mappedBy="extension")
    @Fetch(value=FetchMode.SELECT)
    private List<RuleExtensionValue> extensionValues = new ArrayList<RuleExtensionValue>();

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    public List<RuleExtensionValue> getExtensionValues() {
        return this.extensionValues;
    }

    public void setExtensionValues(List<RuleExtensionValue> extensionValues) {
        this.extensionValues = extensionValues;
    }

    public RuleTemplateAttributeBo getRuleTemplateAttribute() {
        return this.ruleTemplateAttribute;
    }

    public Map<String, String> getExtensionValuesMap() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        for (RuleExtensionValue value : this.getExtensionValues()) {
            extensions.put(value.getKey(), value.getValue());
        }
        return extensions;
    }

    public void setRuleTemplateAttribute(RuleTemplateAttributeBo ruleTemplateAttribute) {
        this.ruleTemplateAttribute = ruleTemplateAttribute;
    }

    public RuleExtensionValue getRuleExtensionValue(int index) {
        while (this.getExtensionValues().size() <= index) {
            this.getExtensionValues().add(new RuleExtensionValue());
        }
        return this.getExtensionValues().get(index);
    }

    public RuleBaseValues getRuleBaseValues() {
        return this.ruleBaseValues;
    }

    public void setRuleBaseValues(RuleBaseValues ruleBaseValues) {
        this.ruleBaseValues = ruleBaseValues;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getRuleBaseValuesId() {
        return this.ruleBaseValuesId;
    }

    public void setRuleBaseValuesId(String ruleBaseValuesId) {
        this.ruleBaseValuesId = ruleBaseValuesId;
    }

    public String getRuleExtensionId() {
        return this.ruleExtensionId;
    }

    public void setRuleExtensionId(String ruleExtensionId) {
        this.ruleExtensionId = ruleExtensionId;
    }

    public String getRuleTemplateAttributeId() {
        return this.ruleTemplateAttributeId;
    }

    public void setRuleTemplateAttributeId(String ruleTemplateAttributeId) {
        this.ruleTemplateAttributeId = ruleTemplateAttributeId;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RuleExtensionBo)) {
            return false;
        }
        RuleExtensionBo pred = (RuleExtensionBo)o;
        return ObjectUtils.equals((Object)((Object)this.ruleBaseValues.getRuleTemplate()), (Object)((Object)pred.getRuleBaseValues().getRuleTemplate())) && ObjectUtils.equals((Object)this.ruleTemplateAttribute, (Object)pred.getRuleTemplateAttribute()) && CollectionUtils.collectionsEquivalent(this.extensionValues, pred.getExtensionValues());
    }

    public String toString() {
        return "[RuleExtension: ruleExtensionId=" + this.ruleExtensionId + ", ruleTemplateAttributeId=" + this.ruleTemplateAttributeId + ", ruleBaseValuesId=" + this.ruleBaseValuesId + ", ruleBaseValues=" + (Object)((Object)this.ruleBaseValues) + ", ruleTemplateAttribute=" + this.ruleTemplateAttribute + ", extensionValues=" + this.extensionValues + ", versionNumber=" + this.versionNumber + "]";
    }

    public static RuleExtension to(RuleExtensionBo bo) {
        if (bo == null) {
            return null;
        }
        return RuleExtension.Builder.create((RuleExtensionContract)bo).build();
    }
}

