/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.rule.RuleResponsibility;
import org.kuali.rice.kew.api.rule.RuleResponsibilityContract;
import org.kuali.rice.kew.rule.RoleAttribute;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.user.RoleRecipient;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREW_RULE_RSP_T")
public class RuleResponsibilityBo
extends PersistableBusinessObjectBase
implements RuleResponsibilityContract {
    private static final long serialVersionUID = -1565688857123316797L;
    @Id
    @GeneratedValue(generator="KREW_RSP_S")
    @GenericGenerator(name="KREW_RSP_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_RSP_S"), @Parameter(name="value_column", value="id")})
    @Column(name="RULE_RSP_ID")
    private String id;
    @Column(name="RSP_ID")
    private String responsibilityId;
    @Column(name="RULE_ID", insertable=false, updatable=false)
    private String ruleBaseValuesId;
    @Column(name="ACTN_RQST_CD")
    private String actionRequestedCd;
    @Column(name="NM")
    private String ruleResponsibilityName;
    @Column(name="TYP")
    private String ruleResponsibilityType;
    @Column(name="PRIO")
    private Integer priority;
    @Column(name="APPR_PLCY")
    private String approvePolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RULE_ID")
    private RuleBaseValues ruleBaseValues;

    public Principal getPrincipal() {
        if (this.isUsingPrincipal()) {
            return KEWServiceLocator.getIdentityHelperService().getPrincipal(this.ruleResponsibilityName);
        }
        return null;
    }

    public Group getGroup() {
        if (this.isUsingGroup()) {
            return KimApiServiceLocator.getGroupService().getGroup(this.ruleResponsibilityName);
        }
        return null;
    }

    public String getRole() {
        if (this.isUsingRole()) {
            return this.ruleResponsibilityName;
        }
        return null;
    }

    public String getResolvedRoleName() {
        if (this.isUsingRole()) {
            return this.getRole().substring(this.getRole().indexOf("!") + 1, this.getRole().length());
        }
        return null;
    }

    public String getRoleAttributeName() {
        return this.getRole().substring(0, this.getRole().indexOf("!"));
    }

    public RoleAttribute resolveRoleAttribute() {
        if (this.isUsingRole()) {
            String attributeName = this.getRoleAttributeName();
            return (RoleAttribute)GlobalResourceLoader.getResourceLoader().getObject(new ObjectDefinition(attributeName));
        }
        return null;
    }

    public boolean isUsingRole() {
        return this.ruleResponsibilityName != null && this.ruleResponsibilityType != null && this.ruleResponsibilityType.equals("R");
    }

    public boolean isUsingPrincipal() {
        return this.ruleResponsibilityName != null && !this.ruleResponsibilityName.trim().equals("") && this.ruleResponsibilityType != null && this.ruleResponsibilityType.equals("F");
    }

    public boolean isUsingGroup() {
        return this.ruleResponsibilityName != null && !this.ruleResponsibilityName.trim().equals("") && this.ruleResponsibilityType != null && this.ruleResponsibilityType.equals("G");
    }

    public String getRuleBaseValuesId() {
        return this.ruleBaseValuesId;
    }

    public void setRuleBaseValuesId(String ruleBaseValuesId) {
        this.ruleBaseValuesId = ruleBaseValuesId;
    }

    public RuleBaseValues getRuleBaseValues() {
        return this.ruleBaseValues;
    }

    public void setRuleBaseValues(RuleBaseValues ruleBaseValues) {
        this.ruleBaseValues = ruleBaseValues;
    }

    public String getActionRequestedCd() {
        return this.actionRequestedCd;
    }

    public void setActionRequestedCd(String actionRequestedCd) {
        this.actionRequestedCd = actionRequestedCd;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String ruleResponsibilityId) {
        this.id = ruleResponsibilityId;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getApprovePolicy() {
        return this.approvePolicy;
    }

    public void setApprovePolicy(String approvePolicy) {
        this.approvePolicy = approvePolicy;
    }

    public Object copy(boolean preserveKeys) {
        RuleResponsibilityBo ruleResponsibilityClone = new RuleResponsibilityBo();
        ruleResponsibilityClone.setApprovePolicy(this.getApprovePolicy());
        if (this.actionRequestedCd != null) {
            ruleResponsibilityClone.setActionRequestedCd(this.actionRequestedCd);
        }
        if (this.id != null && preserveKeys) {
            ruleResponsibilityClone.setId(this.id);
        }
        if (this.responsibilityId != null) {
            ruleResponsibilityClone.setResponsibilityId(this.responsibilityId);
        }
        if (this.ruleResponsibilityName != null) {
            ruleResponsibilityClone.setRuleResponsibilityName(this.ruleResponsibilityName);
        }
        if (this.ruleResponsibilityType != null) {
            ruleResponsibilityClone.setRuleResponsibilityType(this.ruleResponsibilityType);
        }
        if (this.priority != null) {
            ruleResponsibilityClone.setPriority(this.priority);
        }
        return ruleResponsibilityClone;
    }

    public String getRuleResponsibilityName() {
        return this.ruleResponsibilityName;
    }

    public void setRuleResponsibilityName(String ruleResponsibilityName) {
        this.ruleResponsibilityName = ruleResponsibilityName;
    }

    public String getRuleResponsibilityType() {
        return this.ruleResponsibilityType;
    }

    public void setRuleResponsibilityType(String ruleResponsibilityType) {
        this.ruleResponsibilityType = ruleResponsibilityType;
    }

    public String getResponsibilityId() {
        return this.responsibilityId;
    }

    public void setResponsibilityId(String responsibilityId) {
        this.responsibilityId = responsibilityId;
    }

    public List<RuleDelegationBo> getDelegationRules() {
        return KEWServiceLocator.getRuleDelegationService().findByResponsibilityId(this.getResponsibilityId());
    }

    public RuleDelegationBo getDelegationRule(int index) {
        return this.getDelegationRules().get(index);
    }

    public String getActionRequestedDisplayValue() {
        return (String)KewApiConstants.ACTION_REQUEST_CODES.get(this.getActionRequestedCd());
    }

    public String getRuleResponsibilityTypeDisplayValue() {
        return (String)KewApiConstants.RULE_RESPONSIBILITY_TYPES.get(this.getRuleResponsibilityType());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RuleResponsibilityBo)) {
            return false;
        }
        RuleResponsibilityBo pred = (RuleResponsibilityBo)((Object)o);
        return ObjectUtils.equals((Object)this.ruleResponsibilityName, (Object)pred.getRuleResponsibilityName()) && ObjectUtils.equals((Object)this.actionRequestedCd, (Object)pred.getActionRequestedCd()) && ObjectUtils.equals((Object)this.priority, (Object)pred.getPriority()) && ObjectUtils.equals((Object)this.approvePolicy, (Object)pred.getApprovePolicy());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.actionRequestedCd).append((Object)this.approvePolicy).append((Object)this.priority).append((Object)this.ruleResponsibilityName).toHashCode();
    }

    public String getGroupId() {
        if (!this.isUsingGroup()) {
            return null;
        }
        return this.getGroup().getId();
    }

    public String getPrincipalId() {
        if (this.getPrincipal() == null) {
            return null;
        }
        return this.getPrincipal().getPrincipalId();
    }

    public String getRoleName() {
        return this.getRole();
    }

    public Recipient getRecipient() {
        if (this.isUsingPrincipal()) {
            return new KimPrincipalRecipient((PrincipalContract)this.getPrincipal());
        }
        if (this.isUsingGroup()) {
            return new KimGroupRecipient(this.getGroup());
        }
        if (this.isUsingRole()) {
            return new RoleRecipient(this.getRole());
        }
        return null;
    }

    public static RuleResponsibility to(RuleResponsibilityBo bo) {
        if (bo == null) {
            return null;
        }
        return RuleResponsibility.Builder.create((RuleResponsibilityContract)bo).build();
    }
}

