/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.api.rule.RuleTemplate;
import org.kuali.rice.kew.api.rule.RuleTemplateAttribute;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.MassRuleAttribute;
import org.kuali.rice.kew.rule.Rule;
import org.kuali.rice.kew.rule.RuleImpl;
import org.kuali.rice.kew.rule.RuleSelector;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.XmlConfiguredAttribute;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.util.PerformanceLogger;

class TemplateRuleSelector
implements RuleSelector {
    private int numberOfSelectedRules;

    TemplateRuleSelector() {
    }

    int getNumberOfSelectedRules() {
        return this.numberOfSelectedRules;
    }

    @Override
    public List<Rule> selectRules(RouteContext context, DocumentRouteHeaderValue routeHeader, RouteNodeInstance nodeInstance, String selectionCriterion, Timestamp effectiveDate) {
        String ruleTemplateName = selectionCriterion;
        HashSet<MassRuleAttribute> massRules = new HashSet<MassRuleAttribute>();
        RuleTemplate template = KewApiServiceLocator.getRuleService().getRuleTemplateByName(ruleTemplateName);
        if (template == null) {
            throw new WorkflowRuntimeException("Could not locate the rule template with name " + ruleTemplateName + " on document " + routeHeader.getDocumentId());
        }
        for (RuleTemplateAttribute templateAttribute : template.getActiveRuleTemplateAttributes()) {
            WorkflowRuleAttribute ruleAttribute;
            String ruleAttributeName = templateAttribute.getRuleAttribute().getName();
            if (!RuleAttribute.isWorkflowAttribute(templateAttribute.getRuleAttribute().getType())) continue;
            ExtensionDefinition extensionDefinition = KewApiServiceLocator.getExtensionRepositoryService().getExtensionByName(ruleAttributeName);
            Object attribute = ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition);
            if (attribute == null) {
                throw new RiceIllegalArgumentException("Failed to load WorkflowRuleAttribute for: " + extensionDefinition);
            }
            if (!WorkflowRuleAttribute.class.isAssignableFrom(attribute.getClass())) {
                throw new RiceIllegalArgumentException("Failed to locate a WorkflowRuleAttribute with the given name: " + ruleAttributeName);
            }
            if (attribute instanceof XmlConfiguredAttribute) {
                ((XmlConfiguredAttribute)attribute).setExtensionDefinition(extensionDefinition);
            }
            if (!((ruleAttribute = (WorkflowRuleAttribute)attribute) instanceof MassRuleAttribute)) continue;
            massRules.add((MassRuleAttribute)attribute);
        }
        List<Object> rules = effectiveDate == null ? KewApiServiceLocator.getRuleService().getRulesByTemplateNameAndDocumentTypeName(ruleTemplateName, routeHeader.getDocumentType().getName()) : KewApiServiceLocator.getRuleService().getRulesByTemplateNameAndDocumentTypeNameAndEffectiveDate(ruleTemplateName, routeHeader.getDocumentType().getName(), new DateTime(effectiveDate.getTime()));
        this.numberOfSelectedRules = rules.size();
        if (context.getDocument() == null) {
            context.setDocument(routeHeader);
        }
        if (context.getNodeInstance() == null) {
            context.setNodeInstance(nodeInstance);
        }
        DocumentContent documentContent = context.getDocumentContent();
        PerformanceLogger performanceLogger = new PerformanceLogger();
        for (MassRuleAttribute massRuleAttribute : massRules) {
            rules = massRuleAttribute.filterNonMatchingRules(context, rules);
        }
        performanceLogger.log("Time to filter massRules for template " + template.getName());
        ArrayList<Rule> ruleList = new ArrayList<Rule>(rules.size());
        for (org.kuali.rice.kew.api.rule.Rule ruleDefinition : rules) {
            ruleList.add(new RuleImpl(ruleDefinition));
        }
        return ruleList;
    }
}

