/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.bo;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.web.format.BooleanFormatter;
import org.kuali.rice.core.web.format.CollectionFormatter;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.rule.RuleTemplate;
import org.kuali.rice.kew.api.rule.RuleTemplateAttribute;
import org.kuali.rice.kew.lookupable.MyColumns;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.WorkflowRuleAttributeRows;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.service.RuleDelegationService;
import org.kuali.rice.kew.rule.service.RuleTemplateService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.comparator.CellComparatorHelper;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class RuleDelegationLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private List<Row> rows = new ArrayList<Row>();
    private static final String PARENT_RESPONSIBILITY_ID_PROPERTY_NAME = "responsibilityId";
    private static final String PARENT_RULE_ID_PROPERTY_NAME = "ruleResponsibility.ruleBaseValuesId";
    private static final String RULE_TEMPLATE_PROPERTY_NAME = "delegationRule.ruleTemplate.name";
    private static final String RULE_ID_PROPERTY_NAME = "delegationRule.id";
    private static final String ACTIVE_IND_PROPERTY_NAME = "delegationRule.active";
    private static final String DELEGATION_PROPERTY_NAME = "delegationType";
    private static final String GROUP_REVIEWER_PROPERTY_NAME = "groupReviewer";
    private static final String GROUP_REVIEWER_NAME_PROPERTY_NAME = "groupReviewerName";
    private static final String GROUP_REVIEWER_NAMESPACE_PROPERTY_NAME = "groupReviewerNamespace";
    private static final String PERSON_REVIEWER_PROPERTY_NAME = "personReviewer";
    private static final String PERSON_REVIEWER_TYPE_PROPERTY_NAME = "personReviewerType";
    private static final String DOC_TYP_NAME_PROPERTY_NAME = "delegationRule.documentType.name";
    private static final String RULE_DESC_PROPERTY_NAME = "delegationRule.description";
    private static final String BACK_LOCATION = "backLocation";
    private static final String DOC_FORM_KEY = "docFormKey";
    private static final String INVALID_WORKGROUP_ERROR = "The Group Reviewer Namespace and Name combination is not valid";
    private static final String INVALID_PERSON_ERROR = "The Person Reviewer is not valid";

    public List<Row> getRows() {
        List superRows = super.getRows();
        ArrayList<Row> returnRows = new ArrayList<Row>();
        returnRows.addAll(superRows);
        returnRows.addAll(this.rows);
        return returnRows;
    }

    public boolean checkForAdditionalFields(Map<String, String> fieldValues) {
        String ruleTemplateNameParam = fieldValues.get(RULE_TEMPLATE_PROPERTY_NAME);
        if (StringUtils.isNotBlank((String)ruleTemplateNameParam)) {
            this.rows = new ArrayList<Row>();
            RuleTemplate ruleTemplate = KewApiServiceLocator.getRuleService().getRuleTemplateByName(ruleTemplateNameParam);
            for (RuleTemplateAttribute ruleTemplateAttribute : ruleTemplate.getActiveRuleTemplateAttributes()) {
                ArrayList<Field> fields;
                if (!RuleAttribute.isWorkflowAttribute(ruleTemplateAttribute.getRuleAttribute().getType())) continue;
                WorkflowRuleAttributeRows workflowRuleAttributeRows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getSearchRows(fieldValues, ruleTemplateAttribute);
                for (Row row : workflowRuleAttributeRows.getRows()) {
                    fields = new ArrayList<Field>();
                    for (Field field : row.getFields()) {
                        if (fieldValues.get(field.getPropertyName()) != null) {
                            field.setPropertyValue(fieldValues.get(field.getPropertyName()));
                        }
                        fields.add(field);
                        fieldValues.put(field.getPropertyName(), field.getPropertyValue());
                    }
                }
                workflowRuleAttributeRows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getSearchRows(fieldValues, ruleTemplateAttribute);
                for (Row row : workflowRuleAttributeRows.getRows()) {
                    fields = new ArrayList();
                    for (Field field : row.getFields()) {
                        if (fieldValues.get(field.getPropertyName()) != null) {
                            field.setPropertyValue(fieldValues.get(field.getPropertyName()));
                        }
                        fields.add(field);
                        fieldValues.put(field.getPropertyName(), field.getPropertyValue());
                    }
                    row.setFields(fields);
                    this.rows.add(row);
                }
            }
            return true;
        }
        this.rows.clear();
        return false;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        Principal principal;
        String parentRuleBaseValueId = fieldValues.get(PARENT_RULE_ID_PROPERTY_NAME);
        String parentResponsibilityId = fieldValues.get(PARENT_RESPONSIBILITY_ID_PROPERTY_NAME);
        String docTypeNameParam = fieldValues.get(DOC_TYP_NAME_PROPERTY_NAME);
        String ruleTemplateIdParam = null;
        String ruleTemplateNameParam = fieldValues.get(RULE_TEMPLATE_PROPERTY_NAME);
        String groupIdParam = fieldValues.get(GROUP_REVIEWER_PROPERTY_NAME);
        String groupNameParam = fieldValues.get(GROUP_REVIEWER_NAME_PROPERTY_NAME);
        String groupNamespaceParam = fieldValues.get(GROUP_REVIEWER_NAMESPACE_PROPERTY_NAME);
        String networkIdParam = fieldValues.get(PERSON_REVIEWER_PROPERTY_NAME);
        String userDirectiveParam = fieldValues.get(PERSON_REVIEWER_TYPE_PROPERTY_NAME);
        String activeParam = fieldValues.get(ACTIVE_IND_PROPERTY_NAME);
        String delegationParam = fieldValues.get(DELEGATION_PROPERTY_NAME);
        String ruleIdParam = fieldValues.get(RULE_ID_PROPERTY_NAME);
        String ruleDescription = fieldValues.get(RULE_DESC_PROPERTY_NAME);
        String docTypeSearchName = null;
        String workflowId = null;
        String workgroupId = null;
        String ruleTemplateId = null;
        Boolean isActive = null;
        String ruleId = null;
        if (ruleIdParam != null && !"".equals(ruleIdParam.trim())) {
            ruleId = ruleIdParam.trim();
        }
        if (!activeParam.equals("")) {
            isActive = activeParam.equals("Y") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (docTypeNameParam != null && !"".equals(docTypeNameParam.trim())) {
            docTypeSearchName = docTypeNameParam.replace('*', '%');
            docTypeSearchName = "%" + docTypeSearchName.trim() + "%";
        }
        if (StringUtils.isNotBlank((String)networkIdParam) && (principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(networkIdParam)) != null) {
            workflowId = principal.getPrincipalId();
        }
        if (StringUtils.isNotBlank((String)groupIdParam) || StringUtils.isNotBlank((String)groupNameParam)) {
            Group group = null;
            if (groupIdParam != null && !"".equals(groupIdParam)) {
                group = this.getGroupService().getGroup(groupIdParam.trim());
            } else {
                if (groupNamespaceParam == null) {
                    groupNamespaceParam = "KUALI";
                }
                if ((group = this.getGroupService().getGroupByNamespaceCodeAndName(groupNamespaceParam, groupNameParam.trim())) == null) {
                    GlobalVariables.getMessageMap().putError(GROUP_REVIEWER_NAMESPACE_PROPERTY_NAME, "error.custom", new String[]{INVALID_WORKGROUP_ERROR});
                } else {
                    workgroupId = group.getId();
                }
            }
        }
        HashMap<String, String> attributes = null;
        MyColumns myColumns = new MyColumns();
        if (StringUtils.isNotBlank((String)ruleTemplateNameParam) || StringUtils.isNotBlank(ruleTemplateIdParam) && !"null".equals(ruleTemplateIdParam)) {
            RuleTemplate ruleTemplate = null;
            if (StringUtils.isNotBlank(ruleTemplateIdParam)) {
                ruleTemplate = KewApiServiceLocator.getRuleService().getRuleTemplate(ruleTemplateIdParam);
            } else {
                ruleTemplate = KewApiServiceLocator.getRuleService().getRuleTemplateByName(ruleTemplateNameParam.trim());
                ruleTemplateId = ruleTemplate.getId();
            }
            if (ruleTemplate == null) {
                this.rows.clear();
                LOG.info((Object)"Returning empty result set for Delegation Rule Lookup because a RuleTemplate Name or ID was provided, but no valid RuleTemplates were retrieved by the service.");
                return new ArrayList();
            }
            attributes = new HashMap<String, String>();
            for (RuleTemplateAttribute ruleTemplateAttribute : ruleTemplate.getActiveRuleTemplateAttributes()) {
                if (!RuleAttribute.isWorkflowAttribute(ruleTemplateAttribute.getRuleAttribute().getType())) continue;
                WorkflowRuleAttributeRows workflowRuleAttributeRows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getSearchRows(fieldValues, ruleTemplateAttribute, false);
                for (RemotableAttributeError error : workflowRuleAttributeRows.getValidationErrors()) {
                    GlobalVariables.getMessageMap().putError(error.getAttributeName(), "error.custom", new String[]{error.getMessage()});
                }
                for (Row row : workflowRuleAttributeRows.getRows()) {
                    for (Field field : row.getFields()) {
                        String attributeParam;
                        if (fieldValues.get(field.getPropertyName()) != null && !(attributeParam = fieldValues.get(field.getPropertyName())).equals("")) {
                            attributes.put(field.getPropertyName(), attributeParam.trim());
                        }
                        if (!field.getFieldType().equals("text") && !field.getFieldType().equals("dropdown") && !field.getFieldType().equals("dropdown_refresh") && !field.getFieldType().equals("radio")) continue;
                        myColumns.getColumns().add((KeyValue)new ConcreteKeyValue(field.getPropertyName(), ruleTemplateAttribute.getId()));
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((String)ruleDescription)) {
            ruleDescription = ruleDescription.replace('*', '%');
            ruleDescription = "%" + ruleDescription.trim() + "%";
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            throw new ValidationException("errors in search criteria");
        }
        Iterator<RuleDelegationBo> rules = this.getRuleDelegationService().search(parentRuleBaseValueId, parentResponsibilityId, docTypeSearchName, ruleId, ruleTemplateId, ruleDescription, workgroupId, workflowId, delegationParam, isActive, attributes, userDirectiveParam).iterator();
        ArrayList<RuleDelegationBo> displayList = new ArrayList<RuleDelegationBo>();
        while (rules.hasNext()) {
            RuleDelegationBo ruleDelegation = rules.next();
            RuleBaseValues record = ruleDelegation.getDelegationRule();
            if (StringUtils.isBlank((String)record.getDescription())) {
                record.setDescription("&nbsp;");
            }
            if (ruleTemplateNameParam != null && !ruleTemplateNameParam.trim().equals("") || ruleTemplateIdParam != null && !"".equals(ruleTemplateIdParam) && !"null".equals(ruleTemplateIdParam)) {
                MyColumns myNewColumns = new MyColumns();
                Iterator<KeyValue> i$ = myColumns.getColumns().iterator();
                while (i$.hasNext()) {
                    KeyValue element;
                    KeyValue pair = element = i$.next();
                    List<RuleExtensionBo> ruleExts = record.getRuleExtensions();
                    for (RuleExtensionBo ruleExt : ruleExts) {
                        if (!ruleExt.getExtensionValuesMap().containsKey(pair.getKey().toString())) continue;
                        ruleTemplateIdParam = ruleExt.getRuleTemplateAttributeId();
                    }
                    ConcreteKeyValue newPair = record.getRuleExtensionValue(ruleTemplateIdParam, pair.getKey().toString()) != null ? new ConcreteKeyValue(pair.getKey(), record.getRuleExtensionValue(ruleTemplateIdParam, pair.getKey().toString()).getValue()) : new ConcreteKeyValue(pair.getKey(), "&nbsp;");
                    myNewColumns.getColumns().add((KeyValue)newPair);
                    record.getFieldValues().put(newPair.getKey(), newPair.getValue());
                }
                record.setMyColumns(myNewColumns);
            }
            StringBuilder returnUrl = new StringBuilder("<a href=\"");
            returnUrl.append(fieldValues.get(BACK_LOCATION)).append("?methodToCall=refresh&docFormKey=").append(fieldValues.get(DOC_FORM_KEY)).append("&");
            returnUrl.append(RULE_ID_PROPERTY_NAME);
            returnUrl.append("=").append(record.getId()).append("\">return value</a>");
            record.setReturnUrl(returnUrl.toString());
            String destinationUrl = "<a href=\"Rule.do?methodToCall=report&currentRuleId=" + record.getId() + "\">report</a>";
            record.setDestinationUrl(destinationUrl);
            displayList.add(ruleDelegation);
        }
        return displayList;
    }

    private GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    private RuleTemplateService getRuleTemplateService() {
        return (RuleTemplateService)KEWServiceLocator.getService("enRuleTemplateService");
    }

    private RuleDelegationService getRuleDelegationService() {
        return (RuleDelegationService)KEWServiceLocator.getService("enRuleDelegationService");
    }

    public void validateSearchParameters(Map<String, String> fieldValues) {
        Person person;
        Group group;
        String attributeLabel;
        super.validateSearchParameters(fieldValues);
        String groupName = fieldValues.get(GROUP_REVIEWER_NAME_PROPERTY_NAME);
        String groupNamespace = fieldValues.get(GROUP_REVIEWER_NAMESPACE_PROPERTY_NAME);
        String principalName = fieldValues.get(PERSON_REVIEWER_PROPERTY_NAME);
        if (StringUtils.isEmpty((String)groupName) && !StringUtils.isEmpty((String)groupNamespace)) {
            attributeLabel = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), GROUP_REVIEWER_NAME_PROPERTY_NAME);
            GlobalVariables.getMessageMap().putError(GROUP_REVIEWER_NAME_PROPERTY_NAME, "error.required", new String[]{attributeLabel});
        }
        if (!StringUtils.isEmpty((String)groupName) && StringUtils.isEmpty((String)groupNamespace)) {
            attributeLabel = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), GROUP_REVIEWER_NAMESPACE_PROPERTY_NAME);
            GlobalVariables.getMessageMap().putError(GROUP_REVIEWER_NAMESPACE_PROPERTY_NAME, "error.required", new String[]{attributeLabel});
        }
        if (!StringUtils.isEmpty((String)groupName) && !StringUtils.isEmpty((String)groupNamespace) && (group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(groupNamespace, groupName)) == null) {
            GlobalVariables.getMessageMap().putError(GROUP_REVIEWER_NAME_PROPERTY_NAME, "error.custom", new String[]{INVALID_WORKGROUP_ERROR});
        }
        if (!StringUtils.isEmpty((String)principalName) && (person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(principalName)) == null) {
            GlobalVariables.getMessageMap().putError(PERSON_REVIEWER_PROPERTY_NAME, "error.custom", new String[]{INVALID_PERSON_ERROR});
        }
        if (!GlobalVariables.getMessageMap().hasNoErrors()) {
            throw new ValidationException("errors in search criteria");
        }
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get(BACK_LOCATION));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get(DOC_FORM_KEY));
        List displayList = bounded ? this.getSearchResults(lookupForm.getFieldsForLookup()) : this.getSearchResultsUnbounded(lookupForm.getFieldsForLookup());
        HashMap<String, Class> propertyTypes = new HashMap<String, Class>();
        boolean hasReturnableRow = false;
        List returnKeys = this.getReturnKeys();
        List pkNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        Person user = GlobalVariables.getUserSession().getPerson();
        for (BusinessObject element : displayList) {
            if (element instanceof PersistableBusinessObject) {
                lookupForm.setLookupObjectId(((PersistableBusinessObject)element).getObjectId());
            }
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            HtmlData returnUrl = this.getReturnUrl(element, lookupForm, returnKeys, businessObjectRestrictions);
            String actionUrls = this.getActionUrls(element, pkNames, businessObjectRestrictions);
            if ("".equals(actionUrls)) {
                actionUrls = "&nbsp;";
            }
            List<Column> columns = this.getColumns();
            Iterator<Column> i$ = columns.iterator();
            while (i$.hasNext()) {
                Class propClass;
                Column element2;
                Column col = element2 = i$.next();
                String curPropName = col.getPropertyName();
                Formatter formatter = col.getFormatter();
                String propValue = "";
                Object prop = null;
                boolean skipPropTypeCheck = false;
                if (element instanceof RuleDelegationBo) {
                    prop = ((RuleDelegationBo)element).getDelegationRule().getFieldValues().get(curPropName);
                    skipPropTypeCheck = true;
                }
                if (prop == null) {
                    prop = ObjectUtils.getPropertyValue((Object)element, (String)curPropName);
                }
                if ((propClass = (Class)propertyTypes.get(curPropName)) == null && !skipPropTypeCheck) {
                    try {
                        propClass = ObjectUtils.getPropertyType((Object)element, (String)curPropName, (PersistenceStructureService)this.getPersistenceStructureService());
                        propertyTypes.put(curPropName, propClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot access PropertyType for property '" + curPropName + "' " + " on an instance of '" + element.getClass().getName() + "'.", e);
                    }
                }
                if (prop != null) {
                    if (prop instanceof Boolean) {
                        formatter = new BooleanFormatter();
                    }
                    if (prop instanceof Date) {
                        formatter = new DateFormatter();
                    }
                    if (prop instanceof Collection && formatter == null) {
                        formatter = new CollectionFormatter();
                    }
                    propValue = formatter != null ? (String)formatter.format(prop) : prop.toString();
                }
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                propValue = this.maskValueIfNecessary(element.getClass(), curPropName, propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
                if (!StringUtils.isNotBlank((String)propValue)) continue;
                col.setColumnAnchor(this.getInquiryUrl(element, curPropName));
            }
            ResultRow row = new ResultRow(columns, returnUrl.constructCompleteHtmlTag(), actionUrls);
            row.setRowId(returnUrl.getName());
            row.setReturnUrlHtmlData(returnUrl);
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            if (element instanceof PersistableBusinessObject) {
                row.setObjectId(((PersistableBusinessObject)element).getObjectId());
            }
            boolean rowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(rowReturnable);
            if (rowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
        return displayList;
    }

    public List<Column> getColumns() {
        List columns = super.getColumns();
        for (Row row : this.rows) {
            for (Field field : row.getFields()) {
                Column newColumn = new Column();
                newColumn.setColumnTitle(field.getFieldLabel());
                newColumn.setMaxLength(field.getMaxLength());
                newColumn.setPropertyName(field.getPropertyName());
                columns.add(newColumn);
            }
        }
        return columns;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        RuleDelegationBo ruleDelegation = (RuleDelegationBo)businessObject;
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (StringUtils.isNotBlank((String)ruleDelegation.getDelegationRule().getRuleTemplateName()) && StringUtils.isNotBlank((String)this.getMaintenanceDocumentTypeName())) {
            if (this.allowsMaintenanceEditAction(businessObject)) {
                htmlDataList.add((HtmlData)this.getUrlData(businessObject, "edit", pkNames));
            }
            if (this.allowsMaintenanceNewOrCopyAction()) {
                htmlDataList.add((HtmlData)this.getUrlData(businessObject, "copy", pkNames));
            }
        }
        return htmlDataList;
    }
}

