/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.bo;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.ArrayUtils;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.api.rule.RuleTemplate;
import org.kuali.rice.kew.api.rule.RuleTemplateContract;
import org.kuali.rice.kew.rule.RuleTemplateOptionBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREW_RULE_TMPL_T")
@NamedQueries(value={@NamedQuery(name="findAllOrderedByName", query="SELECT rt FROM RuleTemplate rt ORDER BY rt.name ASC")})
public class RuleTemplateBo
extends PersistableBusinessObjectBase
implements RuleTemplateContract {
    private static final long serialVersionUID = -3387940485523951302L;
    public static final String[] DEFAULT_OPTION_KEYS = new String[]{"K", "A", "C", "F", "D"};
    @Id
    @GeneratedValue(generator="KREW_RTE_TMPL_S")
    @GenericGenerator(name="KREW_RTE_TMPL_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_RTE_TMPL_S"), @Parameter(name="value_column", value="id")})
    @Column(name="RULE_TMPL_ID")
    private String id;
    @Column(name="NM")
    private String name;
    @Column(name="RULE_TMPL_DESC")
    private String description;
    @Column(name="DLGN_RULE_TMPL_ID", insertable=false, updatable=false)
    private String delegationTemplateId;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="DLGN_RULE_TMPL_ID")
    private RuleTemplateBo delegationTemplate;
    @Fetch(value=FetchMode.SELECT)
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE}, mappedBy="ruleTemplate")
    private List<RuleTemplateAttributeBo> ruleTemplateAttributes = new ArrayList<RuleTemplateAttributeBo>();
    @Fetch(value=FetchMode.SELECT)
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE}, mappedBy="ruleTemplate", orphanRemoval=true)
    private List<RuleTemplateOptionBo> ruleTemplateOptions = new ArrayList<RuleTemplateOptionBo>();
    @Transient
    private String returnUrl;

    public void removeNonDefaultOptions() {
        Iterator<RuleTemplateOptionBo> it = this.ruleTemplateOptions.iterator();
        while (it.hasNext()) {
            RuleTemplateOptionBo option = it.next();
            if (ArrayUtils.contains((Object[])DEFAULT_OPTION_KEYS, (Object)option.getCode())) continue;
            it.remove();
        }
    }

    public String getDelegateTemplateName() {
        if (this.delegationTemplate != null) {
            return this.delegationTemplate.getName();
        }
        return "";
    }

    public String getRuleTemplateActionsUrl() {
        return "<a href=\"RuleTemplate.do?methodToCall=report&currentRuleTemplateId=" + this.id + "\" >report</a>";
    }

    private RuleTemplateAttributeBo getRuleTemplateAttribute(RuleTemplateAttributeBo ruleTemplateAttribute, Boolean active) {
        for (RuleTemplateAttributeBo currentRuleTemplateAttribute : this.getRuleTemplateAttributes()) {
            if (!currentRuleTemplateAttribute.getRuleAttribute().getName().equals(ruleTemplateAttribute.getRuleAttribute().getName())) continue;
            if (active == null) {
                return currentRuleTemplateAttribute;
            }
            if (active.compareTo(currentRuleTemplateAttribute.getActive()) != 0) continue;
            return currentRuleTemplateAttribute;
        }
        return null;
    }

    public RuleTemplateAttributeBo getRuleTemplateAttribute(RuleTemplateAttributeBo ruleTemplateAttribute) {
        return this.getRuleTemplateAttribute(ruleTemplateAttribute, null);
    }

    public boolean containsActiveRuleTemplateAttribute(RuleTemplateAttributeBo templateAttribute) {
        return this.getRuleTemplateAttribute(templateAttribute, Boolean.TRUE) != null;
    }

    public boolean containsRuleTemplateAttribute(RuleTemplateAttributeBo templateAttribute) {
        return this.getRuleTemplateAttribute(templateAttribute, null) != null;
    }

    public RuleTemplateAttributeBo getRuleTemplateAttribute(int index) {
        while (this.getRuleTemplateAttributes().size() <= index) {
            this.getRuleTemplateAttributes().add(new RuleTemplateAttributeBo());
        }
        return this.getRuleTemplateAttributes().get(index);
    }

    public List<RuleTemplateAttributeBo> getRuleTemplateAttributes() {
        Collections.sort(this.ruleTemplateAttributes);
        return this.ruleTemplateAttributes;
    }

    public List<RuleTemplateAttributeBo> getActiveRuleTemplateAttributes() {
        ArrayList<RuleTemplateAttributeBo> activeAttributes = new ArrayList<RuleTemplateAttributeBo>();
        for (RuleTemplateAttributeBo templateAttribute : this.getRuleTemplateAttributes()) {
            if (!templateAttribute.isActive()) continue;
            activeAttributes.add(templateAttribute);
        }
        Collections.sort(activeAttributes);
        return activeAttributes;
    }

    public void setActiveRuleTemplateAttributes(List<RuleTemplateAttributeBo> ruleTemplateAttributes) {
        throw new UnsupportedOperationException("setActiveRuleTemplateAttributes is not implemented");
    }

    public void setRuleTemplateAttributes(List<RuleTemplateAttributeBo> ruleTemplateAttributes) {
        this.ruleTemplateAttributes = ruleTemplateAttributes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDelegationTemplateId() {
        return this.delegationTemplateId;
    }

    public void setDelegationTemplateId(String delegationTemplateId) {
        this.delegationTemplateId = delegationTemplateId;
    }

    public RuleTemplateBo getDelegationTemplate() {
        return this.delegationTemplate;
    }

    public void setDelegationTemplate(RuleTemplateBo delegationTemplate) {
        this.delegationTemplate = delegationTemplate;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getEncodedName() {
        return URLEncoder.encode(this.getName());
    }

    public List<RuleTemplateOptionBo> getRuleTemplateOptions() {
        return this.ruleTemplateOptions;
    }

    public void setRuleTemplateOptions(List<RuleTemplateOptionBo> ruleTemplateOptions) {
        this.ruleTemplateOptions = ruleTemplateOptions;
    }

    public RuleTemplateOptionBo getRuleTemplateOption(String key) {
        for (RuleTemplateOptionBo option : this.ruleTemplateOptions) {
            if (!option.getCode().equals(key)) continue;
            return option;
        }
        return null;
    }

    public void setAcknowledge(RuleTemplateOptionBo acknowledge) {
        RuleTemplateOptionBo option = this.getRuleTemplateOption("K");
        option.setValue(acknowledge.getValue());
        option.setId(acknowledge.getId());
        option.setVersionNumber(acknowledge.getVersionNumber());
    }

    public void setComplete(RuleTemplateOptionBo complete) {
        RuleTemplateOptionBo option = this.getRuleTemplateOption("C");
        option.setValue(complete.getValue());
        option.setId(complete.getId());
        option.setVersionNumber(complete.getVersionNumber());
    }

    public void setApprove(RuleTemplateOptionBo approve) {
        RuleTemplateOptionBo option = this.getRuleTemplateOption("A");
        option.setValue(approve.getValue());
        option.setId(approve.getId());
        option.setVersionNumber(approve.getVersionNumber());
    }

    public void setFyi(RuleTemplateOptionBo fyi) {
        RuleTemplateOptionBo option = this.getRuleTemplateOption("F");
        option.setValue(fyi.getValue());
        option.setId(fyi.getId());
        option.setVersionNumber(fyi.getVersionNumber());
    }

    public void setDefaultActionRequestValue(RuleTemplateOptionBo defaultActionRequestValue) {
        RuleTemplateOptionBo option = this.getRuleTemplateOption("D");
        option.setValue(defaultActionRequestValue.getValue());
        option.setId(defaultActionRequestValue.getId());
        option.setVersionNumber(defaultActionRequestValue.getVersionNumber());
    }

    public RuleTemplateOptionBo getAcknowledge() {
        return this.getRuleTemplateOption("K");
    }

    public RuleTemplateOptionBo getComplete() {
        return this.getRuleTemplateOption("C");
    }

    public RuleTemplateOptionBo getApprove() {
        return this.getRuleTemplateOption("A");
    }

    public RuleTemplateOptionBo getFyi() {
        return this.getRuleTemplateOption("F");
    }

    public RuleTemplateOptionBo getDefaultActionRequestValue() {
        return this.getRuleTemplateOption("D");
    }

    public List<RoleName> getRoles() {
        ArrayList<RoleName> roleNames = new ArrayList<RoleName>();
        List<RuleTemplateAttributeBo> templateAttributes = this.getRuleTemplateAttributes();
        for (RuleTemplateAttributeBo templateAttribute : templateAttributes) {
            if (!templateAttribute.isWorkflowAttribute()) continue;
            roleNames.addAll(KEWServiceLocator.getWorkflowRuleAttributeMediator().getRoleNames(templateAttribute));
        }
        return roleNames;
    }

    public static RuleTemplate to(RuleTemplateBo bo) {
        if (bo == null) {
            return null;
        }
        return RuleTemplate.Builder.create((RuleTemplateContract)bo).build();
    }
}

