/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.dao.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.dao.RuleAttributeDAO;

public class RuleAttributeDAOJpaImpl
implements RuleAttributeDAO {
    @PersistenceContext
    private EntityManager entityManager;
    private static final Logger LOG = Logger.getLogger(RuleAttributeDAOJpaImpl.class);

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void save(RuleAttribute ruleAttribute) {
        if (ruleAttribute.getId() == null) {
            this.entityManager.persist((Object)ruleAttribute);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)((Object)ruleAttribute));
        }
    }

    @Override
    public void delete(String ruleAttributeId) {
        this.entityManager.remove((Object)this.findByRuleAttributeId(ruleAttributeId));
    }

    @Override
    public RuleAttribute findByRuleAttributeId(String ruleAttributeId) {
        return (RuleAttribute)((Object)this.entityManager.createNamedQuery("RuleAttribute.FindById").setParameter("ruleAttributeId", (Object)ruleAttributeId).getSingleResult());
    }

    @Override
    public List<RuleAttribute> findByRuleAttribute(RuleAttribute ruleAttribute) {
        Criteria crit = new Criteria("RuleAttribute", "ra");
        if (ruleAttribute.getName() != null) {
            crit.rawJpql("UPPER(RULE_ATTRIB_NM) like '" + ruleAttribute.getName().toUpperCase() + "'");
        }
        if (ruleAttribute.getResourceDescriptor() != null) {
            crit.rawJpql("UPPER(RULE_ATTRIB_CLS_NM) like '" + ruleAttribute.getResourceDescriptor().toUpperCase() + "'");
        }
        if (ruleAttribute.getType() != null) {
            crit.rawJpql("UPPER(RULE_ATTRIB_TYP) like '" + ruleAttribute.getType().toUpperCase() + "'");
        }
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public List<RuleAttribute> getAllRuleAttributes() {
        return this.entityManager.createNamedQuery("RuleAttribute.GetAllRuleAttributes").getResultList();
    }

    @Override
    public RuleAttribute findByName(String name) {
        LOG.debug((Object)("findByName name=" + name));
        return (RuleAttribute)((Object)this.entityManager.createNamedQuery("RuleAttribute.FindByName").setParameter("name", (Object)name).getSingleResult());
    }

    @Override
    public List<RuleAttribute> findByClassName(String classname) {
        LOG.debug((Object)("findByClassName classname=" + classname));
        List ruleAttributes = this.entityManager.createNamedQuery("RuleAttribute.FindByClassName").setParameter("resourceDescriptor", (Object)classname).getResultList();
        return ruleAttributes;
    }
}

