/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.dao.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.dao.RuleDelegationDAO;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class RuleDelegationDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements RuleDelegationDAO {
    @Override
    public List<RuleDelegationBo> findByDelegateRuleId(String ruleId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("delegateRuleId", (Object)ruleId);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleDelegationBo.class, crit));
    }

    @Override
    public void save(RuleDelegationBo ruleDelegation) {
        this.getPersistenceBrokerTemplate().store((Object)ruleDelegation);
    }

    @Override
    public List<RuleDelegationBo> findAllCurrentRuleDelegations() {
        Criteria crit = new Criteria();
        crit.addEqualTo("delegationRule.currentInd", (Object)true);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleDelegationBo.class, crit));
    }

    @Override
    public RuleDelegationBo findByRuleDelegationId(String ruleDelegationId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("ruleDelegationId", (Object)ruleDelegationId);
        return (RuleDelegationBo)((Object)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(RuleDelegationBo.class, crit)));
    }

    @Override
    public void delete(String ruleDelegationId) {
        this.getPersistenceBrokerTemplate().delete((Object)this.findByRuleDelegationId(ruleDelegationId));
    }

    @Override
    public List<RuleDelegationBo> findByResponsibilityIdWithCurrentRule(String responsibilityId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("responsibilityId", (Object)responsibilityId);
        crit.addEqualTo("delegationRule.currentInd", (Object)true);
        Collection delegations = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleDelegationBo.class, crit));
        return new ArrayList<RuleDelegationBo>(delegations);
    }

    @Override
    public List<RuleDelegationBo> search(String parentRuleBaseVaueId, String parentResponsibilityId, String docTypeName, String ruleId, String ruleTemplateId, String ruleDescription, String workgroupId, String principalId, String delegationType, Boolean activeInd, Map extensionValues, String workflowIdDirective) {
        Criteria crit = new Criteria();
        if (StringUtils.isNotBlank((String)delegationType) && !delegationType.equals("E")) {
            crit.addEqualTo("delegationType", (Object)delegationType);
        }
        if (StringUtils.isNotBlank((String)parentRuleBaseVaueId) && StringUtils.isNumeric((String)parentRuleBaseVaueId)) {
            crit.addIn((Object)"responsibilityId", (Query)this.getRuleResponsibilitySubQuery(new Long(parentRuleBaseVaueId)));
        }
        if (StringUtils.isNotBlank((String)parentResponsibilityId) && StringUtils.isNumeric((String)parentResponsibilityId)) {
            crit.addEqualTo("responsibilityId", (Object)parentResponsibilityId);
        }
        crit.addIn((Object)"delegateRuleId", (Query)this.getRuleBaseValuesSubQuery(docTypeName, ruleId, ruleTemplateId, ruleDescription, workgroupId, principalId, activeInd, extensionValues, workflowIdDirective));
        QueryByCriteria query = new QueryByCriteria(RuleDelegationBo.class, crit, true);
        query.setEndAtIndex(500);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public List<RuleDelegationBo> search(String parentRuleBaseVaueId, String parentResponsibilityId, String docTypeName, String ruleTemplateId, String ruleDescription, Collection<String> workgroupIds, String workflowId, String delegationType, Boolean activeInd, Map extensionValues, Collection actionRequestCodes) {
        Criteria crit = new Criteria();
        if (StringUtils.isNotBlank((String)delegationType) && !delegationType.equals("E")) {
            crit.addEqualTo("delegationType", (Object)delegationType);
        }
        if (StringUtils.isNotBlank((String)parentRuleBaseVaueId) && StringUtils.isNumeric((String)parentRuleBaseVaueId)) {
            crit.addIn((Object)"responsibilityId", (Query)this.getRuleResponsibilitySubQuery(new Long(parentRuleBaseVaueId)));
        }
        if (StringUtils.isNotBlank((String)parentResponsibilityId) && StringUtils.isNumeric((String)parentResponsibilityId)) {
            crit.addEqualTo("responsibilityId", (Object)parentResponsibilityId);
        }
        crit.addIn((Object)"delegateRuleId", (Query)this.getRuleBaseValuesSubQuery(docTypeName, ruleTemplateId, ruleDescription, workgroupIds, workflowId, activeInd, extensionValues, actionRequestCodes));
        QueryByCriteria query = new QueryByCriteria(RuleDelegationBo.class, crit, true);
        query.setEndAtIndex(500);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    private ReportQueryByCriteria getResponsibilitySubQuery(String ruleResponsibilityName) {
        Criteria responsibilityCrit = new Criteria();
        responsibilityCrit.addLike((Object)"ruleResponsibilityName", (Object)ruleResponsibilityName);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(RuleResponsibilityBo.class, (Criteria)responsibilityCrit);
        query.setAttributes(new String[]{"ruleBaseValuesId"});
        return query;
    }

    private ReportQueryByCriteria getWorkgroupResponsibilitySubQuery(Set<Long> workgroupIds) {
        HashSet<String> workgroupIdStrings = new HashSet<String>();
        for (Long workgroupId : workgroupIds) {
            workgroupIdStrings.add(workgroupId.toString());
        }
        Criteria responsibilityCrit = new Criteria();
        responsibilityCrit.addIn("ruleResponsibilityName", workgroupIds);
        responsibilityCrit.addEqualTo("ruleResponsibilityType", (Object)"G");
        ReportQueryByCriteria query = QueryFactory.newReportQuery(RuleResponsibilityBo.class, (Criteria)responsibilityCrit);
        query.setAttributes(new String[]{"ruleBaseValuesId"});
        return query;
    }

    private ReportQueryByCriteria getRuleBaseValuesSubQuery(String docTypeName, String ruleTemplateId, String ruleDescription, Collection<String> workgroupIds, String workflowId, Boolean activeInd, Map<String, String> extensionValues, Collection actionRequestCodes) {
        Criteria crit = this.getSearchCriteria(docTypeName, ruleTemplateId, ruleDescription, activeInd, extensionValues);
        crit.addIn((Object)"responsibilities.ruleBaseValuesId", (Query)this.getResponsibilitySubQuery(workgroupIds, workflowId, actionRequestCodes, workflowId != null, workgroupIds != null && !workgroupIds.isEmpty()));
        crit.addEqualTo("delegateRule", (Object)1);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(RuleBaseValues.class, (Criteria)crit);
        query.setAttributes(new String[]{"id"});
        return query;
    }

    private ReportQueryByCriteria getRuleBaseValuesSubQuery(String docTypeName, String ruleId, String ruleTemplateId, String ruleDescription, String workgroupId, String principalId, Boolean activeInd, Map<String, String> extensionValues, String workflowIdDirective) {
        Criteria crit = this.getSearchCriteria(docTypeName, ruleTemplateId, ruleDescription, activeInd, extensionValues);
        if (ruleId != null) {
            crit.addEqualTo("id", (Object)ruleId);
        }
        if (workgroupId != null) {
            crit.addIn((Object)"ruleResponsibilities.ruleBaseValuesId", (Query)this.getResponsibilitySubQuery(workgroupId));
        }
        List<String> workgroupIds = new ArrayList<String>();
        Boolean searchUser = Boolean.FALSE;
        Boolean searchUserInWorkgroups = Boolean.FALSE;
        if (workflowIdDirective != null) {
            if ("group".equals(workflowIdDirective)) {
                searchUserInWorkgroups = Boolean.TRUE;
            } else if ("".equals(workflowIdDirective)) {
                searchUser = Boolean.TRUE;
                searchUserInWorkgroups = Boolean.TRUE;
            } else {
                searchUser = Boolean.TRUE;
            }
        }
        if (!StringUtils.isEmpty((String)principalId) && searchUserInWorkgroups.booleanValue()) {
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
            if (principal == null) {
                throw new RiceRuntimeException("Failed to locate user for the given workflow id: " + principalId);
            }
            workgroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        }
        if (CollectionUtils.isNotEmpty(workgroupIds) || StringUtils.isNotBlank((String)principalId)) {
            crit.addIn((Object)"ruleResponsibilities.ruleBaseValuesId", (Query)this.getResponsibilitySubQuery(workgroupIds, principalId, searchUser, searchUserInWorkgroups));
        }
        crit.addEqualTo("delegateRule", (Object)1);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(RuleBaseValues.class, (Criteria)crit);
        query.setAttributes(new String[]{"id"});
        return query;
    }

    private ReportQueryByCriteria getRuleResponsibilitySubQuery(Long ruleBaseValuesId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("ruleBaseValuesId", (Object)ruleBaseValuesId);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(RuleResponsibilityBo.class, (Criteria)crit);
        query.setAttributes(new String[]{"responsibilityId"});
        return query;
    }

    private ReportQueryByCriteria getResponsibilitySubQuery(List<String> workgroupIds, String workflowId, Boolean searchUser, Boolean searchUserInWorkgroups) {
        ArrayList<String> workgroupIdStrings = new ArrayList<String>();
        for (String workgroupId : workgroupIds) {
            workgroupIdStrings.add(workgroupId);
        }
        return this.getResponsibilitySubQuery(workgroupIdStrings, workflowId, new ArrayList<String>(), searchUser, searchUserInWorkgroups);
    }

    private ReportQueryByCriteria getResponsibilitySubQuery(Collection<String> workgroupIds, String workflowId, Collection<String> actionRequestCodes, Boolean searchUser, Boolean searchUserInWorkgroups) {
        Criteria responsibilityCrit = new Criteria();
        if (actionRequestCodes != null && !actionRequestCodes.isEmpty()) {
            responsibilityCrit.addIn("actionRequestedCd", actionRequestCodes);
        }
        Criteria ruleResponsibilityNameCrit = null;
        if (!StringUtils.isEmpty((String)workflowId)) {
            if (searchUser != null && searchUser.booleanValue()) {
                ruleResponsibilityNameCrit = new Criteria();
                ruleResponsibilityNameCrit.addLike((Object)"ruleResponsibilityName", (Object)workflowId);
                ruleResponsibilityNameCrit.addEqualTo("ruleResponsibilityType", (Object)"F");
            }
            if (searchUserInWorkgroups != null && searchUserInWorkgroups.booleanValue() && workgroupIds != null && !workgroupIds.isEmpty()) {
                if (ruleResponsibilityNameCrit == null) {
                    ruleResponsibilityNameCrit = new Criteria();
                }
                Criteria workgroupCrit = new Criteria();
                workgroupCrit.addIn("ruleResponsibilityName", workgroupIds);
                workgroupCrit.addEqualTo("ruleResponsibilityType", (Object)"G");
                ruleResponsibilityNameCrit.addOrCriteria(workgroupCrit);
            }
        } else if (workgroupIds != null && workgroupIds.size() == 1) {
            ruleResponsibilityNameCrit = new Criteria();
            ruleResponsibilityNameCrit.addLike((Object)"ruleResponsibilityName", (Object)workgroupIds.iterator().next());
            ruleResponsibilityNameCrit.addEqualTo("ruleResponsibilityType", (Object)"G");
        } else if (workgroupIds != null && workgroupIds.size() > 1) {
            ruleResponsibilityNameCrit = new Criteria();
            ruleResponsibilityNameCrit.addIn("ruleResponsibilityName", workgroupIds);
            ruleResponsibilityNameCrit.addEqualTo("ruleResponsibilityType", (Object)"G");
        }
        if (ruleResponsibilityNameCrit != null) {
            responsibilityCrit.addAndCriteria(ruleResponsibilityNameCrit);
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(RuleResponsibilityBo.class, (Criteria)responsibilityCrit);
        query.setAttributes(new String[]{"ruleBaseValuesId"});
        return query;
    }

    private Criteria getSearchCriteria(String docTypeName, String ruleTemplateId, String ruleDescription, Boolean activeInd, Map<String, String> extensionValues) {
        Criteria crit = new Criteria();
        crit.addEqualTo("currentInd", (Object)Boolean.TRUE);
        crit.addEqualTo("templateRuleInd", (Object)Boolean.FALSE);
        if (activeInd != null) {
            crit.addEqualTo("active", (Object)activeInd);
        }
        if (docTypeName != null) {
            crit.addLike((Object)"UPPER(docTypeName)", (Object)docTypeName.toUpperCase());
        }
        if (ruleDescription != null && !ruleDescription.trim().equals("")) {
            crit.addLike((Object)"UPPER(description)", (Object)ruleDescription.toUpperCase());
        }
        if (ruleTemplateId != null) {
            crit.addEqualTo("ruleTemplateId", (Object)ruleTemplateId);
        }
        if (extensionValues != null && !extensionValues.isEmpty()) {
            for (Map.Entry<String, String> entry : extensionValues.entrySet()) {
                if (StringUtils.isEmpty((String)entry.getValue())) continue;
                Criteria extensionCrit2 = new Criteria();
                extensionCrit2.addEqualTo("extensionValues.key", (Object)entry.getKey());
                extensionCrit2.addLike((Object)"UPPER(extensionValues.value)", (Object)("%" + entry.getValue() + "%").toUpperCase());
                ReportQueryByCriteria query = QueryFactory.newReportQuery(RuleExtensionBo.class, (Criteria)extensionCrit2);
                query.setAttributes(new String[]{"ruleBaseValuesId"});
                crit.addIn((Object)"ruleExtensions.ruleBaseValuesId", (Query)query);
            }
        }
        return crit;
    }
}

