/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.dao.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.dao.RuleTemplateDAO;
import org.springmodules.orm.ojb.PersistenceBrokerCallback;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class RuleTemplateDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements RuleTemplateDAO {
    @Override
    public List<RuleTemplateBo> findAll() {
        QueryByCriteria query = new QueryByCriteria(RuleTemplateBo.class);
        query.addOrderByAscending("name");
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public RuleTemplateBo findByRuleTemplateName(String ruleTemplateName) {
        Criteria crit = new Criteria();
        crit.addEqualTo("name", (Object)ruleTemplateName);
        QueryByCriteria query = new QueryByCriteria(RuleTemplateBo.class, crit);
        query.addOrderByDescending("id");
        Iterator ruleTemplates = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query).iterator();
        if (ruleTemplates.hasNext()) {
            return (RuleTemplateBo)((Object)ruleTemplates.next());
        }
        return null;
    }

    @Override
    public List<RuleTemplateBo> findByRuleTemplate(RuleTemplateBo ruleTemplate) {
        Criteria crit = new Criteria();
        if (ruleTemplate.getName() != null) {
            crit.addSql("UPPER(RULE_TMPL_NM) like '" + ruleTemplate.getName().toUpperCase() + "'");
        }
        if (ruleTemplate.getDescription() != null) {
            crit.addSql("UPPER(RULE_TMPL_DESC) like '" + ruleTemplate.getDescription().toUpperCase() + "'");
        }
        return new ArrayList<RuleTemplateBo>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleTemplateBo.class, crit)));
    }

    @Override
    public void delete(String ruleTemplateId) {
        this.getPersistenceBrokerTemplate().delete((Object)this.findByRuleTemplateId(ruleTemplateId));
    }

    @Override
    public RuleTemplateBo findByRuleTemplateId(String ruleTemplateId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("id", (Object)ruleTemplateId);
        return (RuleTemplateBo)((Object)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(RuleTemplateBo.class, crit)));
    }

    @Override
    public void save(RuleTemplateBo ruleTemplate) {
        this.getPersistenceBrokerTemplate().store((Object)ruleTemplate);
    }

    @Override
    public String getNextRuleTemplateId() {
        return (String)this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker broker) {
                return String.valueOf(RuleTemplateDAOOjbImpl.this.getPlatform().getNextValSQL("KREW_RTE_TMPL_S", broker));
            }
        });
    }

    protected DatabasePlatform getPlatform() {
        return (DatabasePlatform)GlobalResourceLoader.getService((String)"dbPlatform");
    }
}

