/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.stats.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.kew.stats.Stats;
import org.kuali.rice.kew.stats.dao.StatsDAO;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class StatsDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements StatsDAO {
    private static final Logger LOG = Logger.getLogger(StatsDAOOjbImpl.class);
    public static final String SQL_NUM_ACTIVE_ITEMS = "select count(*) from krew_actn_itm_t";
    public static final String SQL_NUM_DOC_TYPES_REPORT = "select count(*) as num from krew_doc_typ_t where cur_ind = 1";
    public static final String SQL_DOCUMENTS_ROUTED = "select count(*) as count, krew_doc_hdr_t.doc_hdr_stat_cd from krew_doc_hdr_t where krew_doc_hdr_t.crte_dt between ? and ? group by doc_hdr_stat_cd";
    public static final String SQL_NUM_USERS = "select count(distinct prncpl_id) as prsn_count from KREW_USR_OPTN_T";
    public static final String SQL_NUM_DOCS_INITIATED = "select count(*), krew_doc_typ_t.doc_typ_nm from krew_doc_hdr_t, krew_doc_typ_t where krew_doc_hdr_t.crte_dt > ? and krew_doc_hdr_t.doc_typ_id = krew_doc_typ_t.doc_typ_id group by krew_doc_typ_t.doc_typ_nm";

    @Override
    public void NumActiveItemsReport(Stats stats) throws SQLException, LookupException {
        LOG.debug((Object)"NumActiveItemsReport()");
        PersistenceBroker broker = this.getPersistenceBroker(false);
        Connection conn = broker.serviceConnectionManager().getConnection();
        PreparedStatement ps = conn.prepareStatement(SQL_NUM_ACTIVE_ITEMS);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            stats.setNumActionItems(new Integer(rs.getInt(1)).toString());
        }
        this.closeDatabaseObjects(rs, ps, conn);
    }

    @Override
    public void NumberOfDocTypesReport(Stats stats) throws SQLException, LookupException {
        LOG.debug((Object)"NumberOfDocTypesReport()");
        PersistenceBroker broker = this.getPersistenceBroker(false);
        Connection conn = broker.serviceConnectionManager().getConnection();
        PreparedStatement ps = conn.prepareStatement(SQL_NUM_DOC_TYPES_REPORT);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            stats.setNumDocTypes(new Integer(rs.getInt(1)).toString());
        }
        this.closeDatabaseObjects(rs, ps, conn);
    }

    @Override
    public void DocumentsRoutedReport(Stats stats, Date begDate, Date endDate) throws SQLException, LookupException {
        LOG.debug((Object)"DocumentsRoutedReport()");
        PersistenceBroker broker = this.getPersistenceBroker(false);
        Connection conn = broker.serviceConnectionManager().getConnection();
        PreparedStatement ps = conn.prepareStatement(SQL_DOCUMENTS_ROUTED);
        ps.setTimestamp(1, new Timestamp(begDate.getTime()));
        ps.setTimestamp(2, new Timestamp(endDate.getTime()));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String actionType = rs.getString(2);
            String number = new Integer(rs.getInt(1)).toString();
            if (actionType.equals("X")) {
                stats.setCanceledNumber(number);
                continue;
            }
            if (actionType.equals("D")) {
                stats.setDisapprovedNumber(number);
                continue;
            }
            if (actionType.equals("R")) {
                stats.setEnrouteNumber(number);
                continue;
            }
            if (actionType.equals("E")) {
                stats.setExceptionNumber(number);
                continue;
            }
            if (actionType.equals("F")) {
                stats.setFinalNumber(number);
                continue;
            }
            if (actionType.equals("I")) {
                stats.setInitiatedNumber(number);
                continue;
            }
            if (actionType.equals("P")) {
                stats.setProcessedNumber(number);
                continue;
            }
            if (!actionType.equals("S")) continue;
            stats.setSavedNumber(number);
        }
        this.closeDatabaseObjects(rs, ps, conn);
    }

    @Override
    public void NumUsersReport(Stats stats) throws SQLException, LookupException {
        LOG.debug((Object)"NumUsersReport()");
        PersistenceBroker broker = this.getPersistenceBroker(false);
        Connection conn = broker.serviceConnectionManager().getConnection();
        PreparedStatement ps = conn.prepareStatement(SQL_NUM_USERS);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            stats.setNumUsers(new Integer(rs.getInt("prsn_count")).toString());
        }
        this.closeDatabaseObjects(rs, ps, conn);
    }

    @Override
    public void NumInitiatedDocsByDocTypeReport(Stats stats) throws SQLException, LookupException {
        LOG.debug((Object)"NumInitiatedDocsByDocType()");
        PersistenceBroker broker = this.getPersistenceBroker(false);
        Connection conn = broker.serviceConnectionManager().getConnection();
        PreparedStatement ps = conn.prepareStatement(SQL_NUM_DOCS_INITIATED);
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -29);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ps.setTimestamp(1, new Timestamp(calendar.getTime().getTime()));
        ResultSet rs = ps.executeQuery();
        ArrayList<ConcreteKeyValue> numDocs = new ArrayList<ConcreteKeyValue>();
        while (rs.next()) {
            numDocs.add(new ConcreteKeyValue(rs.getString(2), new Integer(rs.getInt(1)).toString()));
        }
        stats.setNumInitiatedDocsByDocType(numDocs);
        this.closeDatabaseObjects(rs, ps, conn);
    }

    private void closeDatabaseObjects(ResultSet rs, PreparedStatement ps, Connection conn) {
        try {
            rs.close();
        }
        catch (SQLException ex) {
            LOG.warn((Object)"Failed to close ResultSet.", (Throwable)ex);
        }
        try {
            ps.close();
        }
        catch (SQLException ex) {
            LOG.warn((Object)"Failed to close PreparedStatement.", (Throwable)ex);
        }
        try {
            conn.close();
        }
        catch (SQLException ex) {
            LOG.warn((Object)"Failed to close Connection.", (Throwable)ex);
        }
    }
}

