/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.stats.dao.impl;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.kew.stats.Stats;
import org.kuali.rice.kew.stats.dao.StatsDAO;

public class StatsDaoJpaImpl
implements StatsDAO {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public void DocumentsRoutedReport(Stats stats, Date begDate, Date endDate) throws SQLException, LookupException {
        Query query = this.entityManager.createQuery("select count(*) as count, drhv.docRouteStatus from DocumentRouteHeaderValue drhv where drhv.createDate between :beginDate and :endDate group by docRouteStatus");
        query.setParameter("beginDate", (Object)new Timestamp(begDate.getTime()));
        query.setParameter("endDate", (Object)new Timestamp(endDate.getTime()));
        List resultList = query.getResultList();
        for (Object[] result : resultList) {
            String actionType = result[1].toString();
            String number = result[0].toString();
            if (actionType.equals("X")) {
                stats.setCanceledNumber(number);
                continue;
            }
            if (actionType.equals("D")) {
                stats.setDisapprovedNumber(number);
                continue;
            }
            if (actionType.equals("R")) {
                stats.setEnrouteNumber(number);
                continue;
            }
            if (actionType.equals("E")) {
                stats.setExceptionNumber(number);
                continue;
            }
            if (actionType.equals("F")) {
                stats.setFinalNumber(number);
                continue;
            }
            if (actionType.equals("I")) {
                stats.setInitiatedNumber(number);
                continue;
            }
            if (actionType.equals("P")) {
                stats.setProcessedNumber(number);
                continue;
            }
            if (!actionType.equals("S")) continue;
            stats.setSavedNumber(number);
        }
    }

    @Override
    public void NumActiveItemsReport(Stats stats) throws SQLException, LookupException {
        stats.setNumActionItems(this.entityManager.createQuery("select count(*) from ActionItem ai").getSingleResult().toString());
    }

    @Override
    public void NumInitiatedDocsByDocTypeReport(Stats stats) throws SQLException, LookupException {
        Query query = this.entityManager.createQuery("select count(*), dt.name from DocumentRouteHeaderValue drhv, DocumentType dt where drhv.createDate > :createDate and drhv.documentTypeId = dt.documentTypeId group by dt.name");
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -29);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        query.setParameter("createDate", (Object)new Timestamp(calendar.getTime().getTime()));
        List resultList = query.getResultList();
        ArrayList<ConcreteKeyValue> numDocs = new ArrayList<ConcreteKeyValue>(resultList.size());
        for (Object[] result : resultList) {
            numDocs.add(new ConcreteKeyValue(result[1].toString(), result[0].toString()));
        }
        stats.setNumInitiatedDocsByDocType(numDocs);
    }

    @Override
    public void NumUsersReport(Stats stats) throws SQLException, LookupException {
        stats.setNumUsers(this.entityManager.createQuery("select count(distinct uo.workflowId) from UserOptions uo").getSingleResult().toString());
    }

    @Override
    public void NumberOfDocTypesReport(Stats stats) throws SQLException, LookupException {
        stats.setNumDocTypes(this.entityManager.createQuery("select count(*) from DocumentType dt where dt.currentInd = true").getSingleResult().toString());
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

