/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.useroptions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.UserOptionsService;
import org.kuali.rice.kew.useroptions.dao.UserOptionsDAO;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class UserOptionsServiceImpl
implements UserOptionsService {
    private UserOptionsDAO userOptionsDAO;
    private static final Properties defaultProperties = new Properties();

    private Long getNewOptionIdForActionList() {
        return this.getUserOptionsDAO().getNewOptionIdForActionList();
    }

    @Override
    public List<UserOptions> findByUserQualified(String principalId, String likeString) {
        if (principalId == null) {
            return new ArrayList<UserOptions>(0);
        }
        return this.getUserOptionsDAO().findByUserQualified(principalId, likeString);
    }

    @Override
    public UserOptions findByOptionId(String optionId, String principalId) {
        if (optionId == null || "".equals(optionId) || principalId == null || "".equals(principalId)) {
            return null;
        }
        return this.getUserOptionsDAO().findByOptionId(optionId, principalId);
    }

    @Override
    public Collection<UserOptions> findByOptionValue(String optionId, String optionValue) {
        return this.getUserOptionsDAO().findByOptionValue(optionId, optionValue);
    }

    @Override
    public Collection<UserOptions> findByWorkflowUser(String principalId) {
        return this.getUserOptionsDAO().findByWorkflowUser(principalId);
    }

    @Override
    public void save(UserOptions userOptions) {
        this.getUserOptionsDAO().save(userOptions);
    }

    @Override
    public void save(String principalId, Map<String, String> optionsMap) {
        if (optionsMap != null && optionsMap.size() > 0) {
            ArrayList<UserOptions> toSave = new ArrayList<UserOptions>();
            for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
                UserOptions option = this.findByOptionId(entry.getKey(), principalId);
                if (option == null) {
                    option = new UserOptions();
                    option.setWorkflowId(principalId);
                }
                option.setOptionId(entry.getKey());
                option.setOptionVal(entry.getValue());
                toSave.add(option);
            }
            this.getUserOptionsDAO().save(toSave);
        }
    }

    @Override
    public void deleteUserOptions(UserOptions userOptions) {
        this.getUserOptionsDAO().deleteUserOptions(userOptions);
    }

    @Override
    public void save(String principalId, String optionId, String optionValue) {
        if (optionValue.length() <= 2000) {
            UserOptions option = this.findByOptionId(optionId, principalId);
            if (option == null) {
                option = new UserOptions();
                option.setWorkflowId(principalId);
            }
            option.setOptionId(optionId);
            option.setOptionVal(optionValue);
            this.getUserOptionsDAO().save(option);
        }
    }

    public UserOptionsDAO getUserOptionsDAO() {
        return this.userOptionsDAO;
    }

    public void setUserOptionsDAO(UserOptionsDAO optionsDAO) {
        this.userOptionsDAO = optionsDAO;
    }

    @Override
    public List<UserOptions> retrieveEmailPreferenceUserOptions(String emailSetting) {
        return this.getUserOptionsDAO().findEmailUserOptionsByType(emailSetting);
    }

    static {
        defaultProperties.setProperty("EMAIL_NOTIFICATION", "weekly");
    }
}

