/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.useroptions.dao.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.dao.UserOptionsDAO;

public class UserOptionsDaoJpaImpl
implements UserOptionsDAO {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Long getNewOptionIdForActionList() {
        return this.getPlatform().getNextValSQL("KREW_ACTN_LIST_OPTN_S", this.entityManager);
    }

    protected DatabasePlatform getPlatform() {
        return (DatabasePlatform)GlobalResourceLoader.getService((String)"dbPlatform");
    }

    public List findByUserQualified(String principalId, String likeString) {
        return new ArrayList(this.entityManager.createNamedQuery("UserOptions.FindByUserQualified").setParameter("workflowId", (Object)principalId).setParameter("optionId", (Object)likeString).getResultList());
    }

    @Override
    public void deleteByUserQualified(String principalId, String likeString) {
        List userOptions = this.entityManager.createNamedQuery("UserOptions.FindByUserQualified").setParameter("workflowId", (Object)principalId).setParameter("optionId", (Object)likeString).getResultList();
        for (UserOptions uo : userOptions) {
            this.entityManager.remove((Object)uo);
        }
    }

    public Collection findByWorkflowUser(String principalId) {
        return this.entityManager.createNamedQuery("UserOptions.FindByWorkflowId").setParameter("workflowId", (Object)principalId).getResultList();
    }

    @Override
    public void save(UserOptions userOptions) {
        if (userOptions.getOptionId() == null) {
            this.entityManager.persist((Object)userOptions);
        } else {
            this.entityManager.merge((Object)userOptions);
        }
    }

    @Override
    public void save(Collection<UserOptions> userOptions) {
        if (userOptions != null) {
            for (UserOptions option : userOptions) {
                this.save(option);
            }
        }
    }

    @Override
    public void deleteUserOptions(UserOptions userOptions) {
        UserOptions reattatched = (UserOptions)this.entityManager.merge((Object)userOptions);
        this.entityManager.remove((Object)reattatched);
    }

    @Override
    public UserOptions findByOptionId(String optionId, String principalId) {
        return (UserOptions)this.entityManager.createNamedQuery("UserOptions.FindByOptionId").setParameter("optionId", (Object)optionId).setParameter("workflowId", (Object)principalId).getSingleResult();
    }

    public Collection findByOptionValue(String optionId, String optionValue) {
        return this.entityManager.createNamedQuery("UserOptions.FindByOptionValue").setParameter("optionId", (Object)optionId).setParameter("optionValue", (Object)optionValue).getResultList();
    }

    @Override
    public List<UserOptions> findEmailUserOptionsByType(String emailSetting) {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.entityManager.createNamedQuery("UserOptions.FindByOptionValue").setParameter("optionId", (Object)"EMAIL_NOTIFICATION").setParameter("optionIdLike", (Object)"%.DocumentTypeNotification").setParameter("optionValue", (Object)emailSetting).getResultList(), UserOptions.class));
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

