/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.util;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.parameter.ParameterKey;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;

public class ConfigStringLookup
extends StrLookup {
    private final String applicationId;

    public ConfigStringLookup() {
        this(null);
    }

    public ConfigStringLookup(String applicationId) {
        this.applicationId = applicationId;
    }

    public String lookup(String propertyName) {
        if (StringUtils.isBlank((String)propertyName)) {
            return null;
        }
        String paramValue = null;
        if (StringUtils.isBlank((String)this.applicationId)) {
            paramValue = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "All", propertyName);
        } else {
            ParameterKey parameterKey = ParameterKey.create((String)this.applicationId, (String)"KR-WKFLW", (String)"All", (String)propertyName);
            paramValue = CoreServiceApiServiceLocator.getParameterRepositoryService().getParameterValueAsString(parameterKey);
        }
        if (paramValue == null) {
            paramValue = ConfigContext.getCurrentContextConfig().getProperty(propertyName);
        }
        return paramValue;
    }
}

