/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.xml.XmlRenderer;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.web.WebRuleUtils;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;

public class RuleXmlExporter
implements XmlExporter {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    private XmlRenderer renderer;

    public RuleXmlExporter(Namespace namespace) {
        this.renderer = new XmlRenderer(namespace);
    }

    public boolean supportPrettyPrint() {
        return true;
    }

    public Element export(ExportDataSet exportDataSet) {
        KewExportDataSet dataSet = KewExportDataSet.fromExportDataSet(exportDataSet);
        if (!dataSet.getRules().isEmpty()) {
            Element rootElement = this.renderer.renderElement(null, "rules");
            rootElement.setAttribute("schemaLocation", "ns:workflow/Rule resource:Rule", XmlConstants.SCHEMA_NAMESPACE);
            for (RuleBaseValues rule : dataSet.getRules()) {
                this.exportRule(rootElement, rule);
            }
            return rootElement;
        }
        return null;
    }

    public void exportRule(Element parent, RuleBaseValues rule) {
        Element ruleElement = this.renderer.renderElement(parent, "rule");
        if (rule.getName() != null) {
            this.renderer.renderTextElement(ruleElement, "name", rule.getName());
        }
        this.renderer.renderTextElement(ruleElement, "documentType", rule.getDocTypeName());
        if (rule.getRuleTemplateName() != null) {
            this.renderer.renderTextElement(ruleElement, "ruleTemplate", rule.getRuleTemplateName());
        }
        this.renderer.renderTextElement(ruleElement, "description", rule.getDescription());
        if (rule.getFromDateString() != null) {
            this.renderer.renderTextElement(ruleElement, "fromDate", rule.getFromDateString());
        }
        if (rule.getToDateString() != null) {
            this.renderer.renderTextElement(ruleElement, "toDate", rule.getToDateString());
        }
        if (rule.getRuleExpressionDef() != null) {
            Element expressionElement = this.renderer.renderTextElement(ruleElement, "expression", rule.getRuleExpressionDef().getExpression());
            if (rule.getRuleExpressionDef().getType() != null) {
                expressionElement.setAttribute("type", rule.getRuleExpressionDef().getType());
            }
        }
        this.renderer.renderBooleanElement(ruleElement, "forceAction", Boolean.valueOf(rule.isForceAction()), false);
        if (CollectionUtils.isEmpty(rule.getRuleExtensions()) && rule.getFieldValues() != null && rule.getFieldValues().size() != 0) {
            WebRuleUtils.translateResponsibilitiesForSave(rule);
            WebRuleUtils.translateFieldValuesForSave(rule);
            this.exportRuleExtensions(ruleElement, rule.getRuleExtensions());
            WebRuleUtils.populateRuleMaintenanceFields(rule);
        } else {
            this.exportRuleExtensions(ruleElement, rule.getRuleExtensions());
        }
        HashSet<RuleResponsibilityBo> responsibilities = new HashSet<RuleResponsibilityBo>();
        responsibilities.addAll(rule.getRuleResponsibilities());
        responsibilities.addAll(rule.getPersonResponsibilities());
        responsibilities.addAll(rule.getGroupResponsibilities());
        responsibilities.addAll(rule.getRoleResponsibilities());
        this.exportResponsibilities(ruleElement, responsibilities);
    }

    private void exportRuleExtensions(Element parent, List ruleExtensions) {
        if (!ruleExtensions.isEmpty()) {
            Element extsElement = this.renderer.renderElement(parent, "ruleExtensions");
            for (RuleExtensionBo extension : ruleExtensions) {
                Element extElement = this.renderer.renderElement(extsElement, "ruleExtension");
                RuleTemplateAttributeBo attribute = extension.getRuleTemplateAttribute();
                this.renderer.renderTextElement(extElement, "attribute", attribute.getRuleAttribute().getName());
                this.renderer.renderTextElement(extElement, "ruleTemplate", attribute.getRuleTemplate().getName());
                this.exportRuleExtensionValues(extElement, extension.getExtensionValues());
            }
        }
    }

    private void exportRuleExtensionValues(Element parent, List<RuleExtensionValue> extensionValues) {
        if (!extensionValues.isEmpty()) {
            ArrayList<RuleExtensionValue> sorted = new ArrayList<RuleExtensionValue>(extensionValues);
            Collections.sort(sorted, new Comparator<RuleExtensionValue>(){

                @Override
                public int compare(RuleExtensionValue o1, RuleExtensionValue o2) {
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return ObjectUtils.compare((Comparable)((Object)o1.getKey()), (Comparable)((Object)o2.getKey()));
                }
            });
            Element extValuesElement = this.renderer.renderElement(parent, "ruleExtensionValues");
            for (RuleExtensionValue extensionValue : sorted) {
                Element extValueElement = this.renderer.renderElement(extValuesElement, "ruleExtensionValue");
                this.renderer.renderTextElement(extValueElement, "key", extensionValue.getKey());
                this.renderer.renderTextElement(extValueElement, "value", extensionValue.getValue());
            }
        }
    }

    private void exportResponsibilities(Element parent, Collection<? extends RuleResponsibilityBo> responsibilities) {
        if (responsibilities != null && !responsibilities.isEmpty()) {
            Element responsibilitiesElement = this.renderer.renderElement(parent, "responsibilities");
            for (RuleResponsibilityBo ruleResponsibilityBo : responsibilities) {
                Element respElement = this.renderer.renderElement(responsibilitiesElement, "responsibility");
                this.renderer.renderTextElement(respElement, "responsibilityId", "" + ruleResponsibilityBo.getResponsibilityId());
                if (ruleResponsibilityBo.isUsingPrincipal()) {
                    this.renderer.renderTextElement(respElement, "principalName", ruleResponsibilityBo.getPrincipal().getPrincipalName());
                } else if (ruleResponsibilityBo.isUsingGroup()) {
                    Group group = ruleResponsibilityBo.getGroup();
                    Element groupElement = this.renderer.renderTextElement(respElement, "groupName", group.getName());
                    groupElement.setAttribute("namespace", group.getNamespaceCode());
                } else if (ruleResponsibilityBo.isUsingRole()) {
                    this.renderer.renderTextElement(respElement, "role", ruleResponsibilityBo.getRuleResponsibilityName());
                    this.renderer.renderTextElement(respElement, "approvePolicy", ruleResponsibilityBo.getApprovePolicy());
                }
                if (!StringUtils.isBlank((String)ruleResponsibilityBo.getActionRequestedCd())) {
                    this.renderer.renderTextElement(respElement, "actionRequested", ruleResponsibilityBo.getActionRequestedCd());
                }
                if (ruleResponsibilityBo.getPriority() == null) continue;
                this.renderer.renderTextElement(respElement, "priority", ruleResponsibilityBo.getPriority().toString());
            }
        }
    }

    private void exportRuleDelegations(Element rootElement, RuleBaseValues rule) {
        List<RuleDelegationBo> ruleDelegationDefaults = KEWServiceLocator.getRuleDelegationService().findByDelegateRuleId(rule.getId());
        for (RuleDelegationBo dele : ruleDelegationDefaults) {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)("*******delegates********\t" + dele.getRuleDelegationId()));
            }
            this.exportRuleDelegation(rootElement, dele);
        }
    }

    private void exportRuleDelegation(Element parent, RuleDelegationBo ruleDelegation) {
        Element ruleDelegationElement = this.renderer.renderElement(parent, "ruleDelegation");
        this.exportRuleDelegationParentResponsibility(ruleDelegationElement, ruleDelegation);
        this.renderer.renderTextElement(ruleDelegationElement, "delegationType", ruleDelegation.getDelegationType().getCode());
        this.exportRule(ruleDelegationElement, ruleDelegation.getDelegationRule());
    }

    private void exportRuleDelegationParentResponsibility(Element parent, RuleDelegationBo delegation) {
        Element parentResponsibilityElement = this.renderer.renderElement(parent, "parentResponsibility");
        RuleResponsibilityBo ruleResponsibility = KEWServiceLocator.getRuleService().findRuleResponsibility(delegation.getResponsibilityId());
        this.renderer.renderTextElement(parentResponsibilityElement, "parentRuleName", ruleResponsibility.getRuleBaseValues().getName());
        if (ruleResponsibility.isUsingPrincipal()) {
            Principal principal = ruleResponsibility.getPrincipal();
            this.renderer.renderTextElement(parentResponsibilityElement, "principalName", principal.getPrincipalName());
        } else if (ruleResponsibility.isUsingGroup()) {
            Group group = ruleResponsibility.getGroup();
            Element groupElement = this.renderer.renderElement(parentResponsibilityElement, "groupName");
            groupElement.setText(group.getName());
            groupElement.setAttribute("namespace", group.getNamespaceCode());
        } else if (ruleResponsibility.isUsingRole()) {
            this.renderer.renderTextElement(parentResponsibilityElement, "role", ruleResponsibility.getRuleResponsibilityName());
        } else {
            throw new RiceRuntimeException("Encountered a rule responsibility when exporting with an invalid type of '" + ruleResponsibility.getRuleResponsibilityType());
        }
    }
}

