/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.kim.bo.ui.PersonDocumentAffiliationId;
import org.kuali.rice.kim.bo.ui.PersonDocumentBoDefaultBase;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmploymentInfo;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationTypeBo;
import org.kuali.rice.krad.util.ObjectUtils;

@IdClass(value=PersonDocumentAffiliationId.class)
@Entity
@Table(name="KRIM_PND_AFLTN_MT")
public class PersonDocumentAffiliation
extends PersonDocumentBoDefaultBase {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="KRIM_ENTITY_AFLTN_ID_S")
    @GenericGenerator(name="KRIM_ENTITY_AFLTN_ID_S", strategy="org.kuali.rice.core.jpa.spring.RiceNumericStringSequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KRIM_ENTITY_AFLTN_ID_S"), @Parameter(name="value_column", value="id")})
    @Column(name="ENTITY_AFLTN_ID")
    protected String entityAffiliationId;
    @Column(name="AFLTN_TYP_CD")
    protected String affiliationTypeCode;
    @Column(name="CAMPUS_CD")
    protected String campusCode;
    @ManyToOne(targetEntity=EntityAffiliationTypeBo.class, fetch=FetchType.EAGER, cascade={})
    @JoinColumn(name="AFLTN_TYP_CD", insertable=false, updatable=false)
    protected EntityAffiliationTypeBo affiliationType;
    @Transient
    protected PersonDocumentEmploymentInfo newEmpInfo;
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumns(value={@JoinColumn(name="FDOC_NBR", insertable=false, updatable=false), @JoinColumn(name="ENTITY_AFLTN_ID", insertable=false, updatable=false)})
    protected List<PersonDocumentEmploymentInfo> empInfos = new ArrayList<PersonDocumentEmploymentInfo>();

    public PersonDocumentAffiliation() {
        this.setNewEmpInfo(new PersonDocumentEmploymentInfo());
        this.active = true;
    }

    public String getAffiliationTypeCode() {
        if (ObjectUtils.isNull((Object)this.affiliationTypeCode)) {
            return "";
        }
        return this.affiliationTypeCode;
    }

    public String getCampusCode() {
        return this.campusCode;
    }

    public String getEntityAffiliationId() {
        if (ObjectUtils.isNull((Object)this.entityAffiliationId)) {
            return "";
        }
        return this.entityAffiliationId;
    }

    public void setAffiliationTypeCode(String affiliationTypeCode) {
        this.affiliationTypeCode = affiliationTypeCode;
    }

    public void setCampusCode(String campusCode) {
        this.campusCode = campusCode;
    }

    public void setEntityAffiliationId(String entityAffiliationId) {
        this.entityAffiliationId = entityAffiliationId;
    }

    public PersonDocumentEmploymentInfo getNewEmpInfo() {
        return this.newEmpInfo;
    }

    public void setNewEmpInfo(PersonDocumentEmploymentInfo newEmpInfo) {
        this.newEmpInfo = newEmpInfo;
    }

    public List<PersonDocumentEmploymentInfo> getEmpInfos() {
        return this.empInfos;
    }

    public void setEmpInfos(List<PersonDocumentEmploymentInfo> empInfos) {
        this.empInfos = empInfos;
    }

    public EntityAffiliationTypeBo getAffiliationType() {
        if (ObjectUtils.isNull((Object)this.affiliationType)) {
            return null;
        }
        return this.affiliationType;
    }

    public boolean isEmploymentAffiliationType() {
        if (ObjectUtils.isNull((Object)this.affiliationType)) {
            return false;
        }
        return this.affiliationType.isEmploymentAffiliationType();
    }

    public void setAffiliationType(EntityAffiliationTypeBo affiliationType) {
        this.affiliationType = affiliationType;
    }
}

