/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.kim.bo.ui.PersonDocumentBoDefaultBase;
import org.kuali.rice.kim.bo.ui.PersonDocumentPhoneId;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneTypeBo;

@IdClass(value=PersonDocumentPhoneId.class)
@Entity
@Table(name="KRIM_PND_PHONE_MT")
public class PersonDocumentPhone
extends PersonDocumentBoDefaultBase {
    @Id
    @GeneratedValue(generator="KRIM_ENTITY_PHONE_ID_S")
    @GenericGenerator(name="KRIM_ENTITY_PHONE_ID_S", strategy="org.kuali.rice.core.jpa.spring.RiceNumericStringSequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KRIM_ENTITY_PHONE_ID_S"), @Parameter(name="value_column", value="id")})
    @Column(name="ENTITY_PHONE_ID")
    protected String entityPhoneId;
    @Column(name="ENT_TYP_CD")
    protected String entityTypeCode;
    @Column(name="PHONE_TYP_CD")
    protected String phoneTypeCode;
    @Column(name="PHONE_NBR")
    protected String phoneNumber;
    @Column(name="PHONE_EXTN_NBR")
    protected String extensionNumber;
    @Column(name="POSTAL_CNTRY_CD")
    protected String countryCode;
    @ManyToOne(targetEntity=EntityPhoneTypeBo.class, fetch=FetchType.EAGER, cascade={})
    @JoinColumn(name="PHONE_TYP_CD", insertable=false, updatable=false)
    protected EntityPhoneTypeBo phoneType;

    public PersonDocumentPhone() {
        this.active = true;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getEntityPhoneId() {
        return this.entityPhoneId;
    }

    public String getExtensionNumber() {
        return this.extensionNumber;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getPhoneTypeCode() {
        return this.phoneTypeCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setExtensionNumber(String extensionNumber) {
        this.extensionNumber = extensionNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setPhoneTypeCode(String phoneTypeCode) {
        this.phoneTypeCode = phoneTypeCode;
    }

    public String getEntityTypeCode() {
        return this.entityTypeCode;
    }

    public void setEntityTypeCode(String entityTypeCode) {
        this.entityTypeCode = entityTypeCode;
    }

    public EntityPhoneTypeBo getPhoneType() {
        return this.phoneType;
    }

    public void setPhoneType(EntityPhoneTypeBo phoneType) {
        this.phoneType = phoneType;
    }

    public void setEntityPhoneId(String entityPhoneId) {
        this.entityPhoneId = entityPhoneId;
    }

    public String getFormattedPhoneNumber() {
        StringBuffer sb = new StringBuffer(30);
        sb.append(this.getPhoneNumber());
        if (StringUtils.isNotBlank((String)this.getExtensionNumber())) {
            sb.append(" x");
            sb.append(this.getExtensionNumber());
        }
        return sb.toString();
    }
}

