/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.impl.KimAttributes;
import org.kuali.rice.kim.bo.ui.KimDocumentBoActivatableEditableBase;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.PersonDocumentRoleId;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.springframework.util.AutoPopulatingList;
import org.springframework.util.StringUtils;

@Entity
@IdClass(value=PersonDocumentRoleId.class)
@Table(name="KRIM_PND_ROLE_MT", uniqueConstraints={@UniqueConstraint(columnNames={"FDOC_NBR", "ROLE_ID"})})
public class PersonDocumentRole
extends KimDocumentBoActivatableEditableBase {
    private static final Logger LOG = Logger.getLogger(PersonDocumentRole.class);
    private static final long serialVersionUID = 4908044213007222739L;
    @Id
    @Column(name="ROLE_ID")
    protected String roleId;
    @Column(name="KIM_TYP_ID")
    protected String kimTypeId;
    @Column(name="ROLE_NM")
    protected String roleName;
    @Transient
    protected RoleBo roleBo;
    @Column(name="NMSPC_CD")
    protected String namespaceCode;
    @Transient
    protected KimTypeBo kimRoleType;
    @Transient
    protected List<? extends KimAttributes> attributes;
    @Transient
    protected transient List<KimAttributeField> definitions;
    @Transient
    protected transient Map<String, Object> attributeEntry;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumns(value={@JoinColumn(name="ROLE_ID", insertable=false, updatable=false), @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)})
    protected List<KimDocumentRoleMember> rolePrncpls;
    @Transient
    protected KimDocumentRoleMember newRolePrncpl;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="ROLE_ID", insertable=false, updatable=false)
    protected List<RoleResponsibilityBo> assignedResponsibilities = new AutoPopulatingList(RoleResponsibilityBo.class);
    @Transient
    protected boolean isEditable = true;

    public PersonDocumentRole() {
        this.attributes = new ArrayList<KimAttributes>();
        this.rolePrncpls = new ArrayList<KimDocumentRoleMember>();
        this.attributeEntry = new HashMap<String, Object>();
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getKimTypeId() {
        return this.kimTypeId;
    }

    public void setKimTypeId(String kimTypeId) {
        this.kimTypeId = kimTypeId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public List<? extends KimAttributes> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<? extends KimAttributes> attributes) {
        this.attributes = attributes;
    }

    public KimTypeBo getKimRoleType() {
        if (this.kimRoleType == null && StringUtils.hasText((String)this.kimTypeId)) {
            this.kimRoleType = KimTypeBo.from((KimType)KimApiServiceLocator.getKimTypeInfoService().getKimType(this.kimTypeId));
        }
        return this.kimRoleType;
    }

    public Map<String, KimAttributeField> getDefinitionsKeyedByAttributeName() {
        HashMap<String, KimAttributeField> map = new HashMap<String, KimAttributeField>();
        for (KimAttributeField field : this.getDefinitions()) {
            map.put(field.getAttributeField().getName(), field);
        }
        return map;
    }

    public List<KimAttributeField> getDefinitions() {
        if (this.definitions == null || this.definitions.isEmpty()) {
            KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)KimTypeBo.to((KimTypeBo)this.getKimRoleType()));
            try {
                this.definitions = kimTypeService != null ? kimTypeService.getAttributeDefinitions(this.getKimTypeId()) : Collections.emptyList();
            }
            catch (Exception ex) {
                LOG.warn((Object)("Not able to retrieve KimTypeService from remote system for KIM Role Type: " + this.getKimRoleType()), (Throwable)ex);
            }
        }
        return this.definitions;
    }

    public void setDefinitions(List<KimAttributeField> definitions) {
        this.definitions = definitions;
    }

    public Map<String, Object> getAttributeEntry() {
        if (this.attributeEntry == null || this.attributeEntry.isEmpty()) {
            this.attributeEntry = KIMServiceLocatorInternal.getUiDocumentService().getAttributeEntries(this.getDefinitions());
        }
        return this.attributeEntry;
    }

    public void setAttributeEntry(Map<String, Object> attributeEntry) {
        this.attributeEntry = attributeEntry;
    }

    public List<KimDocumentRoleMember> getRolePrncpls() {
        return this.rolePrncpls;
    }

    public void setRolePrncpls(List<KimDocumentRoleMember> rolePrncpls) {
        this.rolePrncpls = rolePrncpls;
    }

    public KimDocumentRoleMember getNewRolePrncpl() {
        return this.newRolePrncpl;
    }

    public void setNewRolePrncpl(KimDocumentRoleMember newRolePrncpl) {
        this.newRolePrncpl = newRolePrncpl;
    }

    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    public void setNamespaceCode(String namespaceCode) {
        this.namespaceCode = namespaceCode;
    }

    public List<RoleResponsibilityBo> getAssignedResponsibilities() {
        return this.assignedResponsibilities;
    }

    public void setAssignedResponsibilities(List<RoleResponsibilityBo> assignedResponsibilities) {
        this.assignedResponsibilities = assignedResponsibilities;
    }

    public RoleBo getRoleBo() {
        return this.roleBo;
    }

    public void setRoleBo(RoleBo roleBo) {
        this.roleBo = roleBo;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }
}

