/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.GroupDocumentMember;
import org.kuali.rice.kim.bo.ui.GroupDocumentQualifier;
import org.kuali.rice.kim.impl.type.IdentityManagementTypeAttributeTransactionalDocument;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.springframework.util.AutoPopulatingList;

@Entity
@AttributeOverrides(value={@AttributeOverride(name="documentNumber", column=@Column(name="FDOC_NBR"))})
@Table(name="KRIM_GRP_DOCUMENT_T")
public class IdentityManagementGroupDocument
extends IdentityManagementTypeAttributeTransactionalDocument {
    private static final Logger LOG = Logger.getLogger(IdentityManagementGroupDocument.class);
    private static final long serialVersionUID = 1L;
    @Column(name="GRP_ID")
    protected String groupId;
    @Column(name="KIM_TYP_ID")
    protected String groupTypeId;
    @Transient
    protected String groupTypeName;
    @Column(name="GRP_NMSPC")
    protected String groupNamespace;
    @Column(name="GRP_NM")
    protected String groupName;
    @Column(name="GRP_DESC")
    protected String groupDescription;
    @Type(type="yes_no")
    @Column(name="ACTV_IND")
    protected boolean active = true;
    @Transient
    protected boolean editing;
    @OneToMany(targetEntity=GroupDocumentMember.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)
    private List<GroupDocumentMember> members = new AutoPopulatingList(GroupDocumentMember.class);
    @OneToMany(targetEntity=GroupDocumentQualifier.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)
    private List<GroupDocumentQualifier> qualifiers = new AutoPopulatingList(GroupDocumentQualifier.class);

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setRoleId(String groupId) {
        this.groupId = groupId;
    }

    public void addMember(GroupDocumentMember member) {
        this.getMembers().add(member);
    }

    @Override
    public KimType getKimType() {
        if (this.getGroupTypeId() != null) {
            return KimApiServiceLocator.getKimTypeInfoService().getKimType(this.getGroupTypeId());
        }
        return null;
    }

    public GroupDocumentMember getBlankMember() {
        return new GroupDocumentMember();
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            KIMServiceLocatorInternal.getUiDocumentService().saveGroup(this);
        }
    }

    public void prepareForSave() {
        String groupId;
        if (StringUtils.isBlank((String)this.getGroupId())) {
            SequenceAccessorService sas = this.getSequenceAccessorService();
            Long nextSeq = sas.getNextAvailableSequenceNumber("KRIM_GRP_ID_S", ((Object)((Object)this)).getClass());
            groupId = nextSeq.toString();
            this.setGroupId(groupId);
        } else {
            groupId = this.getGroupId();
        }
        if (this.getMembers() != null) {
            for (GroupDocumentMember member : this.getMembers()) {
                member.setGroupId(this.getGroupId());
                if (StringUtils.isBlank((String)member.getGroupMemberId())) {
                    SequenceAccessorService sas = this.getSequenceAccessorService();
                    Long nextSeq = sas.getNextAvailableSequenceNumber("KRIM_GRP_MBR_ID_S", ((Object)((Object)this)).getClass());
                    String groupMemberId = nextSeq.toString();
                    member.setGroupMemberId(groupMemberId);
                }
                if (!StringUtils.isBlank((String)member.getDocumentNumber())) continue;
                member.setDocumentNumber(this.getDocumentNumber());
            }
        }
        int index = 0;
        if (this.getDefinitions() != null) {
            for (KimAttributeField key : this.getDefinitions()) {
                if (this.getQualifiers().size() > index) {
                    GroupDocumentQualifier qualifier = this.getQualifiers().get(index);
                    qualifier.setKimAttrDefnId(this.getKimAttributeDefnId(key));
                    qualifier.setKimTypId(this.getKimType().getId());
                    qualifier.setGroupId(groupId);
                }
                ++index;
            }
        }
    }

    public void initializeDocumentForNewGroup() {
        if (StringUtils.isBlank((String)this.groupId)) {
            SequenceAccessorService sas = this.getSequenceAccessorService();
            Long nextSeq = sas.getNextAvailableSequenceNumber("KRIM_GRP_ID_S", ((Object)((Object)this)).getClass());
            this.groupId = nextSeq.toString();
        }
        if (StringUtils.isBlank((String)this.groupTypeId)) {
            this.groupTypeId = "1";
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupDescription() {
        return this.groupDescription;
    }

    public void setGroupDescription(String groupDescription) {
        this.groupDescription = groupDescription;
    }

    public String getGroupNamespace() {
        return this.groupNamespace;
    }

    public void setGroupNamespace(String groupNamespace) {
        this.groupNamespace = groupNamespace;
    }

    public String getGroupTypeId() {
        return this.groupTypeId;
    }

    public void setGroupTypeId(String groupTypeId) {
        this.groupTypeId = groupTypeId;
    }

    public String getGroupTypeName() {
        return this.groupTypeName;
    }

    public void setGroupTypeName(String groupTypeName) {
        this.groupTypeName = groupTypeName;
    }

    public List<GroupDocumentMember> getMembers() {
        return this.members;
    }

    public void setMembers(List<GroupDocumentMember> members) {
        this.members = members;
    }

    public List<GroupDocumentQualifier> getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(List<GroupDocumentQualifier> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public GroupDocumentQualifier getQualifier(String kimAttributeDefnId) {
        for (GroupDocumentQualifier qualifier : this.qualifiers) {
            if (!qualifier.getKimAttrDefnId().equals(kimAttributeDefnId)) continue;
            return qualifier;
        }
        return null;
    }

    public Map<String, String> getQualifiersAsAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (GroupDocumentQualifier qualifier : this.qualifiers) {
            if (qualifier.getKimAttribute() != null) {
                attributes.put(qualifier.getKimAttribute().getAttributeName(), qualifier.getAttrVal());
                continue;
            }
            LOG.warn((Object)("Unknown attribute ID on group: " + qualifier.getKimAttrDefnId() + " / value=" + qualifier.getAttrVal()));
            attributes.put("Unknown Attribute ID: " + qualifier.getKimAttrDefnId(), qualifier.getAttrVal());
        }
        return attributes;
    }

    @Override
    public void setDefinitions(List<KimAttributeField> definitions) {
        super.setDefinitions(definitions);
        if (this.getQualifiers() == null || this.getQualifiers().size() < 1) {
            this.setQualifiers(new ArrayList<GroupDocumentQualifier>());
            if (this.getDefinitions() != null) {
                for (KimAttributeField key : this.getDefinitions()) {
                    GroupDocumentQualifier qualifier = new GroupDocumentQualifier();
                    qualifier.setKimAttrDefnId(this.getKimAttributeDefnId(key));
                    this.getQualifiers().add(qualifier);
                }
            }
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    @Override
    public void setKimType(KimType kimType) {
        super.setKimType(kimType);
        if (kimType != null) {
            this.setGroupTypeId(kimType.getId());
            this.setGroupTypeName(kimType.getName());
        }
    }
}

