/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document;

import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegation;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.krad.document.TransactionalDocumentBase;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.springframework.util.AutoPopulatingList;

@MappedSuperclass
@AttributeOverrides(value={@AttributeOverride(name="documentNumber", column=@Column(name="FDOC_NBR"))})
@AssociationOverrides(value={@AssociationOverride(name="documentHeader", joinColumns={@JoinColumn(name="FDOC_NBR", referencedColumnName="DOC_HDR_ID", insertable=false, updatable=false)})})
public class IdentityManagementKimDocument
extends TransactionalDocumentBase {
    protected static final Logger LOG = Logger.getLogger(IdentityManagementKimDocument.class);
    @OneToMany(targetEntity=RoleDocumentDelegation.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)
    protected List<RoleDocumentDelegation> delegations = new AutoPopulatingList(RoleDocumentDelegation.class);
    @Transient
    protected List<RoleDocumentDelegationMember> delegationMembers = new AutoPopulatingList(RoleDocumentDelegationMember.class);
    @Transient
    protected transient SequenceAccessorService sequenceAccessorService;

    protected void addDelegationMemberToDelegation(RoleDocumentDelegationMember delegationMember) {
        RoleDocumentDelegation delegation = DelegationType.PRIMARY.getCode().equals(delegationMember.getDelegationTypeCode()) ? this.getPrimaryDelegation() : this.getSecondaryDelegation();
        delegationMember.setDelegationId(delegation.getDelegationId());
        delegation.getMembers().add(delegationMember);
        delegation.setRoleId(delegationMember.getRoleBo().getId());
        delegation.setKimTypeId(delegationMember.getRoleBo().getKimTypeId());
    }

    protected RoleDocumentDelegation getPrimaryDelegation() {
        RoleDocumentDelegation primaryDelegation = null;
        for (RoleDocumentDelegation delegation : this.getDelegations()) {
            if (!delegation.isDelegationPrimary()) continue;
            primaryDelegation = delegation;
        }
        if (primaryDelegation == null) {
            primaryDelegation = new RoleDocumentDelegation();
            primaryDelegation.setDelegationId(this.getDelegationId());
            primaryDelegation.setDelegationTypeCode(DelegationType.PRIMARY.getCode());
            this.getDelegations().add(primaryDelegation);
        }
        return primaryDelegation;
    }

    protected String getDelegationId() {
        return this.getSequenceAccessorService().getNextAvailableSequenceNumber("KRIM_DLGN_ID_S", ((Object)((Object)this)).getClass()).toString();
    }

    protected RoleDocumentDelegation getSecondaryDelegation() {
        RoleDocumentDelegation secondaryDelegation = null;
        for (RoleDocumentDelegation delegation : this.getDelegations()) {
            if (!delegation.isDelegationSecondary()) continue;
            secondaryDelegation = delegation;
        }
        if (secondaryDelegation == null) {
            secondaryDelegation = new RoleDocumentDelegation();
            secondaryDelegation.setDelegationId(this.getDelegationId());
            secondaryDelegation.setDelegationTypeCode(DelegationType.SECONDARY.getCode());
            this.getDelegations().add(secondaryDelegation);
        }
        return secondaryDelegation;
    }

    public List<RoleDocumentDelegation> getDelegations() {
        return this.delegations;
    }

    public void setDelegations(List<RoleDocumentDelegation> delegations) {
        this.delegations = delegations;
    }

    public List<RoleDocumentDelegationMember> getDelegationMembers() {
        return this.delegationMembers;
    }

    public void setDelegationMembers(List<RoleDocumentDelegationMember> delegationMembers) {
        this.delegationMembers = delegationMembers;
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KRADServiceLocator.getSequenceAccessorService();
        }
        return this.sequenceAccessorService;
    }

    public String getKimAttributeDefnId(KimAttributeField definition) {
        return definition.getId();
    }
}

