/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.PersonDocumentAddress;
import org.kuali.rice.kim.bo.ui.PersonDocumentAffiliation;
import org.kuali.rice.kim.bo.ui.PersonDocumentCitizenship;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmail;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmploymentInfo;
import org.kuali.rice.kim.bo.ui.PersonDocumentGroup;
import org.kuali.rice.kim.bo.ui.PersonDocumentName;
import org.kuali.rice.kim.bo.ui.PersonDocumentPhone;
import org.kuali.rice.kim.bo.ui.PersonDocumentPrivacy;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMemberQualifier;
import org.kuali.rice.kim.document.IdentityManagementKimDocument;
import org.kuali.rice.kim.impl.type.KimTypeAttributesHelper;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.service.UiDocumentService;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;

@Entity
@AttributeOverrides(value={@AttributeOverride(name="documentNumber", column=@Column(name="FDOC_NBR"))})
@AssociationOverrides(value={@AssociationOverride(name="documentHeader", joinColumns={@JoinColumn(name="FDOC_NBR", referencedColumnName="DOC_HDR_ID", insertable=false, updatable=false)})})
@Table(name="KRIM_PERSON_DOCUMENT_T")
public class IdentityManagementPersonDocument
extends IdentityManagementKimDocument {
    protected static final long serialVersionUID = -534993712085516925L;
    @GeneratedValue(generator="KRIM_PRNCPL_ID_S")
    @GenericGenerator(name="KRIM_PRNCPL_ID_S", strategy="org.kuali.rice.core.jpa.spring.RiceNumericStringSequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KRIM_PRNCPL_ID_S"), @Parameter(name="value_column", value="id")})
    @Column(name="PRNCPL_ID")
    protected String principalId;
    @Column(name="PRNCPL_NM")
    protected String principalName;
    @GeneratedValue(generator="KRIM_ENTITY_ID_S")
    @GenericGenerator(name="KRIM_ENTITY_ID_S", strategy="org.kuali.rice.core.jpa.spring.RiceNumericStringSequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KRIM_ENTITY_ID_S"), @Parameter(name="value_column", value="id")})
    @Column(name="ENTITY_ID")
    protected String entityId;
    @Type(type="org.kuali.rice.krad.util.HibernateKualiHashType")
    @Column(name="PRNCPL_PSWD")
    protected String password;
    protected String univId = "";
    @OneToMany(targetEntity=PersonDocumentAffiliation.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentAffiliation> affiliations = new ArrayList<PersonDocumentAffiliation>();
    @Transient
    protected String campusCode = "";
    @Transient
    protected Map<String, String> externalIdentifiers = null;
    @Column(name="ACTV_IND")
    @Type(type="yes_no")
    protected boolean active = true;
    @Transient
    protected List<PersonDocumentCitizenship> citizenships = new ArrayList<PersonDocumentCitizenship>();
    @OneToMany(targetEntity=PersonDocumentName.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentName> names = new ArrayList<PersonDocumentName>();
    @OneToMany(targetEntity=PersonDocumentAddress.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentAddress> addrs = new ArrayList<PersonDocumentAddress>();
    @OneToMany(targetEntity=PersonDocumentPhone.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="FDOC_NBR")
    protected List<PersonDocumentPhone> phones = new ArrayList<PersonDocumentPhone>();
    @OneToMany(targetEntity=PersonDocumentEmail.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentEmail> emails = new ArrayList<PersonDocumentEmail>();
    @OneToMany(targetEntity=PersonDocumentGroup.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentGroup> groups = new ArrayList<PersonDocumentGroup>();
    @OneToMany(targetEntity=PersonDocumentRole.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentRole> roles = new ArrayList<PersonDocumentRole>();
    @OneToOne(targetEntity=PersonDocumentPrivacy.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)
    protected PersonDocumentPrivacy privacy = new PersonDocumentPrivacy();
    @Transient
    protected transient DocumentHelperService documentHelperService;
    @Transient
    protected transient UiDocumentService uiDocumentService;

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public List<PersonDocumentAffiliation> getAffiliations() {
        return this.affiliations;
    }

    public void setAffiliations(List<PersonDocumentAffiliation> affiliations) {
        this.affiliations = affiliations;
    }

    public String getCampusCode() {
        return this.campusCode;
    }

    public void setCampusCode(String campusCode) {
        this.campusCode = campusCode;
    }

    public Map<String, String> getExternalIdentifiers() {
        return this.externalIdentifiers;
    }

    public void setExternalIdentifiers(Map<String, String> externalIdentifiers) {
        this.externalIdentifiers = externalIdentifiers;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<PersonDocumentCitizenship> getCitizenships() {
        return this.citizenships;
    }

    public void setCitizenships(List<PersonDocumentCitizenship> citizenships) {
        this.citizenships = citizenships;
    }

    public List<PersonDocumentName> getNames() {
        return this.names;
    }

    public void setNames(List<PersonDocumentName> names) {
        this.names = names;
    }

    public List<PersonDocumentAddress> getAddrs() {
        return this.addrs;
    }

    public void setAddrs(List<PersonDocumentAddress> addrs) {
        this.addrs = addrs;
    }

    public List<PersonDocumentPhone> getPhones() {
        return this.phones;
    }

    public void setPhones(List<PersonDocumentPhone> phones) {
        this.phones = phones;
    }

    public List<PersonDocumentEmail> getEmails() {
        return this.emails;
    }

    public void setEmails(List<PersonDocumentEmail> emails) {
        this.emails = emails;
    }

    public void setGroups(List<PersonDocumentGroup> groups) {
        this.groups = groups;
    }

    public List<PersonDocumentRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<PersonDocumentRole> roles) {
        this.roles = roles;
    }

    public List<PersonDocumentGroup> getGroups() {
        return this.groups;
    }

    public String getUnivId() {
        return this.univId;
    }

    public void setUnivId(String univId) {
        this.univId = univId;
    }

    public PersonDocumentPrivacy getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(PersonDocumentPrivacy privacy) {
        this.privacy = privacy;
    }

    public void initializeDocumentForNewPerson() {
        if (StringUtils.isBlank((String)this.principalId)) {
            this.principalId = this.getSequenceAccessorService().getNextAvailableSequenceNumber("KRIM_PRNCPL_ID_S", ((Object)((Object)this)).getClass()).toString();
        }
        if (StringUtils.isBlank((String)this.entityId)) {
            this.entityId = this.getSequenceAccessorService().getNextAvailableSequenceNumber("KRIM_ENTITY_ID_S", ((Object)((Object)this)).getClass()).toString();
        }
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        ArrayList<PersonDocumentEmploymentInfo> empInfos = new ArrayList<PersonDocumentEmploymentInfo>();
        for (PersonDocumentAffiliation affiliation : this.getAffiliations()) {
            empInfos.addAll(affiliation.getEmpInfos());
        }
        managedLists.add(empInfos);
        managedLists.add(this.getAffiliations());
        managedLists.add(this.getCitizenships());
        managedLists.add(this.getPhones());
        managedLists.add(this.getAddrs());
        managedLists.add(this.getEmails());
        managedLists.add(this.getNames());
        managedLists.add(this.getGroups());
        managedLists.add(this.getRoles());
        return managedLists;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            this.setIfRolesEditable();
            KIMServiceLocatorInternal.getUiDocumentService().saveEntityPerson(this);
        }
    }

    public void prepareForSave() {
        Long nextSeq;
        SequenceAccessorService sas;
        if (StringUtils.isBlank((String)this.getPrivacy().getDocumentNumber())) {
            this.getPrivacy().setDocumentNumber(this.getDocumentNumber());
        }
        this.setEmployeeRecordIds();
        for (PersonDocumentRole role : this.getRoles()) {
            role.setDocumentNumber(this.getDocumentNumber());
            for (KimDocumentRoleMember rolePrncpl : role.getRolePrncpls()) {
                rolePrncpl.setDocumentNumber(this.getDocumentNumber());
                rolePrncpl.setRoleId(role.getRoleId());
                if (StringUtils.isEmpty((String)rolePrncpl.getRoleMemberId())) {
                    SequenceAccessorService sas2 = this.getSequenceAccessorService();
                    Long nextSeq2 = sas2.getNextAvailableSequenceNumber("KRIM_ROLE_MBR_ID_S", ((Object)((Object)this)).getClass());
                    String roleMemberId = nextSeq2.toString();
                    rolePrncpl.setRoleMemberId(roleMemberId);
                }
                for (KimDocumentRoleQualifier qualifier : rolePrncpl.getQualifiers()) {
                    qualifier.setDocumentNumber(this.getDocumentNumber());
                    qualifier.setKimTypId(role.getKimTypeId());
                }
            }
        }
        if (this.getDelegationMembers() != null) {
            for (RoleDocumentDelegationMember delegationMember : this.getDelegationMembers()) {
                delegationMember.setDocumentNumber(this.getDocumentNumber());
                for (RoleDocumentDelegationMemberQualifier qualifier : delegationMember.getQualifiers()) {
                    qualifier.setDocumentNumber(this.getDocumentNumber());
                    qualifier.setKimTypId(delegationMember.getRoleBo().getKimTypeId());
                }
                this.addDelegationMemberToDelegation(delegationMember);
            }
        }
        if (this.getAddrs() != null) {
            for (PersonDocumentAddress address : this.getAddrs()) {
                address.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isEmpty((String)address.getEntityAddressId())) continue;
                sas = this.getSequenceAccessorService();
                nextSeq = sas.getNextAvailableSequenceNumber("KRIM_ENTITY_ADDR_ID_S", ((Object)((Object)this)).getClass());
                String entityAddressId = nextSeq.toString();
                address.setEntityAddressId(entityAddressId);
            }
        }
        if (this.getAffiliations() != null) {
            for (PersonDocumentAffiliation affiliation : this.getAffiliations()) {
                affiliation.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isEmpty((String)affiliation.getEntityAffiliationId())) continue;
                sas = this.getSequenceAccessorService();
                nextSeq = sas.getNextAvailableSequenceNumber("KRIM_ENTITY_AFLTN_ID_S", ((Object)((Object)this)).getClass());
                String affiliationId = nextSeq.toString();
                affiliation.setEntityAffiliationId(affiliationId);
            }
        }
        if (this.getEmails() != null) {
            for (PersonDocumentEmail email : this.getEmails()) {
                email.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isEmpty((String)email.getEntityEmailId())) continue;
                sas = this.getSequenceAccessorService();
                nextSeq = sas.getNextAvailableSequenceNumber("KRIM_ENTITY_EMAIL_ID_S", ((Object)((Object)this)).getClass());
                String entityEmailId = nextSeq.toString();
                email.setEntityEmailId(entityEmailId);
            }
        }
        if (this.getGroups() != null) {
            for (PersonDocumentGroup group : this.getGroups()) {
                group.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isEmpty((String)group.getGroupMemberId())) continue;
                sas = this.getSequenceAccessorService();
                nextSeq = sas.getNextAvailableSequenceNumber("KRIM_GRP_MBR_ID_S", ((Object)((Object)this)).getClass());
                String groupMemberId = nextSeq.toString();
                group.setGroupMemberId(groupMemberId);
            }
        }
        if (this.getNames() != null) {
            for (PersonDocumentName name : this.getNames()) {
                name.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isEmpty((String)name.getEntityNameId())) continue;
                sas = this.getSequenceAccessorService();
                nextSeq = sas.getNextAvailableSequenceNumber("KRIM_ENTITY_NM_ID_S", ((Object)((Object)this)).getClass());
                String entityNameId = nextSeq.toString();
                name.setEntityNameId(entityNameId);
            }
        }
        if (this.getPhones() != null) {
            for (PersonDocumentPhone phone : this.getPhones()) {
                phone.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isEmpty((String)phone.getEntityPhoneId())) continue;
                sas = this.getSequenceAccessorService();
                nextSeq = sas.getNextAvailableSequenceNumber("KRIM_ENTITY_PHONE_ID_S", ((Object)((Object)this)).getClass());
                String entityPhoneId = nextSeq.toString();
                phone.setEntityPhoneId(entityPhoneId);
            }
        }
    }

    protected void setEmployeeRecordIds() {
        List<EntityEmployment> empInfos = this.getUiDocumentService().getEntityEmploymentInformationInfo(this.getEntityId());
        for (PersonDocumentAffiliation affiliation : this.getAffiliations()) {
            int employeeRecordCounter = CollectionUtils.isEmpty(empInfos) ? 0 : empInfos.size();
            for (PersonDocumentEmploymentInfo empInfo : affiliation.getEmpInfos()) {
                if (CollectionUtils.isNotEmpty(empInfos)) {
                    for (EntityEmployment origEmpInfo : empInfos) {
                        if (!origEmpInfo.getId().equals(empInfo.getEntityEmploymentId())) continue;
                        empInfo.setEmploymentRecordId(origEmpInfo.getEmploymentRecordId());
                    }
                }
                if (!StringUtils.isEmpty((String)empInfo.getEmploymentRecordId())) continue;
                empInfo.setEmploymentRecordId(++employeeRecordCounter + "");
            }
        }
    }

    public KimTypeAttributesHelper getKimTypeAttributesHelper(String roleId) {
        Role role = KimApiServiceLocator.getRoleService().getRole(roleId);
        KimType kimTypeInfo = KimApiServiceLocator.getKimTypeInfoService().getKimType(role.getKimTypeId());
        return new KimTypeAttributesHelper(kimTypeInfo);
    }

    public void setIfRolesEditable() {
        if (CollectionUtils.isNotEmpty(this.getRoles())) {
            for (PersonDocumentRole role : this.getRoles()) {
                role.setEditable(this.validAssignRole(role));
            }
        }
    }

    public boolean validAssignRole(PersonDocumentRole role) {
        boolean rulePassed = true;
        if (StringUtils.isNotEmpty((String)role.getNamespaceCode())) {
            HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
            additionalPermissionDetails.put("namespaceCode", role.getNamespaceCode());
            additionalPermissionDetails.put("roleName", role.getRoleName());
            if (!this.getDocumentHelperService().getDocumentAuthorizer((Document)this).isAuthorizedByTemplate((Object)this, "KR-IDM", "Assign Role", GlobalVariables.getUserSession().getPrincipalId(), additionalPermissionDetails, null)) {
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    protected DocumentHelperService getDocumentHelperService() {
        if (this.documentHelperService == null) {
            this.documentHelperService = KNSServiceLocator.getDocumentHelperService();
        }
        return this.documentHelperService;
    }

    protected UiDocumentService getUiDocumentService() {
        if (this.uiDocumentService == null) {
            this.uiDocumentService = KIMServiceLocatorInternal.getUiDocumentService();
        }
        return this.uiDocumentService;
    }
}

