/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.inquiry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.rice.coreservice.impl.namespace.NamespaceBo;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.permission.PermissionAttributeBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.UberPermissionBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RolePermissionBo;
import org.kuali.rice.kim.inquiry.RoleMemberInquirableImpl;
import org.kuali.rice.kim.lookup.RoleLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.util.ObjectUtils;

public class PermissionInquirableImpl
extends RoleMemberInquirableImpl {
    private static transient PermissionService permissionService;

    public void buildInquirableLink(Object dataObject, String propertyName, Inquiry inquiry) {
        if ("name".equals(propertyName) || "nameToDisplay".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("id", "id");
            inquiry.buildInquiryLink(dataObject, propertyName, UberPermissionBo.class, primaryKeys);
        } else if ("namespaceCode".equals(propertyName) || "template.namespaceCode".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put(propertyName, "code");
            inquiry.buildInquiryLink(dataObject, propertyName, NamespaceBo.class, primaryKeys);
        } else if ("detailObjects".equals(propertyName)) {
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        } else if ("assignedToRolesToDisplay".equals(propertyName)) {
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        } else {
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        }
    }

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if ("name".equals(attributeName) || "nameToDisplay".equals(attributeName)) {
            ArrayList<String> primaryKeys = new ArrayList<String>();
            primaryKeys.add("id");
            return this.getInquiryUrlForPrimaryKeys(UberPermissionBo.class, businessObject, primaryKeys, null);
        }
        if ("namespaceCode".equals(attributeName) || "template.namespaceCode".equals(attributeName)) {
            ArrayList<String> primaryKeys = new ArrayList<String>();
            primaryKeys.add("code");
            NamespaceBo parameterNamespace = new NamespaceBo();
            parameterNamespace.setCode((String)ObjectUtils.getPropertyValue((Object)businessObject, (String)attributeName));
            return this.getInquiryUrlForPrimaryKeys(NamespaceBo.class, parameterNamespace, primaryKeys, null);
        }
        if (!"detailObjects".equals(attributeName) && "assignedToRolesToDisplay".equals(attributeName)) {
            return this.getAssignedRoleInquiryUrl(businessObject);
        }
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }

    protected HtmlData getAttributesInquiryUrl(BusinessObject businessObject, String attributeName) {
        List permissionAttributeData = (List)ObjectUtils.getPropertyValue((Object)businessObject, (String)attributeName);
        ArrayList<HtmlData.AnchorHtmlData> htmlData = new ArrayList<HtmlData.AnchorHtmlData>();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        primaryKeys.add("attributeDataId");
        for (PermissionAttributeBo permissionAttributeDataImpl : permissionAttributeData) {
            htmlData.add(this.getInquiryUrlForPrimaryKeys(PermissionAttributeBo.class, permissionAttributeDataImpl, primaryKeys, this.getKimAttributeLabelFromDD(permissionAttributeDataImpl.getKimAttribute().getAttributeName()) + " : " + permissionAttributeDataImpl.getAttributeValue()));
        }
        return new HtmlData.MultipleAnchorHtmlData(htmlData);
    }

    protected HtmlData getAssignedRoleInquiryUrl(BusinessObject businessObject) {
        UberPermissionBo permission = (UberPermissionBo)businessObject;
        List assignedToRoles = permission.getAssignedToRoles();
        ArrayList<HtmlData.AnchorHtmlData> htmlData = new ArrayList<HtmlData.AnchorHtmlData>();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        primaryKeys.add("id");
        if (assignedToRoles != null && !assignedToRoles.isEmpty()) {
            RoleService roleService = KimApiServiceLocator.getRoleService();
            for (RoleBo roleImpl : assignedToRoles) {
                Role roleInfo = roleService.getRole(roleImpl.getId());
                HtmlData.AnchorHtmlData inquiryHtmlData = this.getInquiryUrlForPrimaryKeys(RoleBo.class, roleInfo, primaryKeys, roleInfo.getNamespaceCode() + " " + roleInfo.getName());
                inquiryHtmlData.setHref(RoleLookupableHelperServiceImpl.getCustomRoleInquiryHref(inquiryHtmlData.getHref()));
                inquiryHtmlData.setTarget("_blank");
                htmlData.add(inquiryHtmlData);
            }
        }
        return new HtmlData.MultipleAnchorHtmlData(htmlData);
    }

    public Object retrieveDataObject(Map fieldValues) {
        return this.getBusinessObject(fieldValues);
    }

    public BusinessObject getBusinessObject(Map fieldValues) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("id", fieldValues.get("id").toString());
        PermissionBo permissionBo = (PermissionBo)KRADServiceLocator.getBusinessObjectService().findByPrimaryKey(PermissionBo.class, criteria);
        return this.getPermissionsSearchResultsCopy(permissionBo);
    }

    public PermissionService getPermissionService() {
        if (permissionService == null) {
            permissionService = KimApiServiceLocator.getPermissionService();
        }
        return permissionService;
    }

    private PermissionBo getPermissionsSearchResultsCopy(PermissionBo permissionSearchResult) {
        UberPermissionBo permissionSearchResultCopy = new UberPermissionBo();
        try {
            PropertyUtils.copyProperties((Object)permissionSearchResultCopy, (Object)permissionSearchResult);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("permissionId", permissionSearchResultCopy.getId());
        List rolePermissions = (List)KRADServiceLocator.getBusinessObjectService().findMatching(RolePermissionBo.class, criteria);
        ArrayList<RoleBo> assignedToRoles = new ArrayList<RoleBo>();
        for (RolePermissionBo rolePermissionImpl : rolePermissions) {
            assignedToRoles.add(this.getRoleImpl(rolePermissionImpl.getRoleId()));
        }
        permissionSearchResultCopy.setAssignedToRoles(assignedToRoles);
        return permissionSearchResultCopy;
    }
}

