/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleDao;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.impl.type.KimTypeLookupableHelperServiceImpl;
import org.kuali.rice.kim.lookup.KimLookupableHelperServiceImpl;
import org.kuali.rice.kim.util.KimCommonUtilsInternal;
import org.kuali.rice.kim.web.struts.form.IdentityManagementRoleDocumentForm;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.BeanPropertyComparator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public class RoleLookupableHelperServiceImpl
extends KimLookupableHelperServiceImpl {
    private static final Logger LOG = Logger.getLogger(RoleLookupableHelperServiceImpl.class);
    private List<Row> roleRows = new ArrayList<Row>();
    private List<Row> attrRows = new ArrayList<Row>();
    private RoleDao roleDao;
    private String typeId;
    private List<KimAttributeField> attrDefinitions;
    private static final String ROLE_ID_URL_KEY = "&id=";

    public List<HtmlData> getCustomActionUrls(BusinessObject bo, List pkNames) {
        RoleBo roleBo = (RoleBo)bo;
        ArrayList<HtmlData> anchorHtmlDataList = new ArrayList<HtmlData>();
        if (this.allowsNewOrCopyAction("IdentityManagementRoleDocument")) {
            anchorHtmlDataList.add(this.getEditRoleUrl(roleBo));
        }
        return anchorHtmlDataList;
    }

    protected HtmlData getEditRoleUrl(RoleBo roleBo) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "initiate");
        parameters.put("docTypeName", "IdentityManagementRoleDocument");
        parameters.put("roleId", roleBo.getId());
        if (StringUtils.isNotBlank((String)this.getReturnLocation())) {
            parameters.put("returnLocation", this.getReturnLocation());
        }
        String href = UrlFactory.parameterizeUrl((String)(KimCommonUtilsInternal.getKimBasePath() + "identityManagementRoleDocument.do"), (Properties)parameters);
        HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, "docHandler", "edit");
        return anchorHtmlData;
    }

    protected HtmlData getReturnAnchorHtmlData(BusinessObject businessObject, Properties parameters, LookupForm lookupForm, List returnKeys, BusinessObjectRestrictions businessObjectRestrictions) {
        RoleBo roleBo = (RoleBo)businessObject;
        HtmlData anchorHtmlData = super.getReturnAnchorHtmlData(businessObject, parameters, lookupForm, returnKeys, businessObjectRestrictions);
        KualiForm myForm = (KualiForm)GlobalVariables.getUserSession().retrieveObject(this.getDocFormKey());
        if ((myForm == null || !(myForm instanceof IdentityManagementRoleDocumentForm)) && KimTypeLookupableHelperServiceImpl.hasDerivedRoleTypeService(KimTypeBo.to((KimTypeBo)roleBo.getKimRoleType()))) {
            ((HtmlData.AnchorHtmlData)anchorHtmlData).setHref("");
        }
        return anchorHtmlData;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        fieldValues.remove("backLocation");
        fieldValues.remove("docFormKey");
        fieldValues.remove("docNum");
        List roles = this.roleDao.getRoles(fieldValues);
        return roles;
    }

    private List<KeyValue> getRoleTypeOptions() {
        ArrayList<KeyValue> options = new ArrayList<KeyValue>();
        options.add((KeyValue)new ConcreteKeyValue("", ""));
        Collection kimGroupTypes = KimApiServiceLocator.getKimTypeInfoService().findAllKimTypes();
        for (KimType kimType : kimGroupTypes) {
            if (!KimTypeLookupableHelperServiceImpl.hasRoleTypeService(kimType)) continue;
            String value = kimType.getNamespaceCode().trim() + ":" + kimType.getName().trim();
            options.add((KeyValue)new ConcreteKeyValue(kimType.getId(), value));
        }
        Collections.sort(options, new Comparator<KeyValue>(){

            @Override
            public int compare(KeyValue k1, KeyValue k2) {
                return k1.getValue().compareTo(k2.getValue());
            }
        });
        return options;
    }

    public List<Row> getRoleRows() {
        return this.roleRows;
    }

    public void setRoleRows(List<Row> roleRows) {
        this.roleRows = roleRows;
    }

    public RoleDao getRoleDao() {
        return this.roleDao;
    }

    public void setRoleDao(RoleDao roleDao) {
        this.roleDao = roleDao;
    }

    public List<KimAttributeField> getAttrDefinitions() {
        return this.attrDefinitions;
    }

    public void setAttrDefinitions(List<KimAttributeField> attrDefinitions) {
        this.attrDefinitions = attrDefinitions;
    }

    public List<Row> getAttrRows() {
        return this.attrRows;
    }

    public void setAttrRows(List<Row> attrRows) {
        this.attrRows = attrRows;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public List<Row> getRows() {
        new ArrayList();
        if (this.getRoleRows().isEmpty()) {
            List rows = super.getRows();
            ArrayList<Row> returnRows = new ArrayList<Row>();
            for (Row row : rows) {
                for (int i = row.getFields().size() - 1; i >= 0; --i) {
                    Field field = (Field)row.getFields().get(i);
                    if (!field.getPropertyName().equals("kimTypeId")) continue;
                    Field typeField = new Field();
                    typeField.setFieldLabel("Type");
                    typeField.setPropertyName("kimTypeId");
                    typeField.setFieldValidValues(this.getRoleTypeOptions());
                    typeField.setFieldType("dropdown");
                    typeField.setMaxLength(100);
                    typeField.setSize(40);
                    row.getFields().set(i, typeField);
                }
                returnRows.add(row);
            }
            this.setRoleRows(returnRows);
        }
        if (this.getAttrRows().isEmpty()) {
            return this.getRoleRows();
        }
        ArrayList<Row> fullRows = new ArrayList<Row>();
        fullRows.addAll(this.getRoleRows());
        return fullRows;
    }

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        List searchResults;
        HashMap<String, String> nonBlankFieldValues = new HashMap<String, String>();
        boolean includeAttr = false;
        for (String fieldName : fieldValues.keySet()) {
            if (!StringUtils.isNotBlank((String)fieldValues.get(fieldName))) continue;
            nonBlankFieldValues.put(fieldName, fieldValues.get(fieldName));
            if (!fieldName.contains(".")) continue;
            includeAttr = true;
        }
        if (includeAttr) {
            ModuleService eboModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(this.getBusinessObjectClass());
            BusinessObjectEntry ddEntry = eboModuleService.getExternalizableBusinessObjectDictionaryEntry(this.getBusinessObjectClass());
            HashMap filteredFieldValues = new HashMap();
            for (String fieldName : nonBlankFieldValues.keySet()) {
                if (!ddEntry.getAttributeNames().contains(fieldName) && !fieldName.contains(".")) continue;
                filteredFieldValues.put(fieldName, nonBlankFieldValues.get(fieldName));
            }
            searchResults = eboModuleService.getExternalizableBusinessObjectsListForLookup(this.getBusinessObjectClass(), filteredFieldValues, unbounded);
        } else {
            searchResults = super.getSearchResultsHelper(fieldValues, unbounded);
        }
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(searchResults, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    public static String getCustomRoleInquiryHref(String href) {
        return RoleLookupableHelperServiceImpl.getCustomRoleInquiryHref("", href);
    }

    static String getCustomRoleInquiryHref(String backLocation, String href) {
        Properties parameters = new Properties();
        String hrefPart = "";
        String docTypeAction = "";
        docTypeAction = StringUtils.isBlank((String)backLocation) || backLocation.contains("identityManagementRoleDocument.do") || !backLocation.contains("identityManagementGroupDocument.do") ? "identityManagementRoleInquiry.do" : "identityManagementGroupDocument.do";
        if (StringUtils.isNotBlank((String)href) && href.contains(ROLE_ID_URL_KEY)) {
            int idx1 = href.indexOf(ROLE_ID_URL_KEY);
            int idx2 = href.indexOf("&", idx1 + 1);
            if (idx2 < 0) {
                idx2 = href.length();
            }
            parameters.put("methodToCall", "inquiry");
            hrefPart = href.substring(idx1, idx2);
        }
        return UrlFactory.parameterizeUrl((String)(KimCommonUtilsInternal.getKimBasePath() + docTypeAction), (Properties)parameters) + hrefPart;
    }
}

