/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.rules.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.VersionHelper;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.document.rule.AttributeValidationHelper;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kim.rule.event.ui.AddMemberEvent;
import org.kuali.rice.kim.rule.ui.AddMemberRule;
import org.kuali.rice.kns.rules.DocumentRuleBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceBus;

public class KimDocumentMemberRule
extends DocumentRuleBase
implements AddMemberRule {
    private static final String ERROR_PATH = "member.memberId";
    protected AttributeValidationHelper attributeValidationHelper = new AttributeValidationHelper();

    @Override
    public boolean processAddMember(AddMemberEvent addMemberEvent) {
        VersionedService<RoleTypeService> versionedRoleTypeService;
        KimDocumentRoleMember newMember = addMemberEvent.getMember();
        IdentityManagementRoleDocument document = (IdentityManagementRoleDocument)addMemberEvent.getDocument();
        boolean rulePassed = true;
        if (newMember == null || StringUtils.isBlank((String)newMember.getMemberId())) {
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.empty.entry", new String[]{"Member"});
            return false;
        }
        if (!this.validAssignRole(newMember, document)) {
            return false;
        }
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)document.getKimType());
        Long newMemberFromTime = newMember.getActiveFromDate() == null ? 0L : newMember.getActiveFromDate().getTime();
        Long newMemberToTime = newMember.getActiveToDate() == null ? Long.MAX_VALUE : newMember.getActiveToDate().getTime();
        ArrayList<RemotableAttributeError> errorsAttributesAgainstExisting = new ArrayList();
        Map<String, String> newMemberQualifiers = this.attributeValidationHelper.convertQualifiersToMap(newMember.getQualifiers());
        for (KimDocumentRoleMember member : document.getMembers()) {
            Long memberFromTime = member.getActiveFromDate() == null ? 0L : member.getActiveFromDate().getTime();
            Long memberToTime = member.getActiveToDate() == null ? Long.MAX_VALUE : member.getActiveToDate().getTime();
            Map<String, String> oldMemberQualifiers = this.attributeValidationHelper.convertQualifiersToMap(member.getQualifiers());
            if (!member.getMemberId().equals(newMember.getMemberId()) || !member.getMemberTypeCode().equals(newMember.getMemberTypeCode()) || (newMemberFromTime < memberFromTime || newMemberFromTime >= memberToTime) && (newMemberToTime < memberFromTime || newMemberToTime > memberToTime)) continue;
            errorsAttributesAgainstExisting = kimTypeService.validateAttributesAgainstExisting(document.getKimType().getId(), newMemberQualifiers, oldMemberQualifiers);
            validationErrors.addAll(this.attributeValidationHelper.convertErrorsForMappedFields(ERROR_PATH, errorsAttributesAgainstExisting));
            if (errorsAttributesAgainstExisting.isEmpty()) continue;
            rulePassed = false;
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.duplicate.entry", new String[]{"Member"});
            break;
        }
        boolean shouldNotValidate = newMember.isRole();
        if (kimTypeService != null && ObjectUtils.isNotNull((Object)document.getKimType()) && StringUtils.isNotBlank((String)document.getKimType().getServiceName()) && (versionedRoleTypeService = this.getVersionedRoleTypeService(document.getKimType())) != null) {
            boolean versionOk = VersionHelper.compareVersion((String)versionedRoleTypeService.getVersion(), (String)"2.1.2") != -1;
            shouldNotValidate = versionOk ? versionedRoleTypeService.getService().shouldValidateQualifiersForMemberType(MemberType.fromCode((String)newMember.getMemberTypeCode())) : false;
        }
        if (kimTypeService != null && !shouldNotValidate) {
            List localErrors = kimTypeService.validateAttributes(document.getKimType().getId(), this.attributeValidationHelper.convertQualifiersToMap(newMember.getQualifiers()));
            validationErrors.addAll(this.attributeValidationHelper.convertErrors("member", this.attributeValidationHelper.convertQualifiersToAttrIdxMap(newMember.getQualifiers()), localErrors));
        }
        if (!validationErrors.isEmpty()) {
            this.attributeValidationHelper.moveValidationErrorsToErrorMap(validationErrors);
            rulePassed = false;
        }
        return rulePassed;
    }

    protected boolean validAssignRole(KimDocumentRoleMember roleMember, IdentityManagementRoleDocument document) {
        boolean rulePassed = true;
        if (StringUtils.isNotEmpty((String)document.getRoleNamespace())) {
            HashMap<String, String> roleDetails = new HashMap<String, String>();
            roleDetails.put("namespaceCode", document.getRoleNamespace());
            roleDetails.put("roleName", document.getRoleName());
            if (!KimDocumentMemberRule.getDocumentDictionaryService().getDocumentAuthorizer((Document)document).isAuthorizedByTemplate((Object)document, "KR-IDM", "Assign Role", GlobalVariables.getUserSession().getPerson().getPrincipalId(), roleDetails, null)) {
                GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.assign.role", new String[]{document.getRoleNamespace(), document.getRoleName()});
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    protected VersionedService<RoleTypeService> getVersionedRoleTypeService(KimType typeInfo) {
        String serviceName = typeInfo.getServiceName();
        if (serviceName != null) {
            String version = "2.0.0";
            RoleTypeService roleTypeService = null;
            try {
                KimTypeService service;
                ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
                Endpoint endpoint = serviceBus.getEndpoint(QName.valueOf(serviceName));
                if (endpoint != null) {
                    version = endpoint.getServiceConfiguration().getServiceVersion();
                }
                roleTypeService = (service = (KimTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(serviceName))) != null && service instanceof RoleTypeService ? (RoleTypeService)service : (RoleTypeService)KimImplServiceLocator.getService((String)"kimNoMembersRoleTypeService");
            }
            catch (Exception ex) {
                roleTypeService = (RoleTypeService)KimImplServiceLocator.getService((String)"kimNoMembersRoleTypeService");
            }
            return new VersionedService<RoleTypeService>(version, roleTypeService);
        }
        return null;
    }

    private static class VersionedService<T> {
        String version;
        T service;

        VersionedService(String version, T service) {
            this.version = version;
            this.service = service;
        }

        T getService() {
            return this.service;
        }

        String getVersion() {
            return this.version;
        }
    }
}

