/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.rules.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.document.rule.AttributeValidationHelper;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.rule.event.ui.AddDelegationMemberEvent;
import org.kuali.rice.kim.rule.ui.AddDelegationMemberRule;
import org.kuali.rice.kns.rules.DocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class RoleDocumentDelegationMemberRule
extends DocumentRuleBase
implements AddDelegationMemberRule {
    public static final String ERROR_PATH = "document.delegationMember.memberId";
    protected AttributeValidationHelper attributeValidationHelper = new AttributeValidationHelper();

    @Override
    public boolean processAddDelegationMember(AddDelegationMemberEvent addDelegationMemberEvent) {
        RoleDocumentDelegationMember newMember = addDelegationMemberEvent.getDelegationMember();
        IdentityManagementRoleDocument document = (IdentityManagementRoleDocument)addDelegationMemberEvent.getDocument();
        boolean rulePassed = true;
        if (newMember == null || StringUtils.isBlank((String)newMember.getMemberId())) {
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.empty.entry", new String[]{"Delegation Member"});
            return false;
        }
        if (StringUtils.isBlank((String)newMember.getRoleMemberId())) {
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.empty.entry", new String[]{"Role Member"});
            return false;
        }
        ArrayList<Map<String, String>> mapListToValidate = new ArrayList<Map<String, String>>();
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)document.getKimType());
        for (RoleDocumentDelegationMember roleMember : document.getDelegationMembers()) {
            Map<String, String> mapToValidate = this.attributeValidationHelper.convertQualifiersToMap(roleMember.getQualifiers());
            mapListToValidate.add(mapToValidate);
        }
        int i = 0;
        for (RoleDocumentDelegationMember member : document.getDelegationMembers()) {
            List localErrors = kimTypeService.validateUniqueAttributes(document.getKimType().getId(), this.attributeValidationHelper.convertQualifiersToMap(newMember.getQualifiers()), this.attributeValidationHelper.convertQualifiersToMap(member.getQualifiers()));
            if (!localErrors.isEmpty() && member.getMemberId().equals(newMember.getMemberId()) && member.getMemberTypeCode().equals(newMember.getMemberTypeCode())) {
                rulePassed = false;
                GlobalVariables.getMessageMap().putError("delegationMember.memberId", "error.duplicate.entry", new String[]{"Delegation Member"});
                break;
            }
            ++i;
        }
        if (kimTypeService != null && !newMember.isRole()) {
            List localErrors = kimTypeService.validateAttributes(document.getKimType().getId(), this.attributeValidationHelper.convertQualifiersToMap(newMember.getQualifiers()));
            validationErrors.addAll(this.attributeValidationHelper.convertErrors("delegationMember", this.attributeValidationHelper.convertQualifiersToAttrIdxMap(newMember.getQualifiers()), localErrors));
        }
        if (!validationErrors.isEmpty()) {
            this.attributeValidationHelper.moveValidationErrorsToErrorMap(validationErrors);
            rulePassed = false;
        }
        return rulePassed;
    }
}

