/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service;

import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.impl.group.GroupInternalService;
import org.kuali.rice.kim.service.UiDocumentService;
import org.kuali.rice.kim.service.dao.UiDocumentServiceDAO;

public final class KIMServiceLocatorInternal {
    private static final Logger LOG = Logger.getLogger(KIMServiceLocatorInternal.class);
    public static final String KIM_RUN_MODE_PROPERTY = "kim.mode";
    public static final String KIM_UI_DOCUMENT_SERVICE = "kimUiDocumentService";
    public static final String GROUP_INTERNAL_SERVICE = "groupInternalService";
    public static final String UI_DOCUMENT_SERVICE_DAO = "uiDocumentServiceDAO";

    public static Object getService(String serviceName) {
        return KIMServiceLocatorInternal.getBean(serviceName);
    }

    public static Object getBean(String serviceName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching service " + serviceName));
        }
        QName name = new QName(serviceName);
        RunMode kimRunMode = RunMode.valueOf((String)ConfigContext.getCurrentContextConfig().getProperty(KIM_RUN_MODE_PROPERTY));
        if (kimRunMode == RunMode.REMOTE || kimRunMode == RunMode.THIN) {
            name = new QName("KIM", serviceName);
        }
        return GlobalResourceLoader.getResourceLoader().getService(name);
    }

    public static UiDocumentService getUiDocumentService() {
        return (UiDocumentService)KIMServiceLocatorInternal.getService(KIM_UI_DOCUMENT_SERVICE);
    }

    public static GroupInternalService getGroupInternalService() {
        return (GroupInternalService)KIMServiceLocatorInternal.getService(GROUP_INTERNAL_SERVICE);
    }

    public static UiDocumentServiceDAO getUiDocumentServiceDAO() {
        return (UiDocumentServiceDAO)KIMServiceLocatorInternal.getBean(UI_DOCUMENT_SERVICE_DAO);
    }
}

