/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.service.dao.UiDocumentServiceDAO;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class UiDocumentServiceDAOJdbcImpl
implements UiDocumentServiceDAO {
    public static final Logger LOG = Logger.getLogger(UiDocumentServiceDAOJdbcImpl.class);
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = new TransactionAwareDataSourceProxy(dataSource);
    }

    @Override
    public Map<String, Group> findGroupsForRole(final String roleId) {
        final HashMap<String, Group> roleGroupMembers = new HashMap<String, Group>();
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        Map results = (Map)template.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                String sql = " SELECT GRP_ID, GRP_NM, NMSPC_CD, KIM_TYP_ID, ACTV_IND FROM KRIM_GRP_T G, KRIM_ROLE_MBR_T RM WHERE G.GRP_ID = RM.MBR_ID AND GRP_ID IN (SELECT MBR_ID FROM KRIM_ROLE_MBR_T WHERE MBR_TYP_CD = '" + MemberType.GROUP.getCode() + "' AND ROLE_ID = '" + roleId + "')";
                LOG.debug((Object)("Query to find Entity Names for role " + roleId + ":" + sql));
                PreparedStatement statement = connection.prepareStatement(sql);
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<Map<String, Group>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<String, Group> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String groupId = rs.getString(1);
                        String groupName = rs.getString(2);
                        String groupNameSpace = rs.getString(3);
                        String kimTypeId = rs.getString(4);
                        String activeInd = rs.getString(5);
                        Group.Builder builder = Group.Builder.create((String)groupNameSpace, (String)groupName, (String)kimTypeId);
                        builder.setId(groupId);
                        builder.build();
                        if (activeInd.equalsIgnoreCase("Y")) {
                            builder.setActive(true);
                        }
                        roleGroupMembers.put(groupId, builder.build());
                    }
                }
                return roleGroupMembers;
            }
        });
        return roleGroupMembers;
    }

    @Override
    public Map<String, EntityName> findEntityNamesForRole(final String roleId) {
        final HashMap<String, EntityName> entityNamesForPrincipals = new HashMap<String, EntityName>();
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        Map results = (Map)template.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                String sql = "SELECT EN.ENTITY_NM_ID, EN.ENTITY_ID, EN.FIRST_NM, EN.LAST_NM, EP.SUPPRESS_NM_IND FROM KRIM_PRNCPL_T KP, KRIM_ENTITY_NM_T EN LEFT JOIN KRIM_ENTITY_PRIV_PREF_T EP ON EN.ENTITY_ID = EP.ENTITY_ID WHERE EN.ACTV_IND='Y' AND EN.DFLT_IND='Y' AND EN.NM_TYP_CD='PRFR' AND EN.ENTITY_ID = KP.ENTITY_ID  AND KP.PRNCPL_ID IN (SELECT MBR_ID FROM KRIM_ROLE_MBR_T WHERE ROLE_ID = '" + roleId + "')";
                LOG.debug((Object)("Query to find Entity Names for role " + roleId + ":" + sql));
                PreparedStatement statement = connection.prepareStatement(sql);
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<Map<String, EntityName>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<String, EntityName> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        String id = rs.getString(1);
                        String entityId = rs.getString(2);
                        String firstName = rs.getString(3);
                        String lastName = rs.getString(4);
                        String suppressName = rs.getString(5);
                        boolean suppressNameBoolean = false;
                        if ("Y".equalsIgnoreCase(suppressName)) {
                            suppressNameBoolean = true;
                        }
                        EntityName.Builder builder = EntityName.Builder.create((String)id, (String)entityId, (String)firstName, (String)lastName, (boolean)suppressNameBoolean);
                        builder.setActive(true);
                        builder.setDefaultValue(true);
                        EntityName entityName = builder.build();
                        entityNamesForPrincipals.put(entityName.getEntityId(), entityName);
                    }
                }
                return entityNamesForPrincipals;
            }
        });
        return entityNamesForPrincipals;
    }
}

