/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.web.struts.action;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.GroupDocumentMember;
import org.kuali.rice.kim.document.IdentityManagementGroupDocument;
import org.kuali.rice.kim.rule.event.ui.AddGroupMemberEvent;
import org.kuali.rice.kim.web.struts.action.IdentityManagementDocumentActionBase;
import org.kuali.rice.kim.web.struts.form.IdentityManagementGroupDocumentForm;
import org.kuali.rice.kns.web.struts.action.KualiTableRenderAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiTableRenderFormMetadata;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class IdentityManagementGroupDocumentAction
extends IdentityManagementDocumentActionBase
implements KualiTableRenderAction {
    public IdentityManagementGroupDocumentAction() {
        this.addMethodToCallToUncheckedList("changeMemberTypeCode");
        this.addMethodToCallToUncheckedList("changeNamespace");
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementGroupDocumentForm groupDocumentForm = (IdentityManagementGroupDocumentForm)form;
        if (StringUtils.isBlank((String)groupDocumentForm.getGroupId())) {
            String groupId = request.getParameter("id");
            groupDocumentForm.setGroupId(groupId);
        }
        String kimTypeId = request.getParameter("id");
        this.setKimType(kimTypeId, groupDocumentForm);
        KualiTableRenderFormMetadata memberTableMetadata = groupDocumentForm.getMemberTableMetadata();
        if (groupDocumentForm.getMemberRows() != null) {
            memberTableMetadata.jumpToPage(memberTableMetadata.getViewedPageNumber(), groupDocumentForm.getMemberRows().size(), groupDocumentForm.getRecordsPerPage());
            memberTableMetadata.sort(groupDocumentForm.getMemberRows(), groupDocumentForm.getRecordsPerPage());
        }
        ActionForward forward = super.execute(mapping, (ActionForm)groupDocumentForm, request, response);
        groupDocumentForm.setCanAssignGroup(this.validAssignGroup(groupDocumentForm.getGroupDocument()));
        return forward;
    }

    protected void setKimType(String kimTypeId, IdentityManagementGroupDocumentForm groupDocumentForm) {
        if (StringUtils.isNotBlank((String)kimTypeId)) {
            KimType kType = KimApiServiceLocator.getKimTypeInfoService().getKimType(kimTypeId);
            groupDocumentForm.setKimType(kType);
            if (groupDocumentForm.getGroupDocument() != null) {
                groupDocumentForm.getGroupDocument().setKimType(kType);
            }
        } else if (groupDocumentForm.getGroupDocument() != null && StringUtils.isNotBlank((String)groupDocumentForm.getGroupDocument().getGroupTypeId())) {
            groupDocumentForm.setKimType(KimApiServiceLocator.getKimTypeInfoService().getKimType(groupDocumentForm.getGroupDocument().getGroupTypeId()));
            groupDocumentForm.getGroupDocument().setKimType(groupDocumentForm.getKimType());
        }
    }

    protected void loadDocument(KualiDocumentFormBase form) throws WorkflowException {
        super.loadDocument(form);
        IdentityManagementGroupDocumentForm groupDocumentForm = (IdentityManagementGroupDocumentForm)form;
        this.setKimType(groupDocumentForm.getGroupId(), groupDocumentForm);
        groupDocumentForm.setMember(groupDocumentForm.getGroupDocument().getBlankMember());
        KualiTableRenderFormMetadata memberTableMetadata = groupDocumentForm.getMemberTableMetadata();
        if (groupDocumentForm.getMemberRows() != null) {
            memberTableMetadata.jumpToFirstPage(groupDocumentForm.getMemberRows().size(), groupDocumentForm.getRecordsPerPage());
        }
    }

    protected void createDocument(KualiDocumentFormBase form) throws WorkflowException {
        super.createDocument(form);
        IdentityManagementGroupDocumentForm groupDocumentForm = (IdentityManagementGroupDocumentForm)form;
        if (groupDocumentForm.getGroupId() == null) {
            groupDocumentForm.getGroupDocument().setKimType(groupDocumentForm.getKimType());
            groupDocumentForm.getGroupDocument().initializeDocumentForNewGroup();
            groupDocumentForm.setGroupId(groupDocumentForm.getGroupDocument().getGroupId());
            this.setKimType(groupDocumentForm.getGroupDocument().getGroupTypeId(), groupDocumentForm);
        } else {
            this.loadGroupIntoDocument(groupDocumentForm.getGroupId(), groupDocumentForm);
        }
        KualiTableRenderFormMetadata memberTableMetadata = groupDocumentForm.getMemberTableMetadata();
        if (groupDocumentForm.getMemberRows() != null) {
            memberTableMetadata.jumpToFirstPage(groupDocumentForm.getMemberRows().size(), groupDocumentForm.getRecordsPerPage());
        }
    }

    protected void loadGroupIntoDocument(String groupId, IdentityManagementGroupDocumentForm groupDocumentForm) {
        Group group = KimApiServiceLocator.getGroupService().getGroup(groupId);
        this.getUiDocumentService().loadGroupDoc(groupDocumentForm.getGroupDocument(), group);
    }

    @Override
    public String getActionName() {
        return "identityManagementGroupDocument.do";
    }

    protected boolean validAssignGroup(IdentityManagementGroupDocument document) {
        boolean rulePassed = true;
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)document.getGroupNamespace())) {
            additionalPermissionDetails.put("namespaceCode", document.getGroupNamespace());
            additionalPermissionDetails.put("groupName", document.getGroupName());
            additionalPermissionDetails.put("kimTypeName", document.getKimType().getName());
            if (!this.getDocumentHelperService().getDocumentAuthorizer((Document)document).isAuthorizedByTemplate((Object)document, "KR-IDM", "Populate Group", GlobalVariables.getUserSession().getPrincipalId(), additionalPermissionDetails, null)) {
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    public ActionForward changeMemberTypeCode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementGroupDocumentForm groupDocumentForm = (IdentityManagementGroupDocumentForm)form;
        groupDocumentForm.getMember().setMemberName("");
        return this.refresh(mapping, (ActionForm)groupDocumentForm, request, response);
    }

    public ActionForward addMember(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Principal principal;
        Group tempGroup;
        IdentityManagementGroupDocumentForm groupDocumentForm = (IdentityManagementGroupDocumentForm)form;
        GroupDocumentMember newMember = groupDocumentForm.getMember();
        if (StringUtils.isEmpty((String)newMember.getMemberId()) && StringUtils.isNotEmpty((String)newMember.getMemberName()) && StringUtils.isNotEmpty((String)newMember.getMemberNamespaceCode()) && StringUtils.equals((String)newMember.getMemberTypeCode(), (String)KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode()) && (tempGroup = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(newMember.getMemberNamespaceCode(), newMember.getMemberName())) != null) {
            newMember.setMemberId(tempGroup.getId());
        }
        if (StringUtils.isEmpty((String)newMember.getMemberId()) && StringUtils.isNotEmpty((String)newMember.getMemberName()) && StringUtils.equals((String)newMember.getMemberTypeCode(), (String)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode()) && (principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(newMember.getMemberName())) != null) {
            newMember.setMemberId(principal.getPrincipalId());
        }
        if (this.checkKimDocumentGroupMember(newMember) && KRADServiceLocatorWeb.getKualiRuleService().applyRules((KualiDocumentEvent)new AddGroupMemberEvent("", (Document)groupDocumentForm.getGroupDocument(), newMember))) {
            newMember.setDocumentNumber(groupDocumentForm.getDocument().getDocumentNumber());
            groupDocumentForm.getGroupDocument().addMember(newMember);
            groupDocumentForm.setMember(groupDocumentForm.getGroupDocument().getBlankMember());
            groupDocumentForm.getMemberTableMetadata().jumpToLastPage(groupDocumentForm.getMemberRows().size(), groupDocumentForm.getRecordsPerPage());
        }
        return mapping.findForward("basic");
    }

    protected boolean checkKimDocumentGroupMember(GroupDocumentMember newMember) {
        if (StringUtils.isBlank((String)newMember.getMemberTypeCode()) || StringUtils.isBlank((String)newMember.getMemberId())) {
            GlobalVariables.getMessageMap().putError("document.member.memberId", "error.empty.entry", new String[]{"Member Type Code and Member ID"});
            return false;
        }
        if (MemberType.PRINCIPAL.getCode().equals(newMember.getMemberTypeCode())) {
            Principal principalInfo = this.getIdentityService().getPrincipal(newMember.getMemberId());
            if (principalInfo == null) {
                GlobalVariables.getMessageMap().putError("document.member.memberId", "error.memberid.membertype.mismatch", new String[]{newMember.getMemberId()});
                return false;
            }
            newMember.setMemberName(principalInfo.getPrincipalName());
        } else if (MemberType.GROUP.getCode().equals(newMember.getMemberTypeCode())) {
            Group groupInfo = null;
            groupInfo = KimApiServiceLocator.getGroupService().getGroup(newMember.getMemberId());
            if (groupInfo == null) {
                GlobalVariables.getMessageMap().putError("document.member.memberId", "error.memberid.membertype.mismatch", new String[]{newMember.getMemberId()});
                return false;
            }
            newMember.setMemberName(groupInfo.getName());
            newMember.setMemberNamespaceCode(groupInfo.getNamespaceCode());
        } else if (MemberType.ROLE.getCode().equals(newMember.getMemberTypeCode())) {
            Role role = KimApiServiceLocator.getRoleService().getRole(newMember.getMemberId());
            if (role == null) {
                GlobalVariables.getMessageMap().putError("document.member.memberId", "error.memberid.membertype.mismatch", new String[]{newMember.getMemberId()});
                return false;
            }
            if (StringUtils.equals((String)newMember.getMemberTypeCode(), (String)MemberType.ROLE.getCode()) && !this.validateRole(newMember.getMemberId(), role, "document.member.memberId", "Role")) {
                return false;
            }
            newMember.setMemberName(role.getName());
            newMember.setMemberNamespaceCode(role.getNamespaceCode());
        }
        return true;
    }

    public ActionForward deleteMember(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementGroupDocumentForm groupDocumentForm = (IdentityManagementGroupDocumentForm)form;
        GroupDocumentMember memberToBeInactivated = groupDocumentForm.getGroupDocument().getMembers().get(this.getLineToDelete(request));
        Calendar cal = Calendar.getInstance();
        memberToBeInactivated.setActiveToDate(new Timestamp(cal.getTimeInMillis()));
        groupDocumentForm.getGroupDocument().getMembers().set(this.getLineToDelete(request), memberToBeInactivated);
        groupDocumentForm.setMember(groupDocumentForm.getGroupDocument().getBlankMember());
        return mapping.findForward("basic");
    }
}

