/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.lookup;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kns.lookup.LookupResults;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.lookup.LookupResultsSupportStrategyService;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.lookup.MultipleValueLookupMetadata;
import org.kuali.rice.kns.lookup.SelectedObjectIds;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.dao.PersistedLookupMetadataDao;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class LookupResultsServiceImpl
implements LookupResultsService {
    private BusinessObjectService businessObjectService;
    private PersistedLookupMetadataDao persistedLookupMetadataDao;
    private LookupResultsSupportStrategyService persistableBusinessObjectSupportStrategy;
    private LookupResultsSupportStrategyService dataDictionarySupportStrategy;

    public void persistResultsTable(String lookupResultsSequenceNumber, List<ResultRow> resultTable, String personId) throws Exception {
        String resultTableString = new String(Base64.encodeBase64((byte[])ObjectUtils.toByteArray(resultTable)));
        Timestamp now = CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp();
        LookupResults lookupResults = this.retrieveLookupResults(lookupResultsSequenceNumber);
        if (lookupResults == null) {
            lookupResults = new LookupResults();
            lookupResults.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        }
        lookupResults.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        lookupResults.setLookupPersonId(personId);
        lookupResults.setSerializedLookupResults(resultTableString);
        lookupResults.setLookupDate(now);
        this.businessObjectService.save((PersistableBusinessObject)lookupResults);
    }

    public void persistSelectedObjectIds(String lookupResultsSequenceNumber, Set<String> selectedObjectIds, String personId) throws Exception {
        SelectedObjectIds selectedObjectIdsBO = this.retrieveSelectedObjectIds(lookupResultsSequenceNumber);
        if (selectedObjectIdsBO == null) {
            selectedObjectIdsBO = new SelectedObjectIds();
            selectedObjectIdsBO.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        }
        selectedObjectIdsBO.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        selectedObjectIdsBO.setLookupPersonId(personId);
        selectedObjectIdsBO.setSelectedObjectIds(LookupUtils.convertSetOfObjectIdsToString(selectedObjectIds));
        selectedObjectIdsBO.setLookupDate(CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp());
        this.businessObjectService.save((PersistableBusinessObject)selectedObjectIdsBO);
    }

    protected LookupResults retrieveLookupResults(String lookupResultsSequenceNumber) throws Exception {
        HashMap<String, String> queryCriteria = new HashMap<String, String>();
        queryCriteria.put("lookupResultsSequenceNumber", lookupResultsSequenceNumber);
        LookupResults lookupResults = (LookupResults)this.businessObjectService.findByPrimaryKey(LookupResults.class, queryCriteria);
        return lookupResults;
    }

    protected SelectedObjectIds retrieveSelectedObjectIds(String lookupResultsSequenceNumber) throws Exception {
        HashMap<String, String> queryCriteria = new HashMap<String, String>();
        queryCriteria.put("lookupResultsSequenceNumber", lookupResultsSequenceNumber);
        SelectedObjectIds selectedObjectIds = (SelectedObjectIds)this.businessObjectService.findByPrimaryKey(SelectedObjectIds.class, queryCriteria);
        return selectedObjectIds;
    }

    public boolean isAuthorizedToAccessLookupResults(String lookupResultsSequenceNumber, String personId) {
        try {
            LookupResults lookupResults = this.retrieveLookupResults(lookupResultsSequenceNumber);
            return this.isAuthorizedToAccessLookupResults(lookupResults, personId);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isAuthorizedToAccessLookupResults(LookupResults lookupResults, String personId) {
        return this.isAuthorizedToAccessMultipleValueLookupMetadata((MultipleValueLookupMetadata)lookupResults, personId);
    }

    public boolean isAuthorizedToAccessSelectedObjectIds(String lookupResultsSequenceNumber, String personId) {
        try {
            SelectedObjectIds selectedObjectIds = this.retrieveSelectedObjectIds(lookupResultsSequenceNumber);
            return this.isAuthorizedToAccessSelectedObjectIds(selectedObjectIds, personId);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isAuthorizedToAccessSelectedObjectIds(SelectedObjectIds selectedObjectIds, String personId) {
        return this.isAuthorizedToAccessMultipleValueLookupMetadata((MultipleValueLookupMetadata)selectedObjectIds, personId);
    }

    public List<ResultRow> retrieveResultsTable(String lookupResultsSequenceNumber, String personId) throws Exception {
        LookupResults lookupResults = this.retrieveLookupResults(lookupResultsSequenceNumber);
        if (!this.isAuthorizedToAccessLookupResults(lookupResults, personId)) {
            throw new AuthorizationException(personId, "retrieve lookup results", "lookup sequence number " + lookupResultsSequenceNumber);
        }
        List resultTable = (List)ObjectUtils.fromByteArray((byte[])Base64.decodeBase64((byte[])lookupResults.getSerializedLookupResults().getBytes()));
        return resultTable;
    }

    public <T extends BusinessObject> Collection<T> retrieveSelectedResultBOs(String lookupResultsSequenceNumber, Class<T> boClass, String personId) throws Exception {
        LookupResultsSupportStrategyService supportService = this.getQualifingSupportStrategy(boClass);
        if (supportService == null) {
            throw new RuntimeException("BusinessObject class " + boClass.getName() + " cannot be used within a multiple value lookup; it either needs to be a PersistableBusinessObject or have both its primary keys and a lookupable defined in its data dictionary entry");
        }
        SelectedObjectIds selectedObjectIds = this.retrieveSelectedObjectIds(lookupResultsSequenceNumber);
        if (!this.isAuthorizedToAccessSelectedObjectIds(selectedObjectIds, personId)) {
            throw new AuthorizationException(personId, "retrieve lookup results", "lookup sequence number " + lookupResultsSequenceNumber);
        }
        Set setOfSelectedObjIds = LookupUtils.convertStringOfObjectIdsToSet((String)selectedObjectIds.getSelectedObjectIds());
        if (setOfSelectedObjIds.isEmpty()) {
            return new ArrayList();
        }
        return supportService.retrieveSelectedResultBOs(boClass, setOfSelectedObjIds);
    }

    protected LookupResultsSupportStrategyService getQualifingSupportStrategy(Class boClass) {
        if (this.getPersistableBusinessObjectSupportStrategy().qualifiesForStrategy(boClass)) {
            return this.getPersistableBusinessObjectSupportStrategy();
        }
        if (this.getDataDictionarySupportStrategy().qualifiesForStrategy(boClass)) {
            return this.getDataDictionarySupportStrategy();
        }
        return null;
    }

    public void clearPersistedLookupResults(String lookupResultsSequenceNumber) throws Exception {
        LookupResults lookupResults = this.retrieveLookupResults(lookupResultsSequenceNumber);
        if (lookupResults != null) {
            this.businessObjectService.delete((PersistableBusinessObject)lookupResults);
        }
    }

    public void clearPersistedSelectedObjectIds(String lookupResultsSequenceNumber) throws Exception {
        SelectedObjectIds selectedObjectIds = this.retrieveSelectedObjectIds(lookupResultsSequenceNumber);
        if (selectedObjectIds != null) {
            this.businessObjectService.delete((PersistableBusinessObject)selectedObjectIds);
        }
    }

    public String getLookupId(BusinessObject businessObject) {
        LookupResultsSupportStrategyService supportService = this.getQualifingSupportStrategy(businessObject.getClass());
        if (supportService == null) {
            return null;
        }
        return supportService.getLookupIdForBusinessObject(businessObject);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected boolean isAuthorizedToAccessMultipleValueLookupMetadata(MultipleValueLookupMetadata mvlm, String personId) {
        return personId.equals(mvlm.getLookupPersonId());
    }

    public void deleteOldLookupResults(Timestamp expirationDate) {
        this.persistedLookupMetadataDao.deleteOldLookupResults(expirationDate);
    }

    public void deleteOldSelectedObjectIds(Timestamp expirationDate) {
        this.persistedLookupMetadataDao.deleteOldSelectedObjectIds(expirationDate);
    }

    public PersistedLookupMetadataDao getPersistedLookupMetadataDao() {
        return this.persistedLookupMetadataDao;
    }

    public void setPersistedLookupMetadataDao(PersistedLookupMetadataDao persistedLookupMetadataDao) {
        this.persistedLookupMetadataDao = persistedLookupMetadataDao;
    }

    public LookupResultsSupportStrategyService getPersistableBusinessObjectSupportStrategy() {
        return this.persistableBusinessObjectSupportStrategy;
    }

    public LookupResultsSupportStrategyService getDataDictionarySupportStrategy() {
        return this.dataDictionarySupportStrategy;
    }

    public void setPersistableBusinessObjectSupportStrategy(LookupResultsSupportStrategyService persistableBusinessObjectSupportStrategy) {
        this.persistableBusinessObjectSupportStrategy = persistableBusinessObjectSupportStrategy;
    }

    public void setDataDictionarySupportStrategy(LookupResultsSupportStrategyService dataDictionarySupportStrategy) {
        this.dataDictionarySupportStrategy = dataDictionarySupportStrategy;
    }
}

