/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.impl.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;

public class KENConfigurer
extends ModuleConfigurer {
    public static final String KEN_DATASOURCE_OBJ = "ken.datasource";
    public static final String KCB_DATASOURCE_OBJ = "kcb.datasource";
    private DataSource dataSource;

    public KENConfigurer() {
        super("ken");
        this.setValidRunModes(Arrays.asList(RunMode.REMOTE, RunMode.LOCAL));
    }

    public List<String> getPrimarySpringFiles() {
        this.LOG.info((Object)("KENConfigurer:getPrimarySpringFiles: getRunMode => " + this.getRunMode()));
        ArrayList<String> springFileLocations = new ArrayList<String>();
        if (RunMode.REMOTE == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "KENRemoteSpringBeans.xml");
        } else if (RunMode.LOCAL == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "KENLocalSpringBeans.xml");
        }
        return springFileLocations;
    }

    public void addAdditonalToConfig() {
        this.configureDataSource();
    }

    private void configureDataSource() {
        if (this.getDataSource() != null) {
            ConfigContext.getCurrentContextConfig().putObject(KEN_DATASOURCE_OBJ, (Object)this.getDataSource());
            ConfigContext.getCurrentContextConfig().putObject(KCB_DATASOURCE_OBJ, (Object)this.getDataSource());
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

