/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.kew;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.identity.Id;
import org.kuali.rice.kew.api.identity.PrincipalName;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.api.rule.RuleExtension;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.GenericRoleAttribute;
import org.kuali.rice.kew.rule.QualifiedRoleName;
import org.kuali.rice.kew.workgroup.GroupNameId;

public class ChannelReviewerRoleAttribute
extends GenericRoleAttribute {
    private static final Logger LOG = Logger.getLogger(ChannelReviewerRoleAttribute.class);
    private static final List<RoleName> SUPPORTED_ROLES;

    public ChannelReviewerRoleAttribute() {
        super("channelReviewers");
        LOG.info((Object)"CHANNEL REVIEWER ROLE ATTRIBUTE CONSTRUCTOR");
    }

    @Override
    public boolean isMatch(DocumentContent docContent, List<RuleExtension> ruleExtensions) {
        LOG.info((Object)"CHANNEL REVIEWER ROLE ATTRIBUTE IS MATCH");
        return super.isMatch(docContent, ruleExtensions);
    }

    @Override
    public Map<String, String> getProperties() {
        LOG.info((Object)"CHANNEL REVIEWER ROLE ATTRIBUTE GETPROPERTIES");
        return null;
    }

    @Override
    public List<RoleName> getRoleNames() {
        LOG.info((Object)"CHANNEL REVIEWER ROLE ATTRIBUTE CALLED ROLENAMES");
        return SUPPORTED_ROLES;
    }

    @Override
    public List<String> getQualifiedRoleNames(String roleName, DocumentContent documentContent) {
        ArrayList<String> qrn = new ArrayList<String>(1);
        qrn.add(roleName);
        return qrn;
    }

    @Override
    protected List<Id> resolveRecipients(RouteContext routeContext, QualifiedRoleName qualifiedRoleName) {
        List<Map<String, String>> attrs;
        LOG.info((Object)"CHANNEL REVIEWER ROLE ATTRIBUTE CALLED");
        ArrayList<Id> ids = new ArrayList<Id>();
        LOG.info((Object)("DOC CONTENT:" + routeContext.getDocumentContent().getDocContent()));
        LOG.info((Object)("ATTR CONTENT:" + routeContext.getDocumentContent().getAttributeContent()));
        DocumentContent dc = routeContext.getDocumentContent();
        try {
            attrs = this.content.parseContent(dc.getAttributeContent());
        }
        catch (XPathExpressionException xpee) {
            throw new WorkflowRuntimeException("Error parsing ChannelReviewer role attribute content", (Throwable)xpee);
        }
        if (attrs.size() > 0) {
            Map<String, String> values = attrs.get(0);
            if (values != null) {
                for (Map.Entry<String, String> entry : values.entrySet()) {
                    Object id;
                    String name = entry.getKey();
                    String value = entry.getValue();
                    LOG.info((Object)("Entry: " + name + "=" + value));
                    if (name.startsWith("user")) {
                        LOG.info((Object)("Adding user: " + value));
                        id = new PrincipalName(value);
                        ids.add((Id)id);
                        continue;
                    }
                    if (name.startsWith("group")) {
                        LOG.info((Object)("Adding group: " + value));
                        id = new GroupNameId(value);
                        ids.add((Id)id);
                        continue;
                    }
                    LOG.error((Object)("Invalid attribute value: " + name + "=" + value));
                }
            }
        } else {
            LOG.debug((Object)"No attribute content found for ChannelReviewerRoleAttribute");
        }
        LOG.info((Object)("Returning ids: " + ids.size()));
        return ids;
    }

    static {
        RoleName reviewerRole = new RoleName(ChannelReviewerRoleAttribute.class.getName(), "reviewers", "Reviewers");
        ArrayList<RoleName> tmp = new ArrayList<RoleName>(1);
        tmp.add(reviewerRole);
        SUPPORTED_ROLES = Collections.unmodifiableList(tmp);
    }
}

