/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.postprocessor.kew;

import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.core.GlobalNotificationServiceLocator;
import org.kuali.rice.ken.document.kew.NotificationWorkflowDocument;
import org.kuali.rice.ken.service.NotificationMessageContentService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.AfterProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.BeforeProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.DeleteEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentLockingEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.PostProcessor;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class NotificationSenderFormPostProcessor
implements PostProcessor {
    private static final Logger LOG = Logger.getLogger(NotificationSenderFormPostProcessor.class);
    NotificationService notificationService;
    DataObjectService dataObjectService;
    NotificationMessageContentService messageContentService;

    public NotificationSenderFormPostProcessor() {
        this.notificationService = GlobalNotificationServiceLocator.getInstance().getNotificationService();
        this.dataObjectService = KRADServiceLocator.getDataObjectService();
        this.messageContentService = GlobalNotificationServiceLocator.getInstance().getNotificationMessageContentService();
    }

    public NotificationSenderFormPostProcessor(NotificationService notificationService, DataObjectService dataObjectService) {
        this.notificationService = notificationService;
        this.dataObjectService = dataObjectService;
    }

    public ProcessDocReport doActionTaken(ActionTakenEvent arg0) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport afterActionTaken(ActionType performed, ActionTakenEvent event) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport doDeleteRouteHeader(DeleteEvent arg0) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport doRouteLevelChange(DocumentRouteLevelChange arg0) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport doRouteStatusChange(DocumentRouteStatusChange arg0) throws Exception {
        LOG.debug((Object)("ENTERING NotificationSenderFormPostProcessor.doRouteStatusChange() for Notification Sender Form with document ID: " + arg0.getDocumentId()));
        if (arg0.getNewRouteStatus().equals("P")) {
            LOG.debug((Object)("Workflow status has changed to RESOLVED for Notification Sender Form with document ID: " + arg0.getDocumentId() + ".  We are now calling the NotificationService.sendNotification() service."));
            String proxyUserId = Util.getNotificationSystemUser();
            try {
                WorkflowDocument document = NotificationWorkflowDocument.loadNotificationDocument(proxyUserId, arg0.getDocumentId());
                LOG.debug((Object)("XML:" + document.getApplicationContent()));
                NotificationBo notification = this.messageContentService.parseSerializedNotificationXml(document.getApplicationContent().getBytes());
                LOG.debug((Object)("Notification Content: " + notification.getContent()));
                this.notificationService.sendNotification(notification);
                LOG.debug((Object)("NotificationService.sendNotification() was successfully called for Notification Sender Form with document ID: " + arg0.getDocumentId()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        LOG.debug((Object)("LEAVING NotificationSenderFormPostProcessor.doRouteStatusChange() for Notification Sender Form with document ID: " + arg0.getDocumentId()));
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport beforeProcess(BeforeProcessEvent beforeProcessEvent) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport afterProcess(AfterProcessEvent afterProcessEvent) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public List<String> getDocumentIdsToLock(DocumentLockingEvent documentLockingEvent) throws Exception {
        return null;
    }
}

