/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.deliverer.NotificationMessageDeliverer;
import org.kuali.rice.ken.deliverer.impl.KEWActionListMessageDeliverer;
import org.kuali.rice.ken.exception.NotificationAutoRemoveException;
import org.kuali.rice.ken.service.NotificationMessageDeliveryAutoRemovalService;
import org.kuali.rice.ken.service.NotificationMessageDeliveryService;
import org.kuali.rice.ken.service.ProcessingResult;
import org.kuali.rice.ken.service.impl.ConcurrentJob;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.transaction.PlatformTransactionManager;

public class NotificationMessageDeliveryAutoRemovalServiceImpl
extends ConcurrentJob<NotificationMessageDelivery>
implements NotificationMessageDeliveryAutoRemovalService {
    private DataObjectService dataObjectService;
    private NotificationMessageDeliveryService messageDeliveryService;

    public NotificationMessageDeliveryAutoRemovalServiceImpl(DataObjectService dataObjectService, PlatformTransactionManager txManager, ExecutorService executor, NotificationMessageDeliveryService messageDeliveryService) {
        super(txManager, executor);
        this.messageDeliveryService = messageDeliveryService;
        this.dataObjectService = dataObjectService;
    }

    @Override
    protected Collection<NotificationMessageDelivery> takeAvailableWorkItems() {
        return this.messageDeliveryService.takeMessageDeliveriesForAutoRemoval();
    }

    @Override
    protected Collection<String> processWorkItems(Collection<NotificationMessageDelivery> messageDeliveries) {
        NotificationMessageDelivery firstMessageDelivery = messageDeliveries.iterator().next();
        KEWActionListMessageDeliverer deliverer = new KEWActionListMessageDeliverer();
        ArrayList<String> successes = new ArrayList<String>();
        for (NotificationMessageDelivery delivery : messageDeliveries) {
            successes.addAll(this.autoRemove(deliverer, delivery));
        }
        return successes;
    }

    protected Collection<String> autoRemove(NotificationMessageDeliverer messageDeliverer, NotificationMessageDelivery messageDelivery) {
        ArrayList<String> successes = new ArrayList<String>(1);
        try {
            messageDeliverer.autoRemoveMessageDelivery(messageDelivery);
            this.LOG.debug((Object)("Auto-removal of message delivery '" + messageDelivery.getId() + "' for notification '" + messageDelivery.getNotification().getId() + "' was successful."));
            successes.add("Auto-removal of message delivery '" + messageDelivery.getId() + "' for notification '" + messageDelivery.getNotification().getId() + "' was successful.");
        }
        catch (NotificationAutoRemoveException nmde) {
            this.LOG.error((Object)("Error auto-removing message " + messageDelivery));
            throw new RuntimeException(nmde);
        }
        this.markAutoRemoved(messageDelivery);
        return successes;
    }

    protected void markAutoRemoved(NotificationMessageDelivery messageDelivery) {
        messageDelivery.setMessageDeliveryStatus("AUTO_REMOVED");
        messageDelivery.setLockedDateValue(null);
        this.dataObjectService.save((Object)messageDelivery, new PersistenceOption[0]);
    }

    @Override
    protected void unlockWorkItem(NotificationMessageDelivery delivery) {
        this.messageDeliveryService.unlockMessageDelivery(delivery);
    }

    @Override
    public ProcessingResult processAutoRemovalOfDeliveredNotificationMessageDeliveries() {
        this.LOG.debug((Object)("[" + new Timestamp(System.currentTimeMillis()).toString() + "] STARTING NOTIFICATION AUTO-REMOVAL PROCESSING"));
        ProcessingResult result = this.run();
        this.LOG.debug((Object)("[" + new Timestamp(System.currentTimeMillis()).toString() + "] FINISHED NOTIFICATION AUTO-REMOVAL PROCESSING - Successes = " + result.getSuccesses().size() + ", Failures = " + result.getFailures().size()));
        return result;
    }
}

