/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.kuali.rice.ken.service.NotificationRecipientService;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class NotificationRecipientServiceKimImpl
implements NotificationRecipientService {
    private static final Logger LOG = Logger.getLogger(NotificationRecipientServiceKimImpl.class);

    protected GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    @Override
    public String[] getGroupMembers(String groupRecipientId) {
        Group group = this.getGroupService().getGroup(groupRecipientId);
        List ids = this.getGroupService().getMemberPrincipalIds(group.getId());
        String[] array = new String[ids.size()];
        return ids.toArray(array);
    }

    @Override
    public String getUserDisplayName(String userId) {
        return null;
    }

    @Override
    public boolean isRecipientValid(String recipientId, String recipientType) {
        boolean b = false;
        if (KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode().equals(recipientType)) {
            b = this.isGroupRecipientValid(recipientId);
        } else if (KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode().equals(recipientType)) {
            b = this.isUserRecipientValid(recipientId);
        } else if (LOG.isEnabledFor((Priority)Level.ERROR)) {
            LOG.error((Object)"Recipient Type is neither of two acceptable values");
        }
        return b;
    }

    @Override
    public boolean isGroupRecipientValid(String groupRecipientId) {
        return KimApiServiceLocator.getGroupService().getGroup(groupRecipientId) != null;
    }

    @Override
    public boolean isUserRecipientValid(String principalName) {
        return KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalName) != null;
    }
}

