/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.document.kew.NotificationWorkflowDocument;
import org.kuali.rice.ken.service.NotificationMessageContentService;
import org.kuali.rice.ken.service.NotificationWorkflowDocumentService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class NotificationWorkflowDocumentServiceImpl
implements NotificationWorkflowDocumentService {
    private static Logger LOG = Logger.getLogger(NotificationWorkflowDocumentServiceImpl.class);
    private NotificationMessageContentService messageContentService;

    public NotificationWorkflowDocumentServiceImpl(NotificationMessageContentService messageContentService) {
        this.messageContentService = messageContentService;
    }

    @Override
    public String createAndAdHocRouteNotificationWorkflowDocument(NotificationMessageDelivery messageDelivery, String initiatorUserId, String recipientUserId, String annotation) {
        WorkflowDocument document = StringUtils.isNotBlank((String)messageDelivery.getNotification().getDocTypeName()) ? NotificationWorkflowDocument.createNotificationDocument(initiatorUserId, messageDelivery.getNotification().getDocTypeName()) : NotificationWorkflowDocument.createNotificationDocument(initiatorUserId);
        document.setApplicationDocumentId(messageDelivery.getId().toString());
        document.setApplicationContent(this.messageContentService.generateNotificationMessage(messageDelivery.getNotification(), messageDelivery.getUserRecipientId()));
        if (!StringUtils.isBlank((String)messageDelivery.getNotification().getTitle())) {
            document.setTitle(messageDelivery.getNotification().getTitle());
        } else {
            LOG.error((Object)("Encountered notification with no title set: Message Delivery #" + messageDelivery.getId() + ", Notification #" + messageDelivery.getNotification().getId()));
        }
        String actionRequested = "ACK".equals(messageDelivery.getNotification().getDeliveryType()) ? "K" : "F";
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(recipientUserId);
        document.adHocToPrincipal(ActionRequestType.fromCode((String)actionRequested), annotation, principal.getPrincipalId(), messageDelivery.getNotification().getProducer().getName(), true);
        document.route(annotation);
        return document.getDocumentId();
    }

    @Override
    public WorkflowDocument getNotificationWorkflowDocumentByDocumentId(String initiatorUserId, String workflowDocumentId) {
        return NotificationWorkflowDocument.loadNotificationDocument(initiatorUserId, workflowDocumentId);
    }

    @Override
    public void clearAllFyisAndAcknowledgeNotificationWorkflowDocument(String initiatorUserId, WorkflowDocument workflowDocument, String annotation) {
        List reqs = workflowDocument.getRootActionRequests();
        for (int i = 0; i < reqs.size(); ++i) {
            LOG.info((Object)("Action Request[" + i + "] = " + ((ActionRequest)reqs.get(i)).getActionRequested()));
            if (((ActionRequest)reqs.get(i)).getActionRequested().equals((Object)ActionRequestType.ACKNOWLEDGE)) {
                workflowDocument.acknowledge(annotation);
                continue;
            }
            if (((ActionRequest)reqs.get(i)).getActionRequested().equals((Object)ActionRequestType.FYI)) {
                workflowDocument.logAnnotation(annotation);
                workflowDocument.fyi();
                continue;
            }
            throw new WorkflowRuntimeException("Invalid notification action request in workflow document (" + workflowDocument.getDocumentId() + ") was encountered.  Should be either an acknowledge or fyi and was not.");
        }
    }

    @Override
    public void terminateWorkflowDocument(WorkflowDocument document) {
        document.superUserCancel("terminating document: documentId=" + document.getDocumentId() + ", appDocId=" + document.getApplicationDocumentId());
    }
}

