/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.ws.impl;

import java.io.IOException;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.ken.bo.NotificationResponseBo;
import org.kuali.rice.ken.service.NotificationMessageContentService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.service.ws.NotificationWebService;
import org.kuali.rice.ken.util.PerformanceLog;

public class NotificationWebServiceImpl
implements NotificationWebService {
    private static final Logger LOG = Logger.getLogger(NotificationWebServiceImpl.class);
    private NotificationService notificationService;
    private NotificationMessageContentService notificationMessageContentService;

    @Override
    public String sendNotification(String notificationMessageAsXml) throws RemoteException {
        NotificationResponseBo response;
        PerformanceLog.PerformanceStopWatch watch = PerformanceLog.startTimer("Time to send notification from web service");
        try {
            response = this.notificationService.sendNotification(notificationMessageAsXml);
        }
        catch (IOException ioe) {
            response = new NotificationResponseBo();
            response.setStatus("Failure");
            response.setMessage("Failed to process the message content: " + ioe.getMessage());
            LOG.error((Object)"Failed to process the message content", (Throwable)ioe);
        }
        catch (XmlException ixe) {
            response = new NotificationResponseBo();
            response.setStatus("Failure");
            response.setMessage("Failed to process the message content because the XML message provided to the system was invalid: " + ixe.getMessage());
            LOG.error((Object)"Failed to process the message content because the XML message provided to the system was invalid", (Throwable)ixe);
        }
        String responseAsXml = this.notificationMessageContentService.generateNotificationResponseMessage(response);
        watch.recordDuration();
        LOG.info((Object)("Notification response: " + response));
        return responseAsXml;
    }
}

