/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import org.apache.log4j.Logger;

public class ClassLoaderResourceResolver {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    private static final String XML_NAMESPACE_SCHEMA = "http://www.w3.org/2001/xml.xsd";
    private static final String XSD_NAMESPACE_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    protected final String base;
    protected final String prefix;

    public ClassLoaderResourceResolver() {
        this.base = "schema";
        this.prefix = "";
    }

    public ClassLoaderResourceResolver(String base, String prefix) {
        this.base = base;
        this.prefix = prefix;
    }

    protected String resolveSystemId(String systemId) {
        if (systemId.equals(XML_NAMESPACE_SCHEMA)) {
            return this.base + "/xml.xsd";
        }
        if (systemId.equals(XSD_NAMESPACE_SCHEMA)) {
            return this.base + "/XMLSchema.xsd";
        }
        if (systemId.startsWith("resource:" + this.prefix + "/")) {
            String path = this.base + "/" + systemId.substring(("resource:" + this.prefix + "/").length());
            if (!systemId.endsWith(".xsd") && !systemId.endsWith(".dtd")) {
                path = path + ".xsd";
            }
            return path;
        }
        return null;
    }
}

