/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.web.spring;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.kuali.rice.ken.service.NotificationAuthorizationService;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SecurityInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOG = Logger.getLogger(SecurityInterceptor.class);
    private static final String USER_IS_ADMIN_KEY = "userIsAdmin";
    protected NotificationAuthorizationService notificationAuthzService;

    public void setNotificationAuthorizationService(NotificationAuthorizationService notificationAuthzService) {
        this.notificationAuthzService = notificationAuthzService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String user = request.getRemoteUser();
        boolean isAdmin = false;
        if (user != null) {
            isAdmin = this.notificationAuthzService.isUserAdministrator(user);
        }
        LOG.debug((Object)("Setting request attribute 'userIsAdmin' to " + isAdmin));
        request.setAttribute(USER_IS_ADMIN_KEY, (Object)isAdmin);
        return true;
    }
}

