/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.web.spring;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.exception.ErrorList;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.ken.web.spring.BaseSendNotificationController;
import org.springframework.web.servlet.ModelAndView;

public class SendEventNotificationMessageController
extends BaseSendNotificationController {
    private static final Logger LOG = Logger.getLogger(SendEventNotificationMessageController.class);

    public ModelAndView sendEventNotificationMessage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String view = "SendEventNotificationMessage";
        LOG.debug((Object)("remoteUser: " + request.getRemoteUser()));
        Map<String, Object> model = this.setupModelForSendNotification(request);
        model.put("errors", new ErrorList());
        return new ModelAndView(view, model);
    }

    public ModelAndView submitEventNotificationMessage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String routeMessage = "This message was submitted via the event notification message submission form by user ";
        String viewName = "SendEventNotificationMessage";
        return this.submitNotificationMessage(request, routeMessage, viewName);
    }

    @Override
    protected Map<String, Object> setupModelForSendNotification(HttpServletRequest request) {
        Map<String, Object> model = super.setupModelForSendNotification(request);
        model.put("summary", request.getParameter("summary"));
        model.put("description", request.getParameter("description"));
        model.put("location", request.getParameter("location"));
        model.put("startDateTime", request.getParameter("startDateTime"));
        model.put("stopDateTime", request.getParameter("stopDateTime"));
        return model;
    }

    @Override
    protected NotificationBo createNotification(HttpServletRequest request, Map<String, Object> model, ErrorList errors) throws ErrorList {
        String stopDateTime;
        Date stopDate;
        NotificationBo notification = super.createNotification(request, model, errors);
        String message = this.getParameter(request, "message", model, errors, "You must fill in a message.");
        String summary = this.getParameter(request, "summary", model, errors, "You must fill in a summary.");
        String description = this.getParameter(request, "description", model, errors, "You must fill in a description.");
        String location = this.getParameter(request, "location", model, errors, "You must fill in a location.");
        String startDateTime = request.getParameter("startDateTime");
        Date startDate = this.getDate(startDateTime, errors, "You specified an invalid start date and time.  Please use the calendar picker.");
        if (startDate != null) {
            model.put("startDateTime", startDateTime);
        }
        if ((stopDate = this.getDate(stopDateTime = request.getParameter("stopDateTime"), errors, "You specified an invalid start date and time.  Please use the calendar picker.")) != null) {
            model.put("stopDateTime", stopDateTime);
        }
        if (stopDate != null && startDate != null && stopDate.before(startDate)) {
            errors.addError("Event Stop Date/Time cannot be before Event Start Date/Time.");
        }
        if (!errors.getErrors().isEmpty()) {
            throw errors;
        }
        NotificationContentTypeBo contentType = (NotificationContentTypeBo)((Object)Util.retrieveFieldReference("contentType", "name", "Event", NotificationContentTypeBo.class, this.dataObjectService, Boolean.TRUE));
        notification.setContentType(contentType);
        notification.setContent("<content xmlns=\"ns:notification/ContentTypeEvent\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"ns:notification/ContentTypeEvent resource:notification/ContentTypeEvent\"><message><![CDATA[" + message + "]]></message>" + "<event>\n" + "  <summary>" + summary + "</summary>\n" + "  <description>" + description + "</description>\n" + "  <location>" + location + "</location>\n" + "  <startDateTime>" + Util.toUIDateTimeString(startDate) + "</startDateTime>\n" + "  <stopDateTime>" + Util.toUIDateTimeString(stopDate) + "</stopDateTime>\n" + "</event>" + "</content>");
        return notification;
    }
}

