/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class ApproveAction
extends ActionTakenEvent {
    private static final Logger LOG = Logger.getLogger(ApproveAction.class);

    public ApproveAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        super("A", routeHeader, principal);
    }

    public ApproveAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation) {
        super("A", routeHeader, principal, annotation);
    }

    @Override
    public String validateActionRules() {
        return this.validateActionRules(this.getActionRequestService().findAllPendingRequests(this.routeHeader.getDocumentId()));
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Document is not in a state to be approved";
        }
        List<ActionRequestValue> filteredActionRequests = this.filterActionRequestsByCode(actionRequests, "A");
        if (!this.isActionCompatibleRequest(filteredActionRequests)) {
            return "No request for the user is compatible with the APPROVE action";
        }
        return "";
    }

    @Override
    public boolean isActionCompatibleRequest(List<ActionRequestValue> requests) {
        if (requests.isEmpty()) {
            return true;
        }
        if (this.routeHeader.isStateInitiated() || this.routeHeader.isStateSaved()) {
            return true;
        }
        boolean actionCompatible = false;
        Iterator<ActionRequestValue> ars = requests.iterator();
        ActionRequestValue actionRequest = null;
        while (ars.hasNext()) {
            actionRequest = ars.next();
            String request = actionRequest.getActionRequested();
            if (!"F".equals(request) && !"K".equals(request) && !"A".equals(request) && !"C".equals(request)) continue;
            actionCompatible = true;
            break;
        }
        return actionCompatible;
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        DocumentTypePolicy allowUnrequested;
        MDC.put((String)"docId", (Object)this.getRouteHeader().getDocumentId());
        this.updateSearchableAttributesIfPossible();
        LOG.debug((Object)("Approving document : " + this.annotation));
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findAllValidRequests(this.getPrincipal().getPrincipalId(), this.getDocumentId(), "A");
        if ((actionRequests == null || actionRequests.isEmpty()) && (allowUnrequested = this.getRouteHeader().getDocumentType().getAllowUnrequestedActionPolicy()) != null && !allowUnrequested.getPolicyValue().booleanValue()) {
            throw new InvalidActionTakenException("No request for the user is compatible with the APPROVE action. Doctype policy ALLOW_UNREQUESTED_ACTION is set to false and someone else likely just took action on the document.");
        }
        String errorMessage = this.validateActionRules(actionRequests);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        Recipient delegator = this.findDelegatorForActionRequests(actionRequests);
        LOG.debug((Object)"Record the approve action");
        ActionTakenValue actionTaken = this.saveActionTaken(delegator);
        LOG.debug((Object)"Deactivate all pending action requests");
        this.getActionRequestService().deactivateRequests(actionTaken, actionRequests);
        this.notifyActionTaken(actionTaken);
        boolean isException = this.getRouteHeader().isInException();
        boolean isSaved = this.getRouteHeader().isStateSaved();
        if (isException || isSaved) {
            String oldStatus = this.getRouteHeader().getDocRouteStatus();
            LOG.debug((Object)("Moving document back to Enroute from " + (String)KewApiConstants.DOCUMENT_STATUSES.get(oldStatus)));
            this.getRouteHeader().markDocumentEnroute();
            String newStatus = this.getRouteHeader().getDocRouteStatus();
            this.notifyStatusChange(newStatus, oldStatus);
            DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.getRouteHeader());
            this.setRouteHeader(routeHeaderValue);
        }
    }
}

