/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class ClearFYIAction
extends ActionTakenEvent {
    private static final Logger LOG = Logger.getLogger(ClearFYIAction.class);

    public ClearFYIAction(DocumentRouteHeaderValue rh, PrincipalContract principal) {
        super("F", rh, principal);
    }

    public ClearFYIAction(DocumentRouteHeaderValue rh, PrincipalContract principal, String annotation) {
        super("F", rh, principal, annotation);
    }

    @Override
    public String validateActionRules() {
        return this.validateActionRules(this.getActionRequestService().findAllPendingRequests(this.routeHeader.getDocumentId()));
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Document is not in a state to have FYI processed";
        }
        List<ActionRequestValue> filteredActionRequests = this.filterActionRequestsByCode(actionRequests, "F");
        if (!this.isActionCompatibleRequest((List)filteredActionRequests)) {
            return "No request for the user is compatible with the ClearFYI action";
        }
        return "";
    }

    public boolean isActionCompatibleRequest(List requests) {
        if (this.routeHeader.isStateInitiated() || this.routeHeader.isStateSaved()) {
            return true;
        }
        boolean actionCompatible = false;
        Iterator ars = requests.iterator();
        ActionRequestValue actionRequest = null;
        while (ars.hasNext()) {
            actionRequest = (ActionRequestValue)ars.next();
            if (!"F".equals(actionRequest.getActionRequested())) continue;
            actionCompatible = true;
            break;
        }
        return actionCompatible;
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        DocumentTypePolicy allowUnrequested;
        MDC.put((String)"docId", (Object)this.getRouteHeader().getDocumentId());
        this.updateSearchableAttributesIfPossible();
        LOG.debug((Object)("Clear FYI for document : " + this.annotation));
        LOG.debug((Object)"Checking to see if the action is legal");
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findAllValidRequests(this.getPrincipal().getPrincipalId(), this.getDocumentId(), "F");
        if ((actionRequests == null || actionRequests.isEmpty()) && (allowUnrequested = this.getRouteHeader().getDocumentType().getAllowUnrequestedActionPolicy()) != null && !allowUnrequested.getPolicyValue().booleanValue()) {
            throw new InvalidActionTakenException("No request for the user is compatible with the ClearFYI action. Doctype policy ALLOW_UNREQUESTED_ACTION is set to false and someone else likely just took action on the document.");
        }
        String errorMessage = this.validateActionRules(actionRequests);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        ActionTakenValue actionTaken = this.saveActionTaken(this.findDelegatorForActionRequests(actionRequests));
        LOG.debug((Object)"Deactivate all pending action requests");
        this.getActionRequestService().deactivateRequests(actionTaken, actionRequests);
        this.notifyActionTaken(actionTaken);
    }
}

