/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRemoteServiceConnectionException;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionRepositoryService;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.framework.document.attribute.SearchableAttribute;
import org.kuali.rice.kew.framework.document.search.AttributeFields;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCriteriaConfiguration;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCustomization;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCustomizationHandlerService;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCustomizer;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultSetConfiguration;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultValues;

public class DocumentSearchCustomizationHandlerServiceImpl
implements DocumentSearchCustomizationHandlerService {
    private static final Logger LOG = Logger.getLogger(DocumentSearchCustomizationHandlerServiceImpl.class);
    private ExtensionRepositoryService extensionRepositoryService;

    public DocumentSearchCriteriaConfiguration getDocumentSearchConfiguration(String documentTypeName, List<String> searchableAttributeNames) {
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new RiceIllegalArgumentException("documentTypeName was null or blank");
        }
        if (searchableAttributeNames == null) {
            throw new RiceIllegalArgumentException("searchableAttributeNames was null");
        }
        DocumentSearchCriteriaConfiguration.Builder configBuilder = DocumentSearchCriteriaConfiguration.Builder.create();
        if (CollectionUtils.isNotEmpty(searchableAttributeNames)) {
            try {
                ArrayList<AttributeFields> searchAttributeFields = new ArrayList<AttributeFields>();
                for (String searchableAttributeName : searchableAttributeNames) {
                    ExtensionDefinition extensionDefinition = this.getExtensionRepositoryService().getExtensionByName(searchableAttributeName);
                    if (extensionDefinition == null) {
                        throw new RiceIllegalArgumentException("Failed to locate a SearchableAttribute with the given name: " + searchableAttributeName);
                    }
                    SearchableAttribute searchableAttribute = this.loadSearchableAttribute(extensionDefinition);
                    List attributeSearchFields = searchableAttribute.getSearchFields(extensionDefinition, documentTypeName);
                    if (!CollectionUtils.isNotEmpty((Collection)attributeSearchFields)) continue;
                    searchAttributeFields.add(AttributeFields.create((String)searchableAttributeName, (List)attributeSearchFields));
                }
                configBuilder.setSearchAttributeFields(searchAttributeFields);
            }
            catch (RiceRemoteServiceConnectionException e) {
                LOG.warn((Object)("Unable to connect to load searchable attributes for document type: " + documentTypeName), (Throwable)e);
            }
        }
        return configBuilder.build();
    }

    public List<RemotableAttributeError> validateCriteria(DocumentSearchCriteria documentSearchCriteria, List<String> searchableAttributeNames) {
        if (documentSearchCriteria == null) {
            throw new RiceIllegalArgumentException("documentSearchCriteria was null or blank");
        }
        if (searchableAttributeNames == null) {
            throw new RiceIllegalArgumentException("searchableAttributeNames was null");
        }
        try {
            ArrayList searchFieldErrors = new ArrayList();
            for (String searchableAttributeName : searchableAttributeNames) {
                ExtensionDefinition extensionDefinition = this.getExtensionRepositoryService().getExtensionByName(searchableAttributeName);
                if (extensionDefinition == null) {
                    throw new RiceIllegalArgumentException("Failed to locate a SearchableAttribute with the given name: " + searchableAttributeName);
                }
                SearchableAttribute searchableAttribute = this.loadSearchableAttribute(extensionDefinition);
                List errors = searchableAttribute.validateDocumentAttributeCriteria(extensionDefinition, documentSearchCriteria);
                if (CollectionUtils.isEmpty((Collection)errors)) continue;
                searchFieldErrors.addAll(errors);
            }
            return Collections.unmodifiableList(searchFieldErrors);
        }
        catch (RiceRemoteServiceConnectionException e) {
            LOG.warn((Object)("Unable to connect to load searchable attributes for criteria: " + documentSearchCriteria), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public DocumentSearchCriteria customizeCriteria(DocumentSearchCriteria documentSearchCriteria, String customizerName) throws RiceIllegalArgumentException {
        if (documentSearchCriteria == null) {
            throw new RiceIllegalArgumentException("documentSearchCriteria was null");
        }
        if (StringUtils.isBlank((String)customizerName)) {
            throw new RiceIllegalArgumentException("customizerName was null or blank");
        }
        DocumentSearchCustomizer customizer = this.loadCustomizer(customizerName);
        return customizer.customizeCriteria(documentSearchCriteria);
    }

    public DocumentSearchCriteria customizeClearCriteria(DocumentSearchCriteria documentSearchCriteria, String customizerName) throws RiceIllegalArgumentException {
        if (documentSearchCriteria == null) {
            throw new RiceIllegalArgumentException("documentSearchCriteria was null");
        }
        if (StringUtils.isBlank((String)customizerName)) {
            throw new RiceIllegalArgumentException("customizerName was null or blank");
        }
        DocumentSearchCustomizer customizer = this.loadCustomizer(customizerName);
        return customizer.customizeClearCriteria(documentSearchCriteria);
    }

    public DocumentSearchResultValues customizeResults(DocumentSearchCriteria documentSearchCriteria, List<DocumentSearchResult> defaultResults, String customizerName) throws RiceIllegalArgumentException {
        if (documentSearchCriteria == null) {
            throw new RiceIllegalArgumentException("documentSearchCriteria was null");
        }
        if (defaultResults == null) {
            throw new RiceIllegalArgumentException("defaultResults was null");
        }
        if (StringUtils.isBlank((String)customizerName)) {
            throw new RiceIllegalArgumentException("customizerName was null or blank");
        }
        DocumentSearchCustomizer customizer = this.loadCustomizer(customizerName);
        return customizer.customizeResults(documentSearchCriteria, defaultResults);
    }

    public DocumentSearchResultSetConfiguration customizeResultSetConfiguration(DocumentSearchCriteria documentSearchCriteria, String customizerName) throws RiceIllegalArgumentException {
        if (documentSearchCriteria == null) {
            throw new RiceIllegalArgumentException("documentSearchCriteria was null");
        }
        if (StringUtils.isBlank((String)customizerName)) {
            throw new RiceIllegalArgumentException("customizerName was null or blank");
        }
        DocumentSearchCustomizer customizer = this.loadCustomizer(customizerName);
        return customizer.customizeResultSetConfiguration(documentSearchCriteria);
    }

    public Set<DocumentSearchCustomization> getEnabledCustomizations(String documentTypeName, String customizerName) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new RiceIllegalArgumentException("documentTypeName was null or blank");
        }
        if (StringUtils.isBlank((String)customizerName)) {
            throw new RiceIllegalArgumentException("customizerName was null or blank");
        }
        DocumentSearchCustomizer customizer = this.loadCustomizer(customizerName);
        HashSet<DocumentSearchCustomization> customizations = new HashSet<DocumentSearchCustomization>();
        if (customizer.isCustomizeCriteriaEnabled(documentTypeName)) {
            customizations.add(DocumentSearchCustomization.CRITERIA);
        }
        if (customizer.isCustomizeClearCriteriaEnabled(documentTypeName)) {
            customizations.add(DocumentSearchCustomization.CLEAR_CRITERIA);
        }
        if (customizer.isCustomizeResultsEnabled(documentTypeName)) {
            customizations.add(DocumentSearchCustomization.RESULTS);
        }
        if (customizer.isCustomizeResultSetFieldsEnabled(documentTypeName)) {
            customizations.add(DocumentSearchCustomization.RESULT_SET_FIELDS);
        }
        return Collections.unmodifiableSet(customizations);
    }

    private SearchableAttribute loadSearchableAttribute(ExtensionDefinition extensionDefinition) {
        Object searchableAttribute = ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition);
        if (searchableAttribute == null) {
            throw new RiceIllegalArgumentException("Failed to load SearchableAttribute for: " + extensionDefinition);
        }
        return (SearchableAttribute)searchableAttribute;
    }

    private DocumentSearchCustomizer loadCustomizer(String customizerName) {
        ExtensionDefinition extensionDefinition = this.getExtensionRepositoryService().getExtensionByName(customizerName);
        if (extensionDefinition == null) {
            throw new RiceIllegalArgumentException("Failed to locate a DocumentSearchCustomizer with the given name: " + customizerName);
        }
        DocumentSearchCustomizer customizer = (DocumentSearchCustomizer)ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition);
        if (customizer == null) {
            throw new RiceIllegalArgumentException("Failed to load DocumentSearchCustomizer for: " + extensionDefinition);
        }
        return customizer;
    }

    protected ExtensionRepositoryService getExtensionRepositoryService() {
        return this.extensionRepositoryService;
    }

    public void setExtensionRepositoryService(ExtensionRepositoryService extensionRepositoryService) {
        this.extensionRepositoryService = extensionRepositoryService;
    }
}

