/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.io.Serializable;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SqlBuilder;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeDateTime;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.docsearch.SearchableAttributeBase;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="KREW_DOC_HDR_EXT_DT_T")
@NamedQueries(value={@NamedQuery(name="SearchableAttributeDateTimeValue.FindByDocumentId", query="select s from SearchableAttributeDateTimeValue as s where s.documentId = :documentId"), @NamedQuery(name="SearchableAttributeDateTimeValue.FindByKey", query="select s from SearchableAttributeDateTimeValue as s where s.documentId = :documentId and s.searchableAttributeKey = :searchableAttributeKey")})
@AttributeOverrides(value={@AttributeOverride(name="searchableAttributeValueId", column=@Column(name="DOC_HDR_EXT_DT_ID"))})
public class SearchableAttributeDateTimeValue
extends SearchableAttributeBase
implements SearchableAttributeValue,
Serializable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger LOG = Logger.getLogger(SearchableAttributeDateTimeValue.class);
    private static final long serialVersionUID = 3045621112943214772L;
    private static final String ATTRIBUTE_DATABASE_TABLE_NAME = "KREW_DOC_HDR_EXT_DT_T";
    private static final boolean DEFAULT_WILDCARD_ALLOWANCE_POLICY = false;
    private static final boolean ALLOWS_RANGE_SEARCH = true;
    private static final boolean ALLOWS_CASE_INSENSITIVE_SEARCH = false;
    private static final String ATTRIBUTE_XML_REPRESENTATION = "datetime";
    @Column(name="VAL")
    private Timestamp searchableAttributeValue;

    public SearchableAttributeDateTimeValue() {
        this.ojbConcreteClass = this.getClass().getName();
    }

    @Override
    public void setupAttributeValue(String value) {
        this.setSearchableAttributeValue(this.convertStringToTimestamp(value));
    }

    private Timestamp convertStringToTimestamp(String value) {
        Timestamp t;
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        try {
            t = CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp(value);
        }
        catch (ParseException e) {
            t = null;
        }
        if (t == null) {
            String errorMsg = "Error converting timestamp value '" + value + "' to valid timestamp object.";
            LOG.error((Object)("setupAttributeValue() " + errorMsg));
            throw new RuntimeException(errorMsg);
        }
        return t;
    }

    @Override
    public void setupAttributeValue(ResultSet resultSet, String columnName) throws SQLException {
        Calendar c = Calendar.getInstance();
        c.clear(10);
        c.clear(12);
        c.clear(13);
        c.clear(14);
        this.setSearchableAttributeValue(resultSet.getTimestamp(columnName, c));
    }

    @Override
    public String getSearchableAttributeDisplayValue() {
        return this.formatAttributeValue(null);
    }

    private String formatAttributeValue(String formatPattern) {
        DateFormat df = this.getDateFormatToUse(formatPattern);
        return df.format(new Date(this.getSearchableAttributeValue().getTime()));
    }

    private DateFormat getDateFormatToUse(String parameterFormatPattern) {
        if (StringUtils.isNotBlank((String)parameterFormatPattern)) {
            return new SimpleDateFormat(parameterFormatPattern);
        }
        return RiceConstants.getDefaultDateFormat();
    }

    @Override
    public String getAttributeDataType() {
        return ATTRIBUTE_XML_REPRESENTATION;
    }

    @Override
    public String getAttributeTableName() {
        return ATTRIBUTE_DATABASE_TABLE_NAME;
    }

    @Override
    public boolean allowsWildcards() {
        return false;
    }

    @Override
    public boolean allowsCaseInsensitivity() {
        return false;
    }

    @Override
    public boolean allowsRangeSearches() {
        return true;
    }

    @Override
    public boolean isPassesDefaultValidation(String valueEntered) {
        return new SqlBuilder().isValidDate(valueEntered);
    }

    @Override
    public Boolean isRangeValid(String lowerValue, String upperValue) {
        if (this.allowsRangeSearches()) {
            Timestamp lowerTime = this.convertStringToTimestamp(lowerValue);
            Timestamp upperTime = this.convertStringToTimestamp(upperValue);
            if (lowerTime != null && upperTime != null) {
                return lowerTime.compareTo(upperTime) <= 0;
            }
            return true;
        }
        return null;
    }

    @Override
    public Timestamp getSearchableAttributeValue() {
        return this._persistence_get_searchableAttributeValue();
    }

    public void setSearchableAttributeValue(Timestamp searchableAttributeValue) {
        this._persistence_set_searchableAttributeValue(searchableAttributeValue);
    }

    public DocumentAttributeDateTime toDocumentAttribute() {
        DateTime dateTime = null;
        if (this.getSearchableAttributeValue() != null) {
            dateTime = new DateTime(this.getSearchableAttributeValue().getTime());
        }
        return DocumentAttributeFactory.createDateTimeAttribute((String)this.getSearchableAttributeKey(), dateTime);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new SearchableAttributeDateTimeValue();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "searchableAttributeValue") {
            return this.searchableAttributeValue;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "searchableAttributeValue") {
            this.searchableAttributeValue = (Timestamp)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Timestamp _persistence_get_searchableAttributeValue() {
        this._persistence_checkFetched("searchableAttributeValue");
        return this.searchableAttributeValue;
    }

    public void _persistence_set_searchableAttributeValue(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("searchableAttributeValue");
        this._persistence_propertyChange("searchableAttributeValue", this.searchableAttributeValue, timestamp);
        this.searchableAttributeValue = timestamp;
    }
}

