/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.NodeType;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;

public class NodeJotter {
    private static final Logger LOG = Logger.getLogger(NodeJotter.class);
    private static final String INDENT = "   ";

    public static void jotNodeInstance(DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        try {
            if (LOG.isDebugEnabled()) {
                List<RouteNodeInstance> initialNodeInstances = document.getInitialRouteNodeInstances();
                for (RouteNodeInstance initialNodeInstance : initialNodeInstances) {
                    NodeType nodeType = NodeType.fromNodeInstance(initialNodeInstance);
                    LOG.debug((Object)NodeJotter.orchestrateOutput(initialNodeInstance, nodeType, null, 0));
                }
            } else if (LOG.isInfoEnabled()) {
                NodeType nodeType = NodeType.fromNodeInstance(nodeInstance);
                LOG.info((Object)NodeJotter.outputNodeInstanceToLog(nodeInstance, nodeType, 0));
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Caught error attempting to jot node instance" + nodeInstance));
        }
    }

    private static String orchestrateOutput(RouteNodeInstance nodeInstance, NodeType nodeType, SplitJoinContext sjCtx, int indentDepth) throws Exception {
        String output = "";
        boolean isSplit = NodeType.SPLIT.equals(nodeType);
        boolean isJoin = NodeType.JOIN.equals(nodeType);
        if (isJoin && sjCtx != null) {
            sjCtx.joinNodeInstance = nodeInstance;
            return output;
        }
        SplitJoinContext newSplitJoinContext = null;
        if (isSplit) {
            newSplitJoinContext = new SplitJoinContext(nodeInstance);
        }
        output = output + NodeJotter.outputNodeInstanceToLog(nodeInstance, nodeType, indentDepth);
        for (RouteNodeInstance nextNodeInstance : nodeInstance.getNextNodeInstances()) {
            nodeType = NodeType.fromNodeInstance(nextNodeInstance);
            if (newSplitJoinContext != null) {
                output = output + NodeJotter.orchestrateOutput(nextNodeInstance, nodeType, newSplitJoinContext, indentDepth + 1);
                continue;
            }
            output = output + NodeJotter.orchestrateOutput(nextNodeInstance, nodeType, sjCtx, indentDepth + 1);
        }
        if (isSplit && newSplitJoinContext != null && newSplitJoinContext.joinNodeInstance != null) {
            nodeType = NodeType.fromNodeInstance(newSplitJoinContext.joinNodeInstance);
            output = output + NodeJotter.orchestrateOutput(newSplitJoinContext.joinNodeInstance, nodeType, sjCtx, indentDepth);
        }
        return output;
    }

    private static String outputNodeInstanceToLog(RouteNodeInstance nodeInstance, NodeType nodeType, int indentDepth) throws Exception {
        String memAddress = nodeInstance.toString().split("@")[1];
        String dataIndent = NodeJotter.getIndent(indentDepth + 1);
        String output = NodeJotter.getIndent(indentDepth) + "[NODE type=" + nodeType.getName() + "]\n" + dataIndent + "Name: " + nodeInstance.getName() + "(" + memAddress + ")\n";
        output = output + dataIndent + "State: ";
        Iterator<NodeState> iterator = nodeInstance.getState().iterator();
        while (iterator.hasNext()) {
            NodeState nodeState = iterator.next();
            output = output + nodeState.getKey() + "=" + nodeState.getValue();
            if (!iterator.hasNext()) continue;
            output = output + ",";
        }
        output = output + "\n" + dataIndent + "Status Flags: initial=" + nodeInstance.isInitial() + ", active=" + nodeInstance.isActive() + ", complete=" + nodeInstance.isComplete();
        output = output + (nodeInstance.getProcess() == null ? "" : "\n" + dataIndent + "ProcessDefinition Name: " + nodeInstance.getProcess().getName());
        output = output + "\n";
        return output;
    }

    private static String getIndent(int indentDepth) {
        StringBuffer buffer = new StringBuffer();
        for (int depth = 0; depth < indentDepth; ++depth) {
            buffer.append(INDENT);
        }
        return buffer.toString();
    }

    private static class SplitJoinContext {
        public RouteNodeInstance splitNodeInstance;
        public RouteNodeInstance joinNodeInstance;

        public SplitJoinContext(RouteNodeInstance splitNodeInstance) {
            this.splitNodeInstance = splitNodeInstance;
        }
    }
}

