/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.var.schemes;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.PropertiesUtil;
import org.kuali.rice.kew.engine.node.var.Property;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;

public class ResourceScheme
implements PropertyScheme {
    private static final Logger LOG = Logger.getLogger(ResourceScheme.class);

    @Override
    public String getName() {
        return "resource";
    }

    @Override
    public String getShortName() {
        return "res";
    }

    @Override
    public Object load(Property property, RouteContext context) {
        boolean relative = false;
        String resource = property.locator;
        String resStr = property.locator + (relative ? "(" + resource + ")" : "");
        LOG.info((Object)("Reading resource " + resStr + "..."));
        InputStream is = this.getClass().getResourceAsStream(resource);
        if (is == null) {
            throw new RuntimeException("Resource not found: " + resStr);
        }
        try {
            return PropertiesUtil.readResource(is);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error loading resource: " + resStr, ioe);
        }
    }

    public String toString() {
        return "[ResourceScheme]";
    }
}

